/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.mt.mt9xx;

import com.prowidesoftware.swift.model.MtSwiftMessage;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.Field13D;
import com.prowidesoftware.swift.model.field.Field20;
import com.prowidesoftware.swift.model.field.Field21;
import com.prowidesoftware.swift.model.field.Field25;
import com.prowidesoftware.swift.model.field.Field25P;
import com.prowidesoftware.swift.model.field.Field28;
import com.prowidesoftware.swift.model.field.Field60F;
import com.prowidesoftware.swift.model.field.Field62F;
import com.prowidesoftware.swift.model.field.Field64;
import com.prowidesoftware.swift.model.field.Field65;
import com.prowidesoftware.swift.model.field.Field86;
import com.prowidesoftware.swift.model.field.Field90C;
import com.prowidesoftware.swift.model.field.Field90D;
import com.prowidesoftware.swift.model.mt.AbstractMT;
import com.prowidesoftware.swift.utils.Lib;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;

public class MT941
extends AbstractMT
implements Serializable {
    public static final int SRU = 2020;
    private static final long serialVersionUID = 1L;
    private static final transient Logger log = Logger.getLogger(MT941.class.getName());
    public static final String NAME = "941";

    public MT941(SwiftMessage m) {
        super(m);
        this.sanityCheck(m);
    }

    public MT941(MtSwiftMessage m) {
        this(m.message());
    }

    public static MT941 parse(MtSwiftMessage m) {
        if (m == null) {
            return null;
        }
        return new MT941(m);
    }

    public MT941() {
        this("TESTARZZ", "TESTARZZ");
    }

    public MT941(String sender, String receiver) {
        super(941, sender, receiver);
    }

    public MT941(String fin) {
        SwiftMessage parsed;
        if (fin != null && (parsed = MT941.read(fin)) != null) {
            this.m = parsed;
            this.sanityCheck(parsed);
        }
    }

    private void sanityCheck(SwiftMessage param) {
        if (param.isServiceMessage()) {
            log.warning("Creating an MT941 object from FIN content with a Service Message. Check if the MT941 you are intended to read is prepended with and ACK.");
        } else if (!StringUtils.equals((CharSequence)param.getType(), (CharSequence)this.getMessageType())) {
            log.warning("Creating an MT941 object from FIN content with message type " + param.getType());
        }
    }

    public static MT941 parse(String fin) {
        if (fin == null) {
            return null;
        }
        return new MT941(fin);
    }

    public MT941(InputStream stream) throws IOException {
        this(Lib.readStream(stream));
    }

    public static MT941 parse(InputStream stream) throws IOException {
        if (stream == null) {
            return null;
        }
        return new MT941(stream);
    }

    public MT941(File file) throws IOException {
        this(Lib.readFile(file));
    }

    public static MT941 parse(File file) throws IOException {
        if (file == null) {
            return null;
        }
        return new MT941(file);
    }

    @Override
    public String getMessageType() {
        return NAME;
    }

    @Override
    public MT941 append(SwiftTagListBlock block) {
        super.append(block);
        return this;
    }

    @Override
    public MT941 append(Tag ... tags) {
        super.append(tags);
        return this;
    }

    @Override
    public MT941 append(Field ... fields) {
        super.append(fields);
        return this;
    }

    public static final MT941 fromJson(String json) {
        return (MT941)AbstractMT.fromJson(json);
    }

    public Field20 getField20() {
        Tag t = this.tag("20");
        if (t != null) {
            return new Field20(t.getValue());
        }
        return null;
    }

    public Field21 getField21() {
        Tag t = this.tag("21");
        if (t != null) {
            return new Field21(t.getValue());
        }
        return null;
    }

    public Field25P getField25P() {
        Tag t = this.tag("25P");
        if (t != null) {
            return new Field25P(t.getValue());
        }
        return null;
    }

    public Field25 getField25() {
        Tag t = this.tag("25");
        if (t != null) {
            return new Field25(t.getValue());
        }
        return null;
    }

    public Field28 getField28() {
        Tag t = this.tag("28");
        if (t != null) {
            return new Field28(t.getValue());
        }
        return null;
    }

    public Field13D getField13D() {
        Tag t = this.tag("13D");
        if (t != null) {
            return new Field13D(t.getValue());
        }
        return null;
    }

    public Field60F getField60F() {
        Tag t = this.tag("60F");
        if (t != null) {
            return new Field60F(t.getValue());
        }
        return null;
    }

    public Field90D getField90D() {
        Tag t = this.tag("90D");
        if (t != null) {
            return new Field90D(t.getValue());
        }
        return null;
    }

    public Field90C getField90C() {
        Tag t = this.tag("90C");
        if (t != null) {
            return new Field90C(t.getValue());
        }
        return null;
    }

    public Field62F getField62F() {
        Tag t = this.tag("62F");
        if (t != null) {
            return new Field62F(t.getValue());
        }
        return null;
    }

    public Field64 getField64() {
        Tag t = this.tag("64");
        if (t != null) {
            return new Field64(t.getValue());
        }
        return null;
    }

    public Field86 getField86() {
        Tag t = this.tag("86");
        if (t != null) {
            return new Field86(t.getValue());
        }
        return null;
    }

    public List<Field65> getField65() {
        ArrayList<Field65> result = new ArrayList<Field65>();
        Tag[] tags = this.tags("65");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field65(tag.getValue()));
            }
        }
        return result;
    }
}

