/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.utils;

import com.prowidesoftware.ProwideException;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.stream.XMLInputFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;

public class SafeXmlUtils {
    private static final transient Logger log = Logger.getLogger(SafeXmlUtils.class.getName());

    private SafeXmlUtils() {
        throw new AssertionError();
    }

    public static DocumentBuilder documentBuilder() {
        return SafeXmlUtils.documentBuilder(false);
    }

    public static DocumentBuilder documentBuilder(boolean namespaceAware) {
        String feature = null;
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            feature = "http://javax.xml.XMLConstants/feature/secure-processing";
            dbf.setFeature(feature, true);
            feature = "http://xml.org/sax/features/external-general-entities";
            dbf.setFeature(feature, false);
            feature = "http://apache.org/xml/features/disallow-doctype-decl";
            dbf.setFeature(feature, true);
            dbf.setNamespaceAware(namespaceAware);
            return dbf.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new ProwideException("Error configuring the XML document builder. The feature " + feature + " is probably not supported by your XML processor.", e);
        }
    }

    public static XMLReader reader() throws ProwideException {
        return SafeXmlUtils.reader(false, null);
    }

    public static XMLReader reader(boolean namespaceAware, Schema schema) throws ProwideException {
        String feature = null;
        try {
            SAXParserFactory spf = SAXParserFactory.newInstance();
            feature = "http://javax.xml.XMLConstants/feature/secure-processing";
            spf.setFeature(feature, true);
            feature = "http://xml.org/sax/features/external-general-entities";
            spf.setFeature(feature, false);
            feature = "http://apache.org/xml/features/disallow-doctype-decl";
            spf.setFeature(feature, true);
            spf.setNamespaceAware(namespaceAware);
            if (schema != null) {
                spf.setSchema(schema);
            }
            SAXParser saxParser = spf.newSAXParser();
            XMLReader reader = saxParser.getXMLReader();
            feature = "http://apache.org/xml/features/disallow-doctype-decl";
            reader.setFeature(feature, true);
            feature = "http://apache.org/xml/features/nonvalidating/load-external-dtd";
            reader.setFeature(feature, false);
            feature = "http://xml.org/sax/features/external-general-entities";
            reader.setFeature(feature, false);
            feature = "http://xml.org/sax/features/external-parameter-entities";
            reader.setFeature(feature, false);
            return reader;
        }
        catch (ParserConfigurationException | SAXException e) {
            throw new ProwideException("Error configuring the XML parser. The feature " + feature + " is probably not supported by your XML processor.", e);
        }
    }

    public static XMLInputFactory inputFactory() {
        XMLInputFactory xif = XMLInputFactory.newInstance();
        xif.setProperty("javax.xml.stream.supportDTD", false);
        xif.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
        return xif;
    }

    public static Transformer transformer() {
        String feature = null;
        try {
            TransformerFactory tf = TransformerFactory.newInstance();
            feature = "http://javax.xml.XMLConstants/property/accessExternalDTD";
            tf.setAttribute(feature, "");
            feature = "http://javax.xml.XMLConstants/property/accessExternalStylesheet";
            tf.setAttribute(feature, "");
            return tf.newTransformer();
        }
        catch (TransformerConfigurationException e) {
            throw new ProwideException("Error configuring the XML transformer factory. The feature " + feature + " is probably not supported by your XML processor.", e);
        }
    }

    public static SchemaFactory schemaFactory() {
        String feature = null;
        try {
            SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            feature = "http://javax.xml.XMLConstants/property/accessExternalDTD";
            factory.setProperty(feature, "");
            return factory;
        }
        catch (SAXNotRecognizedException | SAXNotSupportedException e) {
            throw new ProwideException("Error configuring the schema factory. The feature " + feature + " is probably not supported by your XML processor.", e);
        }
    }

    public static Validator validator(Schema schema) {
        String feature = null;
        try {
            Validator validator = schema.newValidator();
            feature = "http://javax.xml.XMLConstants/property/accessExternalDTD";
            validator.setProperty(feature, "");
            feature = "http://javax.xml.XMLConstants/property/accessExternalSchema";
            validator.setProperty(feature, "");
            return validator;
        }
        catch (SAXNotRecognizedException | SAXNotSupportedException e) {
            throw new ProwideException("Error configuring the schema validator. The feature " + feature + " is probably not supported by your XML processor.", e);
        }
    }
}

