/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.utils;

import com.prowidesoftware.ProwideException;
import com.prowidesoftware.swift.model.BIC;
import com.prowidesoftware.swift.model.LogicalTerminalAddress;
import com.prowidesoftware.swift.model.SwiftBlock1;
import com.prowidesoftware.swift.model.SwiftBlock2;
import com.prowidesoftware.swift.model.SwiftBlock2Input;
import com.prowidesoftware.swift.model.SwiftBlock2Output;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

public class SwiftMessageComparator
implements Comparator<SwiftMessage> {
    private static final transient Logger log = Logger.getLogger(SwiftMessageComparator.class.getName());
    protected boolean ignoreEolsInMultiline = false;
    protected boolean ignoreHeaderSession = false;
    protected boolean ignoreTrailer = false;
    protected boolean ignoreBlock2OptionalFields = false;
    protected boolean ignoreLT = false;
    protected boolean ignoreLocationFlag = false;
    private List<String> tagnamesToIgnore = new ArrayList<String>();

    private static boolean isBlank(SwiftTagListBlock b) {
        return b == null || b.isEmpty();
    }

    @Override
    public int compare(SwiftMessage left, SwiftMessage right) {
        Validate.notNull((Object)left);
        Validate.notNull((Object)right);
        boolean b1 = this.compareB1(left.getBlock1(), right.getBlock1());
        boolean b2 = this.compareB2(left.getBlock2(), right.getBlock2());
        boolean b3 = this.compareTagListBlock(left.getBlock3(), right.getBlock3());
        boolean b4 = this.compareTagListBlock(left.getBlock4(), right.getBlock4());
        boolean b5 = this.ignoreTrailer || this.compareTagListBlock(left.getBlock5(), right.getBlock5());
        log.finest("b1=" + b1 + ", b2=" + b2 + ", b3=" + b3 + ", b4=" + b4 + ", b5=" + b5);
        return b1 && b2 && b3 && b4 && b5 ? 0 : 1;
    }

    public boolean compareB2(SwiftBlock2 left, SwiftBlock2 right) {
        if (left == null && right == null) {
            return true;
        }
        if (left == null || right == null) {
            return false;
        }
        if (!left.getClass().equals(right.getClass())) {
            return false;
        }
        if (left.isInput() && right.isInput()) {
            return this.compareB2Input((SwiftBlock2Input)left, (SwiftBlock2Input)right);
        }
        if (left.isOutput() && right.isOutput()) {
            return this.compareB2Output((SwiftBlock2Output)left, (SwiftBlock2Output)right);
        }
        throw new IllegalStateException();
    }

    private boolean compareB2Input(SwiftBlock2Input left, SwiftBlock2Input right) {
        boolean sameType = StringUtils.equals((CharSequence)left.getMessageType(), (CharSequence)right.getMessageType());
        boolean sameReceiverAddress = this.compareLTAddress(left.getReceiverAddress(), right.getReceiverAddress());
        boolean sameDeliveryMonitoring = this.ignoreBlock2OptionalFields || StringUtils.equals((CharSequence)left.getDeliveryMonitoring(), (CharSequence)right.getDeliveryMonitoring());
        boolean sameObsolescencePeriod = this.ignoreBlock2OptionalFields || StringUtils.equals((CharSequence)left.getObsolescencePeriod(), (CharSequence)right.getObsolescencePeriod());
        boolean samePriority = StringUtils.equals((CharSequence)left.getMessagePriority(), (CharSequence)right.getMessagePriority());
        return sameType && sameReceiverAddress && sameDeliveryMonitoring && sameObsolescencePeriod && samePriority;
    }

    private boolean compareB2Output(SwiftBlock2Output left, SwiftBlock2Output right) {
        boolean sameType = StringUtils.equals((CharSequence)left.getMessageType(), (CharSequence)right.getMessageType());
        boolean sameSenderInputTime = StringUtils.equals((CharSequence)left.getSenderInputTime(), (CharSequence)right.getSenderInputTime());
        boolean sameMIRDate = StringUtils.equals((CharSequence)left.getMIRDate(), (CharSequence)right.getMIRDate());
        boolean sameMIRLogicalTerminal = this.compareLTAddress(left.getMIRLogicalTerminal(), right.getMIRLogicalTerminal());
        boolean sameMIRSessionNumber = StringUtils.equals((CharSequence)left.getMIRSessionNumber(), (CharSequence)right.getMIRSessionNumber());
        boolean sameMIRSequenceNumber = StringUtils.equals((CharSequence)left.getMIRSequenceNumber(), (CharSequence)right.getMIRSequenceNumber());
        boolean sameReceiverOutputDate = StringUtils.equals((CharSequence)left.getReceiverOutputDate(), (CharSequence)right.getReceiverOutputDate());
        boolean sameReceiverOutputTime = StringUtils.equals((CharSequence)left.getReceiverOutputTime(), (CharSequence)right.getReceiverOutputTime());
        boolean samePriority = StringUtils.equals((CharSequence)left.getMessagePriority(), (CharSequence)right.getMessagePriority());
        return sameType && sameSenderInputTime && sameMIRDate && sameMIRLogicalTerminal && sameMIRSessionNumber && sameMIRSequenceNumber && sameReceiverOutputDate && sameReceiverOutputTime && samePriority;
    }

    public boolean compareTagListBlock(SwiftTagListBlock left, SwiftTagListBlock right) {
        if (SwiftMessageComparator.isBlank(left) && SwiftMessageComparator.isBlank(right)) {
            return true;
        }
        if (SwiftMessageComparator.isBlank(left) || SwiftMessageComparator.isBlank(right)) {
            return false;
        }
        if (left.size() != right.size()) {
            return false;
        }
        int count = 0;
        for (int i = 0; i < left.size(); ++i) {
            Tag t1 = left.getTag(i);
            Tag t2 = right.getTag(i);
            if (this.tagNameIgnored(t1.getName(), t2.getName())) {
                log.finer("Tag ignored: " + t1.getName() + " - " + t2.getName());
                continue;
            }
            if (StringUtils.equals((CharSequence)t1.getName(), (CharSequence)t2.getName()) && this.valuesAreEqual(t1.getValue(), t2.getValue())) continue;
            ++count;
        }
        return count <= 0;
    }

    private boolean valuesAreEqual(String value1, String value2) {
        if (value1 == null && value2 == null) {
            return true;
        }
        if (value1 == null || value2 == null) {
            return false;
        }
        if (this.ignoreEolsInMultiline) {
            BufferedReader br1 = new BufferedReader(new StringReader(value1));
            BufferedReader br2 = new BufferedReader(new StringReader(value2));
            try {
                String l2;
                String l1;
                do {
                    if (StringUtils.equals((CharSequence)(l1 = br1.readLine()), (CharSequence)(l2 = br2.readLine()))) continue;
                    return false;
                } while (l1 != null || l2 != null);
                return true;
            }
            catch (IOException e) {
                throw new ProwideException(e);
            }
        }
        return StringUtils.equals((CharSequence)value1, (CharSequence)value2);
    }

    private boolean tagNameIgnored(String name1, String name2) {
        if (this.tagnamesToIgnore != null && !this.tagnamesToIgnore.isEmpty()) {
            for (String name : this.tagnamesToIgnore) {
                if (!StringUtils.equals((CharSequence)name, (CharSequence)name1) && !StringUtils.equals((CharSequence)name, (CharSequence)name2)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean compareB1(SwiftBlock1 left, SwiftBlock1 right) {
        if (left == null && right == null) {
            return true;
        }
        if (left == null || right == null) {
            return false;
        }
        boolean sameApplicationId = StringUtils.equals((CharSequence)left.getApplicationId(), (CharSequence)right.getApplicationId());
        boolean sameServiceId = StringUtils.equals((CharSequence)left.getServiceId(), (CharSequence)right.getServiceId());
        boolean sameSession = this.ignoreHeaderSession || StringUtils.equals((CharSequence)left.getSessionNumber(), (CharSequence)right.getSessionNumber());
        boolean sameSequence = this.ignoreHeaderSession || StringUtils.equals((CharSequence)left.getSequenceNumber(), (CharSequence)right.getSequenceNumber());
        boolean sameLTAddress = this.compareLTAddress(left.getLogicalTerminal(), right.getLogicalTerminal());
        return sameApplicationId && sameServiceId && sameSequence && sameSession & sameLTAddress;
    }

    private boolean compareLTAddress(String logicalTerminalLeft, String logicalTerminalRight) {
        LogicalTerminalAddress leftLTAddress = new LogicalTerminalAddress(logicalTerminalLeft);
        LogicalTerminalAddress rightLTAddress = new LogicalTerminalAddress(logicalTerminalRight);
        if (this.ignoreLT) {
            leftLTAddress.setLTIdentifier(Character.valueOf('A'));
            rightLTAddress.setLTIdentifier(Character.valueOf('A'));
        }
        boolean sameLTIdentifier = leftLTAddress.getLTIdentifier() == rightLTAddress.getLTIdentifier();
        boolean sameBic11 = this.compareBic(leftLTAddress, rightLTAddress);
        return sameLTIdentifier && sameBic11;
    }

    private boolean compareBic(BIC left, BIC right) {
        if (this.ignoreLocationFlag) {
            return StringUtils.equals((CharSequence)left.asTestBic().getBic11(), (CharSequence)right.asTestBic().getBic11());
        }
        return StringUtils.equals((CharSequence)left.getBic11(), (CharSequence)right.getBic11());
    }

    public boolean isIgnoreEolsInMultiline() {
        return this.ignoreEolsInMultiline;
    }

    public void setIgnoreEolsInMultiline(boolean ignoreEolsInMultiline) {
        this.ignoreEolsInMultiline = ignoreEolsInMultiline;
    }

    public List<String> getTagnamesToIgnore() {
        return this.tagnamesToIgnore;
    }

    public void setTagnamesToIgnore(List<String> tagNamesToIgnore) {
        this.tagnamesToIgnore = tagNamesToIgnore;
    }

    public boolean addTagnameToIgnore(String tagName) {
        return this.tagnamesToIgnore.add(tagName);
    }

    public boolean isIgnoreHeaderSession() {
        return this.ignoreHeaderSession;
    }

    public void setIgnoreHeaderSession(boolean ignoreHeaderSession) {
        this.ignoreHeaderSession = ignoreHeaderSession;
    }

    public boolean isIgnoreTrailer() {
        return this.ignoreTrailer;
    }

    public void setIgnoreTrailer(boolean ignoreTrailer) {
        this.ignoreTrailer = ignoreTrailer;
    }

    public boolean isIgnoreBlock2OptionalFields() {
        return this.ignoreBlock2OptionalFields;
    }

    public void setIgnoreBlock2OptionalFields(boolean ignoreBlock2OptionalFields) {
        this.ignoreBlock2OptionalFields = ignoreBlock2OptionalFields;
    }

    public boolean isIgnoreLT() {
        return this.ignoreLT;
    }

    public void setIgnoreLT(boolean ignoreLT) {
        this.ignoreLT = ignoreLT;
    }

    public boolean isIgnoreLocationFlag() {
        return this.ignoreLocationFlag;
    }

    public void setIgnoreLocationFlag(boolean ignoreLocationFlag) {
        this.ignoreLocationFlag = ignoreLocationFlag;
    }
}

