/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.DateContainer;
import com.prowidesoftware.swift.model.field.DateResolver;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.SwiftParseUtils;
import com.prowidesoftware.swift.utils.SwiftFormatUtils;
import java.io.Serializable;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class Field31F
extends Field
implements Serializable,
DateContainer {
    public static final int SRU = 2022;
    private static final long serialVersionUID = 1L;
    public static final String NAME = "31F";
    public static final String F_31F = "31F";
    @Deprecated
    public static final String PARSER_PATTERN = "<DATE2>[/<DATE2>][//S]";
    @Deprecated
    public static final String COMPONENTS_PATTERN = "EES";
    @Deprecated
    public static final String TYPES_PATTERN = "EES";
    public static final Integer DATE = 1;
    public static final Integer PERIOD_DATE = 2;
    public static final Integer PERIOD_DETAILS = 3;

    public Field31F() {
        super(3);
    }

    public Field31F(String value) {
        super(value);
    }

    public Field31F(Tag tag) {
        this();
        if (tag == null) {
            throw new IllegalArgumentException("tag cannot be null.");
        }
        if (!StringUtils.equals((CharSequence)tag.getName(), (CharSequence)"31F")) {
            throw new IllegalArgumentException("cannot create field 31F from tag " + tag.getName() + ", tagname must match the name of the field.");
        }
        this.parse(tag.getValue());
    }

    public static Field31F newInstance(Field31F source) {
        Field31F cp = new Field31F();
        cp.setComponents(new ArrayList<String>(source.getComponents()));
        return cp;
    }

    public static Tag tag(String value) {
        return new Tag("31F", value);
    }

    public static Tag emptyTag() {
        return new Tag("31F", "");
    }

    @Override
    public void parse(String value) {
        this.init(3);
        this.setComponent1(SwiftParseUtils.getTokenFirst(value, null, "/"));
        this.setComponent3(SwiftParseUtils.getTokenSecondLast(value, "//"));
        String toparse = SwiftParseUtils.getTokenFirst(value, "//");
        this.setComponent2(SwiftParseUtils.getTokenSecondLast(toparse, "/"));
    }

    @Override
    public String getValue() {
        StringBuilder result = new StringBuilder();
        this.append(result, 1);
        if (this.getComponent2() != null) {
            result.append("/").append(this.getComponent2());
        }
        if (this.getComponent3() != null) {
            result.append("//").append(this.getComponent3());
        }
        return result.toString();
    }

    @Override
    public String getValueDisplay(int component, Locale locale) {
        Calendar cal;
        DateFormat f;
        if (component < 1 || component > 3) {
            throw new IllegalArgumentException("invalid component number " + component + " for field 31F");
        }
        if (component == 1) {
            f = DateFormat.getDateInstance(2, this.notNull(locale));
            cal = this.getComponent1AsCalendar();
            if (cal != null) {
                return f.format(cal.getTime());
            }
        }
        if (component == 2) {
            f = DateFormat.getDateInstance(2, this.notNull(locale));
            cal = this.getComponent2AsCalendar();
            if (cal != null) {
                return f.format(cal.getTime());
            }
        }
        if (component == 3) {
            return this.getComponent(3);
        }
        return null;
    }

    @Override
    @Deprecated
    public String componentsPattern() {
        return "EES";
    }

    @Override
    public String typesPattern() {
        return "EES";
    }

    @Override
    public String parserPattern() {
        return PARSER_PATTERN;
    }

    @Override
    public String validatorPattern() {
        return "<DATE2>[/<DATE2>][//35x]";
    }

    @Override
    public boolean isOptional(int component) {
        if (component == 2) {
            return true;
        }
        return component == 3;
    }

    @Override
    public boolean isGeneric() {
        return false;
    }

    @Override
    public int componentsSize() {
        return 3;
    }

    @Override
    public List<String> getComponentLabels() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("Date");
        result.add("Period Date");
        result.add("Period Details");
        return result;
    }

    @Override
    protected Map<Integer, String> getComponentMap() {
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        result.put(1, "date");
        result.put(2, "periodDate");
        result.put(3, "periodDetails");
        return result;
    }

    @Override
    protected Map<String, Integer> getLabelMap() {
        if (this.labelMap != null && !this.labelMap.isEmpty()) {
            return this.labelMap;
        }
        this.labelMap = new HashMap<String, Integer>();
        this.labelMap.put("date", 1);
        this.labelMap.put("perioddate", 2);
        this.labelMap.put("perioddetails", 3);
        return this.labelMap;
    }

    public String getComponent1() {
        return this.getComponent(1);
    }

    public Calendar getComponent1AsCalendar() {
        return SwiftFormatUtils.getDate2(this.getComponent(1));
    }

    public String getDate() {
        return this.getComponent1();
    }

    public Calendar getDateAsCalendar() {
        return this.getComponent1AsCalendar();
    }

    public String getComponent2() {
        return this.getComponent(2);
    }

    public Calendar getComponent2AsCalendar() {
        return SwiftFormatUtils.getDate2(this.getComponent(2));
    }

    public String getPeriodDate() {
        return this.getComponent2();
    }

    public Calendar getPeriodDateAsCalendar() {
        return this.getComponent2AsCalendar();
    }

    public String getComponent3() {
        return this.getComponent(3);
    }

    public String getPeriodDetails() {
        return this.getComponent3();
    }

    public Field31F setComponent1(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field31F setComponent1(Calendar component1) {
        this.setComponent(1, SwiftFormatUtils.getDate2(component1));
        return this;
    }

    public Field31F setDate(String component1) {
        return this.setComponent1(component1);
    }

    public Field31F setDate(Calendar component1) {
        return this.setComponent1(component1);
    }

    public Field31F setComponent2(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field31F setComponent2(Calendar component2) {
        this.setComponent(2, SwiftFormatUtils.getDate2(component2));
        return this;
    }

    public Field31F setPeriodDate(String component2) {
        return this.setComponent2(component2);
    }

    public Field31F setPeriodDate(Calendar component2) {
        return this.setComponent2(component2);
    }

    public Field31F setComponent3(String component3) {
        this.setComponent(3, component3);
        return this;
    }

    public Field31F setPeriodDetails(String component3) {
        return this.setComponent3(component3);
    }

    @Override
    public List<Calendar> dates() {
        return DateResolver.dates(this);
    }

    public Calendar date() {
        return DateResolver.date(this);
    }

    @Override
    public String getName() {
        return "31F";
    }

    public static Field31F get(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return null;
        }
        Tag t = block.getTagByName("31F");
        if (t == null) {
            return null;
        }
        return new Field31F(t);
    }

    public static Field31F get(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return null;
        }
        return Field31F.get(msg.getBlock4());
    }

    public static List<Field31F> getAll(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return Collections.emptyList();
        }
        return Field31F.getAll(msg.getBlock4());
    }

    public static List<Field31F> getAll(SwiftTagListBlock block) {
        ArrayList<Field31F> result = new ArrayList<Field31F>();
        if (block == null || block.isEmpty()) {
            return result;
        }
        Tag[] arr = block.getTagsByName("31F");
        if (arr != null && arr.length > 0) {
            for (Tag f : arr) {
                result.add(new Field31F(f));
            }
        }
        return result;
    }

    public static Field31F fromJson(String json) {
        Field31F field = new Field31F();
        JsonObject jsonObject = JsonParser.parseString((String)json).getAsJsonObject();
        if (jsonObject.get("date") != null) {
            field.setComponent1(jsonObject.get("date").getAsString());
        }
        if (jsonObject.get("periodDate") != null) {
            field.setComponent2(jsonObject.get("periodDate").getAsString());
        }
        if (jsonObject.get("periodDetails") != null) {
            field.setComponent3(jsonObject.get("periodDetails").getAsString());
        }
        return field;
    }
}

