/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.prowidesoftware.deprecation.DeprecationUtils;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.CurrencyContainer;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.GenericField;
import com.prowidesoftware.swift.model.field.MonetaryAmountContainer;
import com.prowidesoftware.swift.model.field.MonetaryAmountResolver;
import com.prowidesoftware.swift.model.field.SwiftParseUtils;
import com.prowidesoftware.swift.utils.SwiftFormatUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Currency;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class Field92J
extends Field
implements Serializable,
MonetaryAmountContainer,
GenericField {
    public static final int SRU = 2022;
    private static final long serialVersionUID = 1L;
    public static final String NAME = "92J";
    public static final String F_92J = "92J";
    @Deprecated
    public static final String PARSER_PATTERN = ":S/[S]/S/SN[/S]";
    @Deprecated
    public static final String COMPONENTS_PATTERN = "SSSCNS";
    @Deprecated
    public static final String TYPES_PATTERN = "SSSCIS";
    public static final Integer QUALIFIER = 1;
    public static final Integer DATA_SOURCE_SCHEME = 2;
    public static final Integer RATE_TYPE_CODE = 3;
    @Deprecated
    public static final Integer CODE = 3;
    public static final Integer CURRENCY_CODE = 4;
    @Deprecated
    public static final Integer CURRENCY = 4;
    public static final Integer AMOUNT = 5;
    public static final Integer RATE_STATUS = 6;
    public static final Integer CONDITIONAL_QUALIFIER = 3;
    @Deprecated
    public static final Integer NARRATIVE = 6;

    public Field92J() {
        super(6);
    }

    public Field92J(String value) {
        super(value);
    }

    public Field92J(Tag tag) {
        this();
        if (tag == null) {
            throw new IllegalArgumentException("tag cannot be null.");
        }
        if (!StringUtils.equals((CharSequence)tag.getName(), (CharSequence)"92J")) {
            throw new IllegalArgumentException("cannot create field 92J from tag " + tag.getName() + ", tagname must match the name of the field.");
        }
        this.parse(tag.getValue());
    }

    public static Field92J newInstance(Field92J source) {
        Field92J cp = new Field92J();
        cp.setComponents(new ArrayList<String>(source.getComponents()));
        return cp;
    }

    public static Tag tag(String value) {
        return new Tag("92J", value);
    }

    public static Tag emptyTag() {
        return new Tag("92J", "");
    }

    @Override
    public void parse(String value) {
        this.init(6);
        this.setComponent1(SwiftParseUtils.getTokenFirst(value, ":", "/"));
        this.setComponent2(SwiftParseUtils.getTokenSecond(value, "/"));
        String toparse = SwiftParseUtils.getTokenThirdLast(value, "/");
        this.setComponent3(SwiftParseUtils.getTokenFirst(toparse, null, "/"));
        String toparse2 = SwiftParseUtils.getTokenSecond(toparse, "/");
        this.setComponent6(SwiftParseUtils.getTokenThirdLast(toparse, "/"));
        this.setComponent4(SwiftParseUtils.getAlphaPrefixTrimSlash(toparse2));
        this.setComponent5(SwiftParseUtils.getNumericSuffix(toparse2));
    }

    @Override
    public String getValue() {
        StringBuilder result = new StringBuilder();
        result.append(":");
        this.append(result, 1);
        result.append("/");
        this.append(result, 2);
        result.append("/");
        this.append(result, 3);
        result.append("/");
        this.append(result, 4);
        this.append(result, 5);
        if (this.getComponent6() != null) {
            result.append("/").append(this.getComponent6());
        }
        return result.toString();
    }

    @Override
    public String getValueDisplay(int component, Locale locale) {
        if (component < 1 || component > 6) {
            throw new IllegalArgumentException("invalid component number " + component + " for field 92J");
        }
        if (component == 1) {
            return this.getComponent(1);
        }
        if (component == 2) {
            return this.getComponent(2);
        }
        if (component == 3) {
            return this.getComponent(3);
        }
        if (component == 4) {
            return this.getComponent(4);
        }
        if (component == 5) {
            NumberFormat f = NumberFormat.getNumberInstance(this.notNull(locale));
            f.setMaximumFractionDigits(13);
            BigDecimal n = this.getComponent5AsBigDecimal();
            if (n != null) {
                return f.format(n);
            }
        }
        if (component == 6) {
            return this.getComponent(6);
        }
        return null;
    }

    @Override
    @Deprecated
    public String componentsPattern() {
        return COMPONENTS_PATTERN;
    }

    @Override
    public String typesPattern() {
        return TYPES_PATTERN;
    }

    @Override
    public String parserPattern() {
        return PARSER_PATTERN;
    }

    @Override
    public String validatorPattern() {
        return ":4!c/[8c]/4!c/<CUR><AMOUNT>15[/4!c]";
    }

    @Override
    public boolean isOptional(int component) {
        if (component == 2) {
            return true;
        }
        return component == 6;
    }

    @Override
    public boolean isGeneric() {
        return true;
    }

    @Override
    public int componentsSize() {
        return 6;
    }

    @Override
    public List<String> getComponentLabels() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("Qualifier");
        result.add("Data Source Scheme");
        result.add("Rate Type Code");
        result.add("Currency Code");
        result.add("Amount");
        result.add("Rate Status");
        return result;
    }

    @Override
    protected Map<Integer, String> getComponentMap() {
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        result.put(1, "qualifier");
        result.put(2, "dataSourceScheme");
        result.put(3, "rateTypeCode");
        result.put(4, "currencyCode");
        result.put(5, "amount");
        result.put(6, "rateStatus");
        return result;
    }

    @Override
    protected Map<String, Integer> getLabelMap() {
        if (this.labelMap != null && !this.labelMap.isEmpty()) {
            return this.labelMap;
        }
        this.labelMap = new HashMap<String, Integer>();
        this.labelMap.put("qualifier", 1);
        this.labelMap.put("datasourcescheme", 2);
        this.labelMap.put("ratetypecode", 3);
        this.labelMap.put("code", 3);
        this.labelMap.put("currencycode", 4);
        this.labelMap.put("currency", 4);
        this.labelMap.put("amount", 5);
        this.labelMap.put("ratestatus", 6);
        return this.labelMap;
    }

    public String getComponent1() {
        return this.getComponent(1);
    }

    public String getQualifier() {
        return this.getComponent1();
    }

    public String getComponent2() {
        return this.getComponent(2);
    }

    public String getDataSourceScheme() {
        return this.getComponent2();
    }

    public String getComponent3() {
        return this.getComponent(3);
    }

    public String getRateTypeCode() {
        return this.getComponent3();
    }

    @Deprecated
    public String getCode() {
        return this.getRateTypeCode();
    }

    public String getComponent4() {
        return this.getComponent(4);
    }

    public Currency getComponent4AsCurrency() {
        return SwiftFormatUtils.getCurrency(this.getComponent(4));
    }

    public String getCurrencyCode() {
        return this.getComponent4();
    }

    @Deprecated
    public String getCurrency() {
        return this.getCurrencyCode();
    }

    public Currency getCurrencyCodeAsCurrency() {
        return this.getComponent4AsCurrency();
    }

    @Deprecated
    public Currency getCurrencyAsCurrency() {
        return this.getCurrencyCodeAsCurrency();
    }

    public String getComponent5() {
        return this.getComponent(5);
    }

    public BigDecimal getComponent5AsBigDecimal() {
        return SwiftFormatUtils.getBigDecimal(this.getComponent(5));
    }

    @Deprecated
    public Number getComponent5AsNumber() {
        return this.getComponent5AsBigDecimal();
    }

    public String getAmount() {
        return this.getComponent5();
    }

    public BigDecimal getAmountAsBigDecimal() {
        return this.getComponent5AsBigDecimal();
    }

    @Deprecated
    public Number getAmountAsNumber() {
        return this.getComponent5AsNumber();
    }

    public String getComponent6() {
        return this.getComponent(6);
    }

    public String getRateStatus() {
        return this.getComponent6();
    }

    public Field92J setComponent1(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field92J setQualifier(String component1) {
        return this.setComponent1(component1);
    }

    public Field92J setComponent2(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field92J setDataSourceScheme(String component2) {
        return this.setComponent2(component2);
    }

    public Field92J setComponent3(String component3) {
        this.setComponent(3, component3);
        return this;
    }

    public Field92J setRateTypeCode(String component3) {
        return this.setComponent3(component3);
    }

    @Deprecated
    public Field92J setCode(String component3) {
        return this.setRateTypeCode(component3);
    }

    public Field92J setComponent4(String component4) {
        this.setComponent(4, component4);
        return this;
    }

    public Field92J setComponent4(Currency component4) {
        this.setComponent(4, SwiftFormatUtils.getCurrency(component4));
        return this;
    }

    public Field92J setCurrencyCode(String component4) {
        return this.setComponent4(component4);
    }

    public Field92J setCurrencyCode(Currency component4) {
        return this.setComponent4(component4);
    }

    @Deprecated
    public Field92J setCurrency(String component4) {
        return this.setCurrencyCode(component4);
    }

    @Deprecated
    public Field92J setCurrency(Currency component4) {
        return this.setCurrencyCode(component4);
    }

    public Field92J setComponent5(String component5) {
        this.setComponent(5, component5);
        return this;
    }

    public Field92J setComponent5(BigDecimal component5) {
        this.setComponent(5, SwiftFormatUtils.getBigDecimal(component5));
        return this;
    }

    public Field92J setComponent5(Number component5) {
        if (component5 instanceof BigDecimal) {
            this.setComponent(5, SwiftFormatUtils.getBigDecimal((BigDecimal)component5));
        } else if (component5 instanceof BigInteger) {
            this.setComponent(5, SwiftFormatUtils.getBigDecimal(new BigDecimal((BigInteger)component5)));
        } else if (component5 instanceof Long || component5 instanceof Integer) {
            this.setComponent(5, SwiftFormatUtils.getBigDecimal(BigDecimal.valueOf(component5.longValue())));
        } else if (component5 != null) {
            this.setComponent(5, SwiftFormatUtils.getBigDecimal(BigDecimal.valueOf(component5.doubleValue())));
        } else {
            this.setComponent(5, null);
        }
        return this;
    }

    public Field92J setAmount(String component5) {
        return this.setComponent5(component5);
    }

    public Field92J setAmount(BigDecimal component5) {
        return this.setComponent5(component5);
    }

    public Field92J setAmount(Number component5) {
        return this.setComponent5(component5);
    }

    public Field92J setComponent6(String component6) {
        this.setComponent(6, component6);
        return this;
    }

    public Field92J setRateStatus(String component6) {
        return this.setComponent6(component6);
    }

    @Override
    public List<String> currencyStrings() {
        return MonetaryAmountResolver.currencyStrings(this);
    }

    @Override
    public List<Currency> currencies() {
        return MonetaryAmountResolver.currencies(this);
    }

    @Override
    public Currency currency() {
        return MonetaryAmountResolver.resolveCurrency(this);
    }

    @Override
    public String currencyString() {
        return MonetaryAmountResolver.resolveCurrencyString(this);
    }

    @Override
    public void initializeCurrencies(String cur) {
        MonetaryAmountResolver.resolveSetCurrency((CurrencyContainer)this, cur);
    }

    @Override
    public void initializeCurrencies(Currency cur) {
        MonetaryAmountResolver.resolveSetCurrency((CurrencyContainer)this, cur);
    }

    public List<BigDecimal> amounts() {
        return MonetaryAmountResolver.amounts(this);
    }

    @Override
    public BigDecimal amount() {
        return MonetaryAmountResolver.amount(this);
    }

    @Override
    public String getDSS() {
        return this.getComponent2();
    }

    @Override
    public boolean isDSSPresent() {
        return this.getComponent2() != null;
    }

    @Override
    public String getConditionalQualifier() {
        return this.getComponent(CONDITIONAL_QUALIFIER);
    }

    @Override
    public String getName() {
        return "92J";
    }

    public static Field92J get(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return null;
        }
        Tag t = block.getTagByName("92J");
        if (t == null) {
            return null;
        }
        return new Field92J(t);
    }

    public static Field92J get(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return null;
        }
        return Field92J.get(msg.getBlock4());
    }

    public static List<Field92J> getAll(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return Collections.emptyList();
        }
        return Field92J.getAll(msg.getBlock4());
    }

    public static List<Field92J> getAll(SwiftTagListBlock block) {
        ArrayList<Field92J> result = new ArrayList<Field92J>();
        if (block == null || block.isEmpty()) {
            return result;
        }
        Tag[] arr = block.getTagsByName("92J");
        if (arr != null && arr.length > 0) {
            for (Tag f : arr) {
                result.add(new Field92J(f));
            }
        }
        return result;
    }

    public static Field92J fromJson(String json) {
        Field92J field = new Field92J();
        JsonObject jsonObject = JsonParser.parseString((String)json).getAsJsonObject();
        if (jsonObject.get("qualifier") != null) {
            field.setComponent1(jsonObject.get("qualifier").getAsString());
        }
        if (jsonObject.get("dataSourceScheme") != null) {
            field.setComponent2(jsonObject.get("dataSourceScheme").getAsString());
        }
        if (jsonObject.get("code") != null) {
            field.setComponent3(jsonObject.get("code").getAsString());
        }
        if (jsonObject.get("rateTypeCode") != null) {
            field.setComponent3(jsonObject.get("rateTypeCode").getAsString());
        }
        if (jsonObject.get("currency") != null) {
            field.setComponent4(jsonObject.get("currency").getAsString());
        }
        if (jsonObject.get("currencyCode") != null) {
            field.setComponent4(jsonObject.get("currencyCode").getAsString());
        }
        if (jsonObject.get("amount") != null) {
            field.setComponent5(jsonObject.get("amount").getAsString());
        }
        if (jsonObject.get("rateStatus") != null) {
            field.setComponent6(jsonObject.get("rateStatus").getAsString());
        }
        return field;
    }

    @Deprecated
    public String getNarrative() {
        DeprecationUtils.phase2(this.getClass(), "getNarrative()", "Use getRateStatus() instead");
        return this.getRateStatus();
    }

    @Deprecated
    public Field92J setNarrative(String narrative) {
        DeprecationUtils.phase2(this.getClass(), "setNarrative(String)", "Use setRateStatus(String) instead");
        return this.setRateStatus(narrative);
    }
}

