/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.CurrencyContainer;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.GenericField;
import com.prowidesoftware.swift.model.field.MonetaryAmountContainer;
import com.prowidesoftware.swift.model.field.MonetaryAmountResolver;
import com.prowidesoftware.swift.model.field.SwiftParseUtils;
import com.prowidesoftware.swift.utils.SwiftFormatUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Currency;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class Field92L
extends Field
implements Serializable,
MonetaryAmountContainer,
GenericField {
    public static final int SRU = 2022;
    private static final long serialVersionUID = 1L;
    public static final String NAME = "92L";
    public static final String F_92L = "92L";
    @Deprecated
    public static final String PARSER_PATTERN = ":S//SN/SN";
    @Deprecated
    public static final String COMPONENTS_PATTERN = "SCNCN";
    @Deprecated
    public static final String TYPES_PATTERN = "SCICI";
    public static final Integer QUALIFIER = 1;
    public static final Integer FIRST_CURRENCY_CODE = 2;
    @Deprecated
    public static final Integer CURRENCY1 = 2;
    public static final Integer AMOUNT1 = 3;
    public static final Integer SECOND_CURRENCY_CODE = 4;
    @Deprecated
    public static final Integer CURRENCY2 = 4;
    public static final Integer AMOUNT2 = 5;
    public static final Integer CONDITIONAL_QUALIFIER = 2;

    public Field92L() {
        super(5);
    }

    public Field92L(String value) {
        super(value);
    }

    public Field92L(Tag tag) {
        this();
        if (tag == null) {
            throw new IllegalArgumentException("tag cannot be null.");
        }
        if (!StringUtils.equals((CharSequence)tag.getName(), (CharSequence)"92L")) {
            throw new IllegalArgumentException("cannot create field 92L from tag " + tag.getName() + ", tagname must match the name of the field.");
        }
        this.parse(tag.getValue());
    }

    public static Field92L newInstance(Field92L source) {
        Field92L cp = new Field92L();
        cp.setComponents(new ArrayList<String>(source.getComponents()));
        return cp;
    }

    public static Tag tag(String value) {
        return new Tag("92L", value);
    }

    public static Tag emptyTag() {
        return new Tag("92L", "");
    }

    @Override
    public void parse(String value) {
        this.init(5);
        this.setComponent1(SwiftParseUtils.getTokenFirst(value, ":", "//"));
        String toparse = SwiftParseUtils.getTokenSecondLast(value, "//");
        String toparse2 = SwiftParseUtils.getTokenFirst(toparse, "/");
        this.setComponent2(SwiftParseUtils.getAlphaPrefixTrimSlash(toparse2));
        this.setComponent3(SwiftParseUtils.getNumericSuffix(toparse2));
        String toparse3 = SwiftParseUtils.getTokenSecondLast(toparse, "/");
        this.setComponent4(SwiftParseUtils.getAlphaPrefixTrimSlash(toparse3));
        this.setComponent5(SwiftParseUtils.getNumericSuffix(toparse3));
    }

    @Override
    public String getValue() {
        StringBuilder result = new StringBuilder();
        result.append(":");
        this.append(result, 1);
        result.append("//");
        this.append(result, 2);
        this.append(result, 3);
        result.append("/");
        this.append(result, 4);
        this.append(result, 5);
        return result.toString();
    }

    @Override
    public String getValueDisplay(int component, Locale locale) {
        BigDecimal n;
        NumberFormat f;
        if (component < 1 || component > 5) {
            throw new IllegalArgumentException("invalid component number " + component + " for field 92L");
        }
        if (component == 1) {
            return this.getComponent(1);
        }
        if (component == 2) {
            return this.getComponent(2);
        }
        if (component == 3) {
            f = NumberFormat.getNumberInstance(this.notNull(locale));
            f.setMaximumFractionDigits(13);
            n = this.getComponent3AsBigDecimal();
            if (n != null) {
                return f.format(n);
            }
        }
        if (component == 4) {
            return this.getComponent(4);
        }
        if (component == 5) {
            f = NumberFormat.getNumberInstance(this.notNull(locale));
            f.setMaximumFractionDigits(13);
            n = this.getComponent5AsBigDecimal();
            if (n != null) {
                return f.format(n);
            }
        }
        return null;
    }

    @Override
    @Deprecated
    public String componentsPattern() {
        return COMPONENTS_PATTERN;
    }

    @Override
    public String typesPattern() {
        return TYPES_PATTERN;
    }

    @Override
    public String parserPattern() {
        return PARSER_PATTERN;
    }

    @Override
    public String validatorPattern() {
        return ":4!c//<CUR><AMOUNT>15/<CUR><AMOUNT>15";
    }

    @Override
    public boolean isOptional(int component) {
        return false;
    }

    @Override
    public boolean isGeneric() {
        return true;
    }

    @Override
    public int componentsSize() {
        return 5;
    }

    @Override
    public List<String> getComponentLabels() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("Qualifier");
        result.add("First Currency Code");
        result.add("Amount1");
        result.add("Second Currency Code");
        result.add("Amount2");
        return result;
    }

    @Override
    protected Map<Integer, String> getComponentMap() {
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        result.put(1, "qualifier");
        result.put(2, "firstCurrencyCode");
        result.put(3, "amount1");
        result.put(4, "secondCurrencyCode");
        result.put(5, "amount2");
        return result;
    }

    @Override
    protected Map<String, Integer> getLabelMap() {
        if (this.labelMap != null && !this.labelMap.isEmpty()) {
            return this.labelMap;
        }
        this.labelMap = new HashMap<String, Integer>();
        this.labelMap.put("qualifier", 1);
        this.labelMap.put("firstcurrencycode", 2);
        this.labelMap.put("currency1", 2);
        this.labelMap.put("amount1", 3);
        this.labelMap.put("secondcurrencycode", 4);
        this.labelMap.put("currency2", 4);
        this.labelMap.put("amount2", 5);
        return this.labelMap;
    }

    public String getComponent1() {
        return this.getComponent(1);
    }

    public String getQualifier() {
        return this.getComponent1();
    }

    public String getComponent2() {
        return this.getComponent(2);
    }

    public Currency getComponent2AsCurrency() {
        return SwiftFormatUtils.getCurrency(this.getComponent(2));
    }

    public String getFirstCurrencyCode() {
        return this.getComponent2();
    }

    @Deprecated
    public String getCurrency1() {
        return this.getFirstCurrencyCode();
    }

    public Currency getFirstCurrencyCodeAsCurrency() {
        return this.getComponent2AsCurrency();
    }

    @Deprecated
    public Currency getCurrency1AsCurrency() {
        return this.getFirstCurrencyCodeAsCurrency();
    }

    public String getComponent3() {
        return this.getComponent(3);
    }

    public BigDecimal getComponent3AsBigDecimal() {
        return SwiftFormatUtils.getBigDecimal(this.getComponent(3));
    }

    @Deprecated
    public Number getComponent3AsNumber() {
        return this.getComponent3AsBigDecimal();
    }

    public String getAmount1() {
        return this.getComponent3();
    }

    public BigDecimal getAmount1AsBigDecimal() {
        return this.getComponent3AsBigDecimal();
    }

    @Deprecated
    public Number getAmount1AsNumber() {
        return this.getComponent3AsNumber();
    }

    public String getComponent4() {
        return this.getComponent(4);
    }

    public Currency getComponent4AsCurrency() {
        return SwiftFormatUtils.getCurrency(this.getComponent(4));
    }

    public String getSecondCurrencyCode() {
        return this.getComponent4();
    }

    @Deprecated
    public String getCurrency2() {
        return this.getSecondCurrencyCode();
    }

    public Currency getSecondCurrencyCodeAsCurrency() {
        return this.getComponent4AsCurrency();
    }

    @Deprecated
    public Currency getCurrency2AsCurrency() {
        return this.getSecondCurrencyCodeAsCurrency();
    }

    public String getComponent5() {
        return this.getComponent(5);
    }

    public BigDecimal getComponent5AsBigDecimal() {
        return SwiftFormatUtils.getBigDecimal(this.getComponent(5));
    }

    @Deprecated
    public Number getComponent5AsNumber() {
        return this.getComponent5AsBigDecimal();
    }

    public String getAmount2() {
        return this.getComponent5();
    }

    public BigDecimal getAmount2AsBigDecimal() {
        return this.getComponent5AsBigDecimal();
    }

    @Deprecated
    public Number getAmount2AsNumber() {
        return this.getComponent5AsNumber();
    }

    public Field92L setComponent1(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field92L setQualifier(String component1) {
        return this.setComponent1(component1);
    }

    public Field92L setComponent2(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field92L setComponent2(Currency component2) {
        this.setComponent(2, SwiftFormatUtils.getCurrency(component2));
        return this;
    }

    public Field92L setFirstCurrencyCode(String component2) {
        return this.setComponent2(component2);
    }

    public Field92L setFirstCurrencyCode(Currency component2) {
        return this.setComponent2(component2);
    }

    @Deprecated
    public Field92L setCurrency1(String component2) {
        return this.setFirstCurrencyCode(component2);
    }

    @Deprecated
    public Field92L setCurrency1(Currency component2) {
        return this.setFirstCurrencyCode(component2);
    }

    public Field92L setComponent3(String component3) {
        this.setComponent(3, component3);
        return this;
    }

    public Field92L setComponent3(BigDecimal component3) {
        this.setComponent(3, SwiftFormatUtils.getBigDecimal(component3));
        return this;
    }

    public Field92L setComponent3(Number component3) {
        if (component3 instanceof BigDecimal) {
            this.setComponent(3, SwiftFormatUtils.getBigDecimal((BigDecimal)component3));
        } else if (component3 instanceof BigInteger) {
            this.setComponent(3, SwiftFormatUtils.getBigDecimal(new BigDecimal((BigInteger)component3)));
        } else if (component3 instanceof Long || component3 instanceof Integer) {
            this.setComponent(3, SwiftFormatUtils.getBigDecimal(BigDecimal.valueOf(component3.longValue())));
        } else if (component3 != null) {
            this.setComponent(3, SwiftFormatUtils.getBigDecimal(BigDecimal.valueOf(component3.doubleValue())));
        } else {
            this.setComponent(3, null);
        }
        return this;
    }

    public Field92L setAmount1(String component3) {
        return this.setComponent3(component3);
    }

    public Field92L setAmount1(BigDecimal component3) {
        return this.setComponent3(component3);
    }

    public Field92L setAmount1(Number component3) {
        return this.setComponent3(component3);
    }

    public Field92L setComponent4(String component4) {
        this.setComponent(4, component4);
        return this;
    }

    public Field92L setComponent4(Currency component4) {
        this.setComponent(4, SwiftFormatUtils.getCurrency(component4));
        return this;
    }

    public Field92L setSecondCurrencyCode(String component4) {
        return this.setComponent4(component4);
    }

    public Field92L setSecondCurrencyCode(Currency component4) {
        return this.setComponent4(component4);
    }

    @Deprecated
    public Field92L setCurrency2(String component4) {
        return this.setSecondCurrencyCode(component4);
    }

    @Deprecated
    public Field92L setCurrency2(Currency component4) {
        return this.setSecondCurrencyCode(component4);
    }

    public Field92L setComponent5(String component5) {
        this.setComponent(5, component5);
        return this;
    }

    public Field92L setComponent5(BigDecimal component5) {
        this.setComponent(5, SwiftFormatUtils.getBigDecimal(component5));
        return this;
    }

    public Field92L setComponent5(Number component5) {
        if (component5 instanceof BigDecimal) {
            this.setComponent(5, SwiftFormatUtils.getBigDecimal((BigDecimal)component5));
        } else if (component5 instanceof BigInteger) {
            this.setComponent(5, SwiftFormatUtils.getBigDecimal(new BigDecimal((BigInteger)component5)));
        } else if (component5 instanceof Long || component5 instanceof Integer) {
            this.setComponent(5, SwiftFormatUtils.getBigDecimal(BigDecimal.valueOf(component5.longValue())));
        } else if (component5 != null) {
            this.setComponent(5, SwiftFormatUtils.getBigDecimal(BigDecimal.valueOf(component5.doubleValue())));
        } else {
            this.setComponent(5, null);
        }
        return this;
    }

    public Field92L setAmount2(String component5) {
        return this.setComponent5(component5);
    }

    public Field92L setAmount2(BigDecimal component5) {
        return this.setComponent5(component5);
    }

    public Field92L setAmount2(Number component5) {
        return this.setComponent5(component5);
    }

    @Override
    public List<String> currencyStrings() {
        return MonetaryAmountResolver.currencyStrings(this);
    }

    @Override
    public List<Currency> currencies() {
        return MonetaryAmountResolver.currencies(this);
    }

    @Override
    public Currency currency() {
        return MonetaryAmountResolver.resolveCurrency(this);
    }

    @Override
    public String currencyString() {
        return MonetaryAmountResolver.resolveCurrencyString(this);
    }

    @Override
    public void initializeCurrencies(String cur) {
        MonetaryAmountResolver.resolveSetCurrency((CurrencyContainer)this, cur);
    }

    @Override
    public void initializeCurrencies(Currency cur) {
        MonetaryAmountResolver.resolveSetCurrency((CurrencyContainer)this, cur);
    }

    public List<BigDecimal> amounts() {
        return MonetaryAmountResolver.amounts(this);
    }

    @Override
    public BigDecimal amount() {
        return MonetaryAmountResolver.amount(this);
    }

    @Override
    public String getDSS() {
        return null;
    }

    @Override
    public boolean isDSSPresent() {
        return false;
    }

    @Override
    public String getConditionalQualifier() {
        return this.getComponent(CONDITIONAL_QUALIFIER);
    }

    @Override
    public String getName() {
        return "92L";
    }

    public static Field92L get(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return null;
        }
        Tag t = block.getTagByName("92L");
        if (t == null) {
            return null;
        }
        return new Field92L(t);
    }

    public static Field92L get(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return null;
        }
        return Field92L.get(msg.getBlock4());
    }

    public static List<Field92L> getAll(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return Collections.emptyList();
        }
        return Field92L.getAll(msg.getBlock4());
    }

    public static List<Field92L> getAll(SwiftTagListBlock block) {
        ArrayList<Field92L> result = new ArrayList<Field92L>();
        if (block == null || block.isEmpty()) {
            return result;
        }
        Tag[] arr = block.getTagsByName("92L");
        if (arr != null && arr.length > 0) {
            for (Tag f : arr) {
                result.add(new Field92L(f));
            }
        }
        return result;
    }

    public static Field92L fromJson(String json) {
        Field92L field = new Field92L();
        JsonObject jsonObject = JsonParser.parseString((String)json).getAsJsonObject();
        if (jsonObject.get("qualifier") != null) {
            field.setComponent1(jsonObject.get("qualifier").getAsString());
        }
        if (jsonObject.get("currency1") != null) {
            field.setComponent2(jsonObject.get("currency1").getAsString());
        }
        if (jsonObject.get("firstCurrencyCode") != null) {
            field.setComponent2(jsonObject.get("firstCurrencyCode").getAsString());
        }
        if (jsonObject.get("amount1") != null) {
            field.setComponent3(jsonObject.get("amount1").getAsString());
        }
        if (jsonObject.get("currency2") != null) {
            field.setComponent4(jsonObject.get("currency2").getAsString());
        }
        if (jsonObject.get("secondCurrencyCode") != null) {
            field.setComponent4(jsonObject.get("secondCurrencyCode").getAsString());
        }
        if (jsonObject.get("amount2") != null) {
            field.setComponent5(jsonObject.get("amount2").getAsString());
        }
        return field;
    }
}

