/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.mt.mt9xx;

import com.prowidesoftware.swift.model.MtSwiftMessage;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.Field20;
import com.prowidesoftware.swift.model.field.Field21;
import com.prowidesoftware.swift.model.field.Field25;
import com.prowidesoftware.swift.model.field.Field25P;
import com.prowidesoftware.swift.model.field.Field28C;
import com.prowidesoftware.swift.model.field.Field60F;
import com.prowidesoftware.swift.model.field.Field60M;
import com.prowidesoftware.swift.model.field.Field61;
import com.prowidesoftware.swift.model.field.Field62F;
import com.prowidesoftware.swift.model.field.Field62M;
import com.prowidesoftware.swift.model.field.Field64;
import com.prowidesoftware.swift.model.field.Field65;
import com.prowidesoftware.swift.model.field.Field86;
import com.prowidesoftware.swift.model.mt.AbstractMT;
import com.prowidesoftware.swift.utils.Lib;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;

public class MT940
extends AbstractMT
implements Serializable {
    public static final int SRU = 2022;
    private static final long serialVersionUID = 1L;
    private static final Logger log = Logger.getLogger(MT940.class.getName());
    public static final String NAME = "940";

    public MT940(SwiftMessage m) {
        super(m);
        this.sanityCheck(m);
    }

    public MT940(MtSwiftMessage m) {
        this(m.message());
    }

    public static MT940 parse(MtSwiftMessage m) {
        if (m == null) {
            return null;
        }
        return new MT940(m);
    }

    public MT940() {
        this("TESTARZZ", "TESTARZZ");
    }

    public MT940(String sender, String receiver) {
        super(940, sender, receiver);
    }

    public MT940(String fin) {
        SwiftMessage parsed;
        if (fin != null && (parsed = MT940.read(fin)) != null) {
            this.m = parsed;
            this.sanityCheck(parsed);
        }
    }

    private void sanityCheck(SwiftMessage param) {
        if (param.isServiceMessage()) {
            log.warning("Creating an MT940 object from FIN content with a Service Message. Check if the MT940 you are intended to read is prepended with and ACK.");
        } else if (!StringUtils.equals((CharSequence)param.getType(), (CharSequence)NAME)) {
            log.warning("Creating an MT940 object from FIN content with message type " + param.getType());
        }
    }

    public static MT940 parse(String fin) {
        if (fin == null) {
            return null;
        }
        return new MT940(fin);
    }

    public MT940(InputStream stream) throws IOException {
        this(Lib.readStream(stream));
    }

    public static MT940 parse(InputStream stream) throws IOException {
        if (stream == null) {
            return null;
        }
        return new MT940(stream);
    }

    public MT940(File file) throws IOException {
        this(Lib.readFile(file));
    }

    public static MT940 parse(File file) throws IOException {
        if (file == null) {
            return null;
        }
        return new MT940(file);
    }

    @Override
    public String getMessageType() {
        return NAME;
    }

    @Override
    public MT940 append(SwiftTagListBlock block) {
        super.append(block);
        return this;
    }

    @Override
    public MT940 append(Tag ... tags) {
        super.append(tags);
        return this;
    }

    @Override
    public MT940 append(Field ... fields) {
        super.append(fields);
        return this;
    }

    public static MT940 fromJson(String json) {
        return (MT940)AbstractMT.fromJson(json);
    }

    public Field20 getField20() {
        Tag t = this.tag("20");
        if (t != null) {
            return new Field20(t.getValue());
        }
        return null;
    }

    public Field21 getField21() {
        Tag t = this.tag("21");
        if (t != null) {
            return new Field21(t.getValue());
        }
        return null;
    }

    public Field25P getField25P() {
        Tag t = this.tag("25P");
        if (t != null) {
            return new Field25P(t.getValue());
        }
        return null;
    }

    public Field25 getField25() {
        Tag t = this.tag("25");
        if (t != null) {
            return new Field25(t.getValue());
        }
        return null;
    }

    public Field28C getField28C() {
        Tag t = this.tag("28C");
        if (t != null) {
            return new Field28C(t.getValue());
        }
        return null;
    }

    public Field60F getField60F() {
        Tag t = this.tag("60F");
        if (t != null) {
            return new Field60F(t.getValue());
        }
        return null;
    }

    public Field60M getField60M() {
        Tag t = this.tag("60M");
        if (t != null) {
            return new Field60M(t.getValue());
        }
        return null;
    }

    public Field62F getField62F() {
        Tag t = this.tag("62F");
        if (t != null) {
            return new Field62F(t.getValue());
        }
        return null;
    }

    public Field62M getField62M() {
        Tag t = this.tag("62M");
        if (t != null) {
            return new Field62M(t.getValue());
        }
        return null;
    }

    public Field64 getField64() {
        Tag t = this.tag("64");
        if (t != null) {
            return new Field64(t.getValue());
        }
        return null;
    }

    public List<Field61> getField61() {
        ArrayList<Field61> result = new ArrayList<Field61>();
        Tag[] tags = this.tags("61");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field61(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field86> getField86() {
        ArrayList<Field86> result = new ArrayList<Field86>();
        Tag[] tags = this.tags("86");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field86(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field65> getField65() {
        ArrayList<Field65> result = new ArrayList<Field65>();
        Tag[] tags = this.tags("65");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field65(tag.getValue()));
            }
        }
        return result;
    }
}

