/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.Field;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class Field304
extends Field
implements Serializable {
    public static final int SRU = 2022;
    private static final long serialVersionUID = 1L;
    public static final String NAME = "304";
    public static final String F_304 = "304";
    @Deprecated
    public static final String PARSER_PATTERN = "<CC>S";
    @Deprecated
    public static final String COMPONENTS_PATTERN = "KS";
    @Deprecated
    public static final String TYPES_PATTERN = "KS";
    public static final Integer COUNTRY_CODE = 1;
    public static final Integer REGION = 2;

    public Field304() {
        super(2);
    }

    public Field304(String value) {
        super(value);
    }

    public Field304(Tag tag) {
        this();
        if (tag == null) {
            throw new IllegalArgumentException("tag cannot be null.");
        }
        if (!StringUtils.equals((CharSequence)tag.getName(), (CharSequence)"304")) {
            throw new IllegalArgumentException("cannot create field 304 from tag " + tag.getName() + ", tagname must match the name of the field.");
        }
        this.parse(tag.getValue());
    }

    public static Field304 newInstance(Field304 source) {
        Field304 cp = new Field304();
        cp.setComponents(new ArrayList<String>(source.getComponents()));
        return cp;
    }

    public static Tag tag(String value) {
        return new Tag("304", value);
    }

    public static Tag emptyTag() {
        return new Tag("304", "");
    }

    @Override
    public void parse(String value) {
        this.init(2);
        if (value != null && value.length() >= 2) {
            this.setComponent1(StringUtils.substring((String)value, (int)0, (int)2));
            if (value.length() > 2) {
                this.setComponent2(StringUtils.substring((String)value, (int)2));
            }
        }
    }

    @Override
    public String getValue() {
        StringBuilder result = new StringBuilder();
        result.append(this.joinComponents());
        return result.toString();
    }

    @Override
    public String getValueDisplay(int component, Locale locale) {
        if (component < 1 || component > 2) {
            throw new IllegalArgumentException("invalid component number " + component + " for field 304");
        }
        if (component == 1) {
            return this.getComponent(1);
        }
        if (component == 2) {
            return this.getComponent(2);
        }
        return null;
    }

    @Override
    @Deprecated
    public String componentsPattern() {
        return "KS";
    }

    @Override
    public String typesPattern() {
        return "KS";
    }

    @Override
    public String parserPattern() {
        return PARSER_PATTERN;
    }

    @Override
    public String validatorPattern() {
        return "<CC>3!c";
    }

    @Override
    public boolean isOptional(int component) {
        return false;
    }

    @Override
    public boolean isGeneric() {
        return false;
    }

    @Override
    public int componentsSize() {
        return 2;
    }

    @Override
    public List<String> getComponentLabels() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("Country Code");
        result.add("Region");
        return result;
    }

    @Override
    protected Map<Integer, String> getComponentMap() {
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        result.put(1, "countryCode");
        result.put(2, "region");
        return result;
    }

    public String getComponent1() {
        return this.getComponent(1);
    }

    public String getCountryCode() {
        return this.getComponent1();
    }

    public String getComponent2() {
        return this.getComponent(2);
    }

    public String getRegion() {
        return this.getComponent2();
    }

    public Field304 setComponent1(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field304 setCountryCode(String component1) {
        return this.setComponent1(component1);
    }

    public Field304 setComponent2(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field304 setRegion(String component2) {
        return this.setComponent2(component2);
    }

    @Override
    public String getName() {
        return "304";
    }

    public static Field304 get(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return null;
        }
        Tag t = block.getTagByName("304");
        if (t == null) {
            return null;
        }
        return new Field304(t);
    }

    public static Field304 get(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return null;
        }
        return Field304.get(msg.getBlock4());
    }

    public static List<Field304> getAll(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return Collections.emptyList();
        }
        return Field304.getAll(msg.getBlock4());
    }

    public static List<Field304> getAll(SwiftTagListBlock block) {
        ArrayList<Field304> result = new ArrayList<Field304>();
        if (block == null || block.isEmpty()) {
            return result;
        }
        Tag[] arr = block.getTagsByName("304");
        if (arr != null && arr.length > 0) {
            for (Tag f : arr) {
                result.add(new Field304(f));
            }
        }
        return result;
    }

    public static Field304 fromJson(String json) {
        Field304 field = new Field304();
        JsonObject jsonObject = JsonParser.parseString((String)json).getAsJsonObject();
        if (jsonObject.get("countryCode") != null) {
            field.setComponent1(jsonObject.get("countryCode").getAsString());
        }
        if (jsonObject.get("region") != null) {
            field.setComponent2(jsonObject.get("region").getAsString());
        }
        return field;
    }
}

