/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.GenericField;
import com.prowidesoftware.swift.model.field.SwiftParseUtils;
import com.prowidesoftware.swift.utils.SwiftFormatUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class Field36D
extends Field
implements Serializable,
GenericField {
    public static final int SRU = 2022;
    private static final long serialVersionUID = 1L;
    public static final String NAME = "36D";
    public static final String F_36D = "36D";
    @Deprecated
    public static final String PARSER_PATTERN = ":S//S/N";
    @Deprecated
    public static final String COMPONENTS_PATTERN = "SSN";
    @Deprecated
    public static final String TYPES_PATTERN = "SSN";
    public static final Integer QUALIFIER = 1;
    public static final Integer QUANTITY_TYPE_CODE = 2;
    public static final Integer QUANTITY_OF_DIGITAL_TOKENS = 3;
    public static final Integer CONDITIONAL_QUALIFIER = 2;

    public Field36D() {
        super(3);
    }

    public Field36D(String value) {
        super(value);
    }

    public Field36D(Tag tag) {
        this();
        if (tag == null) {
            throw new IllegalArgumentException("tag cannot be null.");
        }
        if (!StringUtils.equals((CharSequence)tag.getName(), (CharSequence)"36D")) {
            throw new IllegalArgumentException("cannot create field 36D from tag " + tag.getName() + ", tagname must match the name of the field.");
        }
        this.parse(tag.getValue());
    }

    public static Field36D newInstance(Field36D source) {
        Field36D cp = new Field36D();
        cp.setComponents(new ArrayList<String>(source.getComponents()));
        return cp;
    }

    public static Tag tag(String value) {
        return new Tag("36D", value);
    }

    public static Tag emptyTag() {
        return new Tag("36D", "");
    }

    @Override
    public void parse(String value) {
        this.init(3);
        this.setComponent1(SwiftParseUtils.getTokenFirst(value, ":", "//"));
        String toparse = SwiftParseUtils.getTokenSecondLast(value, "//");
        this.setComponent2(SwiftParseUtils.getTokenFirst(toparse, "/"));
        this.setComponent3(SwiftParseUtils.getTokenSecondLast(toparse, "/"));
    }

    @Override
    public String getValue() {
        StringBuilder result = new StringBuilder();
        result.append(":");
        this.append(result, 1);
        result.append("//");
        this.append(result, 2);
        result.append("/");
        this.append(result, 3);
        return result.toString();
    }

    @Override
    public String getValueDisplay(int component, Locale locale) {
        if (component < 1 || component > 3) {
            throw new IllegalArgumentException("invalid component number " + component + " for field 36D");
        }
        if (component == 1) {
            return this.getComponent(1);
        }
        if (component == 2) {
            return this.getComponent(2);
        }
        if (component == 3) {
            return this.getComponent(3);
        }
        return null;
    }

    @Override
    @Deprecated
    public String componentsPattern() {
        return "SSN";
    }

    @Override
    public String typesPattern() {
        return "SSN";
    }

    @Override
    public String parserPattern() {
        return PARSER_PATTERN;
    }

    @Override
    public String validatorPattern() {
        return ":4!c//4!c/<AMOUNT>30";
    }

    @Override
    public boolean isOptional(int component) {
        return false;
    }

    @Override
    public boolean isGeneric() {
        return true;
    }

    @Override
    public int componentsSize() {
        return 3;
    }

    @Override
    public List<String> getComponentLabels() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("Qualifier");
        result.add("Quantity Type Code");
        result.add("Quantity of Digital Tokens");
        return result;
    }

    @Override
    protected Map<Integer, String> getComponentMap() {
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        result.put(1, "qualifier");
        result.put(2, "quantityTypeCode");
        result.put(3, "quantityofDigitalTokens");
        return result;
    }

    public String getComponent1() {
        return this.getComponent(1);
    }

    public String getQualifier() {
        return this.getComponent1();
    }

    public String getComponent2() {
        return this.getComponent(2);
    }

    public String getQuantityTypeCode() {
        return this.getComponent2();
    }

    public String getComponent3() {
        return this.getComponent(3);
    }

    public Long getComponent3AsLong() {
        return SwiftFormatUtils.getLong(this.getComponent(3));
    }

    @Deprecated
    public Number getComponent3AsNumber() {
        Long l = this.getComponent3AsLong();
        return l != null ? new BigDecimal(l) : null;
    }

    public String getQuantityofDigitalTokens() {
        return this.getComponent3();
    }

    public Long getQuantityofDigitalTokensAsLong() {
        return this.getComponent3AsLong();
    }

    @Deprecated
    public Number getQuantityofDigitalTokensAsNumber() {
        return this.getComponent3AsNumber();
    }

    public Field36D setComponent1(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field36D setQualifier(String component1) {
        return this.setComponent1(component1);
    }

    public Field36D setComponent2(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field36D setQuantityTypeCode(String component2) {
        return this.setComponent2(component2);
    }

    public Field36D setComponent3(String component3) {
        this.setComponent(3, component3);
        return this;
    }

    public Field36D setComponent3(Long component3) {
        this.setComponent(3, SwiftFormatUtils.getLong(component3));
        return this;
    }

    public Field36D setComponent3(Number component3) {
        if (component3 instanceof Long) {
            this.setComponent(3, SwiftFormatUtils.getLong((Long)component3));
        } else if (component3 instanceof BigInteger || component3 instanceof Integer) {
            this.setComponent(3, SwiftFormatUtils.getLong(component3.longValue()));
        } else if (component3 != null) {
            this.setComponent(3, SwiftFormatUtils.getLong(component3.longValue()));
        } else {
            this.setComponent(3, null);
        }
        return this;
    }

    public Field36D setQuantityofDigitalTokens(String component3) {
        return this.setComponent3(component3);
    }

    public Field36D setQuantityofDigitalTokens(Long component3) {
        return this.setComponent3(component3);
    }

    public Field36D setQuantityofDigitalTokens(Number component3) {
        return this.setComponent3(component3);
    }

    @Override
    public String getDSS() {
        return null;
    }

    @Override
    public boolean isDSSPresent() {
        return false;
    }

    @Override
    public String getConditionalQualifier() {
        return this.getComponent(CONDITIONAL_QUALIFIER);
    }

    @Override
    public String getName() {
        return "36D";
    }

    public static Field36D get(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return null;
        }
        Tag t = block.getTagByName("36D");
        if (t == null) {
            return null;
        }
        return new Field36D(t);
    }

    public static Field36D get(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return null;
        }
        return Field36D.get(msg.getBlock4());
    }

    public static List<Field36D> getAll(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return Collections.emptyList();
        }
        return Field36D.getAll(msg.getBlock4());
    }

    public static List<Field36D> getAll(SwiftTagListBlock block) {
        ArrayList<Field36D> result = new ArrayList<Field36D>();
        if (block == null || block.isEmpty()) {
            return result;
        }
        Tag[] arr = block.getTagsByName("36D");
        if (arr != null && arr.length > 0) {
            for (Tag f : arr) {
                result.add(new Field36D(f));
            }
        }
        return result;
    }

    public static Field36D fromJson(String json) {
        Field36D field = new Field36D();
        JsonObject jsonObject = JsonParser.parseString((String)json).getAsJsonObject();
        if (jsonObject.get("qualifier") != null) {
            field.setComponent1(jsonObject.get("qualifier").getAsString());
        }
        if (jsonObject.get("quantityTypeCode") != null) {
            field.setComponent2(jsonObject.get("quantityTypeCode").getAsString());
        }
        if (jsonObject.get("quantityofDigitalTokens") != null) {
            field.setComponent3(jsonObject.get("quantityofDigitalTokens").getAsString());
        }
        return field;
    }
}

