/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.prowidesoftware.swift.model.BIC;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.BICContainer;
import com.prowidesoftware.swift.model.field.BICResolver;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.MultiLineField;
import com.prowidesoftware.swift.model.field.SwiftParseUtils;
import com.prowidesoftware.swift.utils.SwiftFormatUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class Field41A
extends Field
implements Serializable,
BICContainer,
MultiLineField {
    public static final int SRU = 2022;
    private static final long serialVersionUID = 1L;
    public static final String NAME = "41A";
    public static final String F_41A = "41A";
    @Deprecated
    public static final String PARSER_PATTERN = "S$S";
    @Deprecated
    public static final String COMPONENTS_PATTERN = "BS";
    @Deprecated
    public static final String TYPES_PATTERN = "BS";
    public static final Integer IDENTIFIER_CODE = 1;
    @Deprecated
    public static final Integer BIC = 1;
    public static final Integer CODE = 2;

    public Field41A() {
        super(2);
    }

    public Field41A(String value) {
        super(value);
    }

    public Field41A(Tag tag) {
        this();
        if (tag == null) {
            throw new IllegalArgumentException("tag cannot be null.");
        }
        if (!StringUtils.equals((CharSequence)tag.getName(), (CharSequence)"41A")) {
            throw new IllegalArgumentException("cannot create field 41A from tag " + tag.getName() + ", tagname must match the name of the field.");
        }
        this.parse(tag.getValue());
    }

    public static Field41A newInstance(Field41A source) {
        Field41A cp = new Field41A();
        cp.setComponents(new ArrayList<String>(source.getComponents()));
        return cp;
    }

    public static Tag tag(String value) {
        return new Tag("41A", value);
    }

    public static Tag emptyTag() {
        return new Tag("41A", "");
    }

    @Override
    public void parse(String value) {
        this.init(2);
        List<String> lines = SwiftParseUtils.getLines(value);
        if (!lines.isEmpty()) {
            this.setComponent1(lines.get(0));
            if (lines.size() > 1) {
                this.setComponent2(lines.get(1));
            }
        }
    }

    @Override
    public String getValue() {
        StringBuilder result = new StringBuilder();
        this.appendInLines(result, 1, 2);
        return result.toString();
    }

    @Override
    public String getValueDisplay(int component, Locale locale) {
        if (component < 1 || component > 2) {
            throw new IllegalArgumentException("invalid component number " + component + " for field 41A");
        }
        if (component == 1) {
            return this.getComponent(1);
        }
        if (component == 2) {
            return this.getComponent(2);
        }
        return null;
    }

    @Override
    @Deprecated
    public String componentsPattern() {
        return "BS";
    }

    @Override
    public String typesPattern() {
        return "BS";
    }

    @Override
    public String parserPattern() {
        return PARSER_PATTERN;
    }

    @Override
    public String validatorPattern() {
        return "<BIC>$14x";
    }

    @Override
    public boolean isOptional(int component) {
        return false;
    }

    @Override
    public boolean isGeneric() {
        return false;
    }

    @Override
    public int componentsSize() {
        return 2;
    }

    @Override
    public List<String> getComponentLabels() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("Identifier Code");
        result.add("Code");
        return result;
    }

    @Override
    protected Map<Integer, String> getComponentMap() {
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        result.put(1, "identifierCode");
        result.put(2, "code");
        return result;
    }

    public String getComponent1() {
        return this.getComponent(1);
    }

    public BIC getComponent1AsBIC() {
        return SwiftFormatUtils.getBIC(this.getComponent(1));
    }

    public String getIdentifierCode() {
        return this.getComponent1();
    }

    @Deprecated
    public String getBIC() {
        return this.getIdentifierCode();
    }

    public BIC getIdentifierCodeAsBIC() {
        return this.getComponent1AsBIC();
    }

    @Deprecated
    public BIC getBICAsBIC() {
        return this.getIdentifierCodeAsBIC();
    }

    public String getComponent2() {
        return this.getComponent(2);
    }

    public String getCode() {
        return this.getComponent2();
    }

    public Field41A setComponent1(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field41A setComponent1(BIC component1) {
        this.setComponent(1, SwiftFormatUtils.getBIC(component1));
        return this;
    }

    public Field41A setIdentifierCode(String component1) {
        return this.setComponent1(component1);
    }

    public Field41A setIdentifierCode(BIC component1) {
        return this.setComponent1(component1);
    }

    @Deprecated
    public Field41A setBIC(String component1) {
        return this.setIdentifierCode(component1);
    }

    @Deprecated
    public Field41A setBIC(BIC component1) {
        return this.setIdentifierCode(component1);
    }

    public Field41A setComponent2(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field41A setCode(String component2) {
        return this.setComponent2(component2);
    }

    @Override
    public List<BIC> bics() {
        return BICResolver.bics(this);
    }

    @Override
    public List<String> bicStrings() {
        return BICResolver.bicStrings(this);
    }

    @Override
    public String getName() {
        return "41A";
    }

    public static Field41A get(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return null;
        }
        Tag t = block.getTagByName("41A");
        if (t == null) {
            return null;
        }
        return new Field41A(t);
    }

    public static Field41A get(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return null;
        }
        return Field41A.get(msg.getBlock4());
    }

    public static List<Field41A> getAll(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return Collections.emptyList();
        }
        return Field41A.getAll(msg.getBlock4());
    }

    public static List<Field41A> getAll(SwiftTagListBlock block) {
        ArrayList<Field41A> result = new ArrayList<Field41A>();
        if (block == null || block.isEmpty()) {
            return result;
        }
        Tag[] arr = block.getTagsByName("41A");
        if (arr != null && arr.length > 0) {
            for (Tag f : arr) {
                result.add(new Field41A(f));
            }
        }
        return result;
    }

    @Override
    public String getLine(int line) {
        return this.getLine(line, 0);
    }

    @Override
    public String getLine(int line, int offset) {
        Field41A cp = Field41A.newInstance(this);
        return this.getLine(cp, line, null, offset);
    }

    @Override
    public List<String> getLines() {
        return SwiftParseUtils.getLines(this.getValue());
    }

    @Override
    public List<String> getLines(int offset) {
        Field41A cp = Field41A.newInstance(this);
        return SwiftParseUtils.getLines(this.getLine(cp, null, null, offset));
    }

    @Override
    public List<String> getLinesBetween(int start, int end) {
        return this.getLinesBetween(start, end, 0);
    }

    @Override
    public List<String> getLinesBetween(int start, int end, int offset) {
        Field41A cp = Field41A.newInstance(this);
        return SwiftParseUtils.getLines(this.getLine(cp, start, end, offset));
    }

    public static Field41A fromJson(String json) {
        Field41A field = new Field41A();
        JsonObject jsonObject = JsonParser.parseString((String)json).getAsJsonObject();
        if (jsonObject.get("bIC") != null) {
            field.setComponent1(jsonObject.get("bIC").getAsString());
        }
        if (jsonObject.get("identifierCode") != null) {
            field.setComponent1(jsonObject.get("identifierCode").getAsString());
        }
        if (jsonObject.get("code") != null) {
            field.setComponent2(jsonObject.get("code").getAsString());
        }
        return field;
    }
}

