/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.prowidesoftware.swift.model.BIC;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.BICContainer;
import com.prowidesoftware.swift.model.field.BICResolver;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.GenericField;
import com.prowidesoftware.swift.model.field.SwiftParseUtils;
import com.prowidesoftware.swift.utils.SwiftFormatUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class Field94H
extends Field
implements Serializable,
BICContainer,
GenericField {
    public static final int SRU = 2022;
    private static final long serialVersionUID = 1L;
    public static final String NAME = "94H";
    public static final String F_94H = "94H";
    @Deprecated
    public static final String PARSER_PATTERN = ":S//S";
    @Deprecated
    public static final String COMPONENTS_PATTERN = "SB";
    @Deprecated
    public static final String TYPES_PATTERN = "SB";
    public static final Integer QUALIFIER = 1;
    public static final Integer IDENTIFIER_CODE = 2;
    @Deprecated
    public static final Integer BIC = 2;
    public static final Integer CONDITIONAL_QUALIFIER = 2;

    public Field94H() {
        super(2);
    }

    public Field94H(String value) {
        super(value);
    }

    public Field94H(Tag tag) {
        this();
        if (tag == null) {
            throw new IllegalArgumentException("tag cannot be null.");
        }
        if (!StringUtils.equals((CharSequence)tag.getName(), (CharSequence)"94H")) {
            throw new IllegalArgumentException("cannot create field 94H from tag " + tag.getName() + ", tagname must match the name of the field.");
        }
        this.parse(tag.getValue());
    }

    public static Field94H newInstance(Field94H source) {
        Field94H cp = new Field94H();
        cp.setComponents(new ArrayList<String>(source.getComponents()));
        return cp;
    }

    public static Tag tag(String value) {
        return new Tag("94H", value);
    }

    public static Tag emptyTag() {
        return new Tag("94H", "");
    }

    @Override
    public void parse(String value) {
        this.init(2);
        this.setComponent1(SwiftParseUtils.getTokenFirst(value, ":", "//"));
        this.setComponent2(SwiftParseUtils.getTokenSecondLast(value, "//"));
    }

    @Override
    public String getValue() {
        StringBuilder result = new StringBuilder();
        result.append(":");
        this.append(result, 1);
        result.append("//");
        this.append(result, 2);
        return result.toString();
    }

    @Override
    public String getValueDisplay(int component, Locale locale) {
        if (component < 1 || component > 2) {
            throw new IllegalArgumentException("invalid component number " + component + " for field 94H");
        }
        if (component == 1) {
            return this.getComponent(1);
        }
        if (component == 2) {
            return this.getComponent(2);
        }
        return null;
    }

    @Override
    @Deprecated
    public String componentsPattern() {
        return "SB";
    }

    @Override
    public String typesPattern() {
        return "SB";
    }

    @Override
    public String parserPattern() {
        return PARSER_PATTERN;
    }

    @Override
    public String validatorPattern() {
        return ":4!c//<BIC>";
    }

    @Override
    public boolean isOptional(int component) {
        return false;
    }

    @Override
    public boolean isGeneric() {
        return true;
    }

    @Override
    public int componentsSize() {
        return 2;
    }

    @Override
    public List<String> getComponentLabels() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("Qualifier");
        result.add("Identifier Code");
        return result;
    }

    @Override
    protected Map<Integer, String> getComponentMap() {
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        result.put(1, "qualifier");
        result.put(2, "identifierCode");
        return result;
    }

    public String getComponent1() {
        return this.getComponent(1);
    }

    public String getQualifier() {
        return this.getComponent1();
    }

    public String getComponent2() {
        return this.getComponent(2);
    }

    public BIC getComponent2AsBIC() {
        return SwiftFormatUtils.getBIC(this.getComponent(2));
    }

    public String getIdentifierCode() {
        return this.getComponent2();
    }

    @Deprecated
    public String getBIC() {
        return this.getIdentifierCode();
    }

    public BIC getIdentifierCodeAsBIC() {
        return this.getComponent2AsBIC();
    }

    @Deprecated
    public BIC getBICAsBIC() {
        return this.getIdentifierCodeAsBIC();
    }

    public Field94H setComponent1(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field94H setQualifier(String component1) {
        return this.setComponent1(component1);
    }

    public Field94H setComponent2(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field94H setComponent2(BIC component2) {
        this.setComponent(2, SwiftFormatUtils.getBIC(component2));
        return this;
    }

    public Field94H setIdentifierCode(String component2) {
        return this.setComponent2(component2);
    }

    public Field94H setIdentifierCode(BIC component2) {
        return this.setComponent2(component2);
    }

    @Deprecated
    public Field94H setBIC(String component2) {
        return this.setIdentifierCode(component2);
    }

    @Deprecated
    public Field94H setBIC(BIC component2) {
        return this.setIdentifierCode(component2);
    }

    @Override
    public List<BIC> bics() {
        return BICResolver.bics(this);
    }

    @Override
    public List<String> bicStrings() {
        return BICResolver.bicStrings(this);
    }

    @Override
    public String getDSS() {
        return null;
    }

    @Override
    public boolean isDSSPresent() {
        return false;
    }

    @Override
    public String getConditionalQualifier() {
        return this.getComponent(CONDITIONAL_QUALIFIER);
    }

    @Override
    public String getName() {
        return "94H";
    }

    public static Field94H get(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return null;
        }
        Tag t = block.getTagByName("94H");
        if (t == null) {
            return null;
        }
        return new Field94H(t);
    }

    public static Field94H get(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return null;
        }
        return Field94H.get(msg.getBlock4());
    }

    public static List<Field94H> getAll(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return Collections.emptyList();
        }
        return Field94H.getAll(msg.getBlock4());
    }

    public static List<Field94H> getAll(SwiftTagListBlock block) {
        ArrayList<Field94H> result = new ArrayList<Field94H>();
        if (block == null || block.isEmpty()) {
            return result;
        }
        Tag[] arr = block.getTagsByName("94H");
        if (arr != null && arr.length > 0) {
            for (Tag f : arr) {
                result.add(new Field94H(f));
            }
        }
        return result;
    }

    public static Field94H fromJson(String json) {
        Field94H field = new Field94H();
        JsonObject jsonObject = JsonParser.parseString((String)json).getAsJsonObject();
        if (jsonObject.get("qualifier") != null) {
            field.setComponent1(jsonObject.get("qualifier").getAsString());
        }
        if (jsonObject.get("bIC") != null) {
            field.setComponent2(jsonObject.get("bIC").getAsString());
        }
        if (jsonObject.get("identifierCode") != null) {
            field.setComponent2(jsonObject.get("identifierCode").getAsString());
        }
        return field;
    }
}

