/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.prowidesoftware.swift.model.BIC;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.BICContainer;
import com.prowidesoftware.swift.model.field.BICResolver;
import com.prowidesoftware.swift.model.field.DateContainer;
import com.prowidesoftware.swift.model.field.DateResolver;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.GenericField;
import com.prowidesoftware.swift.model.field.SwiftParseUtils;
import com.prowidesoftware.swift.utils.SwiftFormatUtils;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class Field98J
extends Field
implements Serializable,
DateContainer,
BICContainer,
GenericField {
    public static final int SRU = 2022;
    private static final long serialVersionUID = 1L;
    public static final String NAME = "98J";
    public static final String F_98J = "98J";
    @Deprecated
    public static final String PARSER_PATTERN = ":S//<DATE4><TIME2>/S";
    @Deprecated
    public static final String COMPONENTS_PATTERN = "SDTB";
    @Deprecated
    public static final String TYPES_PATTERN = "SDTB";
    public static final Integer QUALIFIER = 1;
    public static final Integer DATE = 2;
    public static final Integer TIME = 3;
    public static final Integer IDENTIFIER_CODE = 4;
    @Deprecated
    public static final Integer BIC = 4;
    public static final Integer CONDITIONAL_QUALIFIER = 2;

    public Field98J() {
        super(4);
    }

    public Field98J(String value) {
        super(value);
    }

    public Field98J(Tag tag) {
        this();
        if (tag == null) {
            throw new IllegalArgumentException("tag cannot be null.");
        }
        if (!StringUtils.equals((CharSequence)tag.getName(), (CharSequence)"98J")) {
            throw new IllegalArgumentException("cannot create field 98J from tag " + tag.getName() + ", tagname must match the name of the field.");
        }
        this.parse(tag.getValue());
    }

    public static Field98J newInstance(Field98J source) {
        Field98J cp = new Field98J();
        cp.setComponents(new ArrayList<String>(source.getComponents()));
        return cp;
    }

    public static Tag tag(String value) {
        return new Tag("98J", value);
    }

    public static Tag emptyTag() {
        return new Tag("98J", "");
    }

    @Override
    public void parse(String value) {
        this.init(4);
        this.setComponent1(SwiftParseUtils.getTokenFirst(value, ":", "//"));
        String toparse = SwiftParseUtils.getTokenSecondLast(value, "//");
        String toparse2 = SwiftParseUtils.getTokenFirst(toparse, "/");
        this.setComponent4(SwiftParseUtils.getTokenSecondLast(toparse, "/"));
        if (toparse2 != null) {
            if (toparse2.length() >= 8) {
                this.setComponent2(StringUtils.substring((String)toparse2, (int)0, (int)8));
            }
            if (toparse2.length() > 8) {
                this.setComponent3(StringUtils.substring((String)toparse2, (int)8));
            }
        }
    }

    @Override
    public String getValue() {
        StringBuilder result = new StringBuilder();
        result.append(":");
        this.append(result, 1);
        result.append("//");
        this.append(result, 2);
        this.append(result, 3);
        result.append("/");
        this.append(result, 4);
        return result.toString();
    }

    @Override
    public String getValueDisplay(int component, Locale locale) {
        Calendar cal;
        DateFormat f;
        if (component < 1 || component > 4) {
            throw new IllegalArgumentException("invalid component number " + component + " for field 98J");
        }
        if (component == 1) {
            return this.getComponent(1);
        }
        if (component == 2) {
            f = DateFormat.getDateInstance(2, this.notNull(locale));
            cal = this.getComponent2AsCalendar();
            if (cal != null) {
                return f.format(cal.getTime());
            }
        }
        if (component == 3) {
            f = new SimpleDateFormat("HH:mm:ss", this.notNull(locale));
            cal = this.getComponent3AsCalendar();
            if (cal != null) {
                return f.format(cal.getTime());
            }
        }
        if (component == 4) {
            return this.getComponent(4);
        }
        return null;
    }

    @Override
    @Deprecated
    public String componentsPattern() {
        return "SDTB";
    }

    @Override
    public String typesPattern() {
        return "SDTB";
    }

    @Override
    public String parserPattern() {
        return PARSER_PATTERN;
    }

    @Override
    public String validatorPattern() {
        return ":4!c//<DATE4><TIME2>/<BIC>";
    }

    @Override
    public boolean isOptional(int component) {
        return false;
    }

    @Override
    public boolean isGeneric() {
        return true;
    }

    @Override
    public int componentsSize() {
        return 4;
    }

    @Override
    public List<String> getComponentLabels() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("Qualifier");
        result.add("Date");
        result.add("Time");
        result.add("Identifier Code");
        return result;
    }

    @Override
    protected Map<Integer, String> getComponentMap() {
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        result.put(1, "qualifier");
        result.put(2, "date");
        result.put(3, "time");
        result.put(4, "identifierCode");
        return result;
    }

    public String getComponent1() {
        return this.getComponent(1);
    }

    public String getQualifier() {
        return this.getComponent1();
    }

    public String getComponent2() {
        return this.getComponent(2);
    }

    public Calendar getComponent2AsCalendar() {
        return SwiftFormatUtils.getDate4(this.getComponent(2));
    }

    public String getDate() {
        return this.getComponent2();
    }

    public Calendar getDateAsCalendar() {
        return this.getComponent2AsCalendar();
    }

    public String getComponent3() {
        return this.getComponent(3);
    }

    public Calendar getComponent3AsCalendar() {
        return SwiftFormatUtils.getTime2(this.getComponent(3));
    }

    public String getTime() {
        return this.getComponent3();
    }

    public Calendar getTimeAsCalendar() {
        return this.getComponent3AsCalendar();
    }

    public String getComponent4() {
        return this.getComponent(4);
    }

    public BIC getComponent4AsBIC() {
        return SwiftFormatUtils.getBIC(this.getComponent(4));
    }

    public String getIdentifierCode() {
        return this.getComponent4();
    }

    @Deprecated
    public String getBIC() {
        return this.getIdentifierCode();
    }

    public BIC getIdentifierCodeAsBIC() {
        return this.getComponent4AsBIC();
    }

    @Deprecated
    public BIC getBICAsBIC() {
        return this.getIdentifierCodeAsBIC();
    }

    public Field98J setComponent1(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field98J setQualifier(String component1) {
        return this.setComponent1(component1);
    }

    public Field98J setComponent2(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field98J setComponent2(Calendar component2) {
        this.setComponent(2, SwiftFormatUtils.getDate4(component2));
        return this;
    }

    public Field98J setDate(String component2) {
        return this.setComponent2(component2);
    }

    public Field98J setDate(Calendar component2) {
        return this.setComponent2(component2);
    }

    public Field98J setComponent3(String component3) {
        this.setComponent(3, component3);
        return this;
    }

    public Field98J setComponent3(Calendar component3) {
        this.setComponent(3, SwiftFormatUtils.getTime2(component3));
        return this;
    }

    public Field98J setTime(String component3) {
        return this.setComponent3(component3);
    }

    public Field98J setTime(Calendar component3) {
        return this.setComponent3(component3);
    }

    public Field98J setComponent4(String component4) {
        this.setComponent(4, component4);
        return this;
    }

    public Field98J setComponent4(BIC component4) {
        this.setComponent(4, SwiftFormatUtils.getBIC(component4));
        return this;
    }

    public Field98J setIdentifierCode(String component4) {
        return this.setComponent4(component4);
    }

    public Field98J setIdentifierCode(BIC component4) {
        return this.setComponent4(component4);
    }

    @Deprecated
    public Field98J setBIC(String component4) {
        return this.setIdentifierCode(component4);
    }

    @Deprecated
    public Field98J setBIC(BIC component4) {
        return this.setIdentifierCode(component4);
    }

    @Override
    public List<Calendar> dates() {
        return DateResolver.dates(this);
    }

    public Calendar date() {
        return DateResolver.date(this);
    }

    @Override
    public List<BIC> bics() {
        return BICResolver.bics(this);
    }

    @Override
    public List<String> bicStrings() {
        return BICResolver.bicStrings(this);
    }

    @Override
    public String getDSS() {
        return null;
    }

    @Override
    public boolean isDSSPresent() {
        return false;
    }

    @Override
    public String getConditionalQualifier() {
        return this.getComponent(CONDITIONAL_QUALIFIER);
    }

    @Override
    public String getName() {
        return "98J";
    }

    public static Field98J get(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return null;
        }
        Tag t = block.getTagByName("98J");
        if (t == null) {
            return null;
        }
        return new Field98J(t);
    }

    public static Field98J get(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return null;
        }
        return Field98J.get(msg.getBlock4());
    }

    public static List<Field98J> getAll(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return Collections.emptyList();
        }
        return Field98J.getAll(msg.getBlock4());
    }

    public static List<Field98J> getAll(SwiftTagListBlock block) {
        ArrayList<Field98J> result = new ArrayList<Field98J>();
        if (block == null || block.isEmpty()) {
            return result;
        }
        Tag[] arr = block.getTagsByName("98J");
        if (arr != null && arr.length > 0) {
            for (Tag f : arr) {
                result.add(new Field98J(f));
            }
        }
        return result;
    }

    public static Field98J fromJson(String json) {
        Field98J field = new Field98J();
        JsonObject jsonObject = JsonParser.parseString((String)json).getAsJsonObject();
        if (jsonObject.get("qualifier") != null) {
            field.setComponent1(jsonObject.get("qualifier").getAsString());
        }
        if (jsonObject.get("date") != null) {
            field.setComponent2(jsonObject.get("date").getAsString());
        }
        if (jsonObject.get("time") != null) {
            field.setComponent3(jsonObject.get("time").getAsString());
        }
        if (jsonObject.get("bIC") != null) {
            field.setComponent4(jsonObject.get("bIC").getAsString());
        }
        if (jsonObject.get("identifierCode") != null) {
            field.setComponent4(jsonObject.get("identifierCode").getAsString());
        }
        return field;
    }
}

