/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.GenericField;
import com.prowidesoftware.swift.model.field.SwiftParseUtils;
import com.prowidesoftware.swift.utils.SwiftFormatUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class Field99C
extends Field
implements Serializable,
GenericField {
    public static final int SRU = 2023;
    private static final long serialVersionUID = 1L;
    public static final String NAME = "99C";
    public static final String F_99C = "99C";
    @Deprecated
    public static final String PARSER_PATTERN = ":S//S";
    @Deprecated
    public static final String COMPONENTS_PATTERN = "SN";
    @Deprecated
    public static final String TYPES_PATTERN = "SN";
    public static final Integer QUALIFIER = 1;
    public static final Integer NUMBER = 2;
    public static final Integer CONDITIONAL_QUALIFIER = 2;

    public Field99C() {
        super(2);
    }

    public Field99C(String value) {
        super(value);
    }

    public Field99C(Tag tag) {
        this();
        if (tag == null) {
            throw new IllegalArgumentException("tag cannot be null.");
        }
        if (!StringUtils.equals((CharSequence)tag.getName(), (CharSequence)"99C")) {
            throw new IllegalArgumentException("cannot create field 99C from tag " + tag.getName() + ", tagname must match the name of the field.");
        }
        this.parse(tag.getValue());
    }

    public static Field99C newInstance(Field99C source) {
        Field99C cp = new Field99C();
        cp.setComponents(new ArrayList<String>(source.getComponents()));
        return cp;
    }

    public static Tag tag(String value) {
        return new Tag("99C", value);
    }

    public static Tag emptyTag() {
        return new Tag("99C", "");
    }

    @Override
    public void parse(String value) {
        this.init(2);
        this.setComponent1(SwiftParseUtils.getTokenFirst(value, ":", "//"));
        this.setComponent2(SwiftParseUtils.getTokenSecondLast(value, "//"));
    }

    @Override
    public String getValue() {
        StringBuilder result = new StringBuilder();
        result.append(":");
        this.append(result, 1);
        result.append("//");
        this.append(result, 2);
        return result.toString();
    }

    @Override
    public String getValueDisplay(int component, Locale locale) {
        if (component < 1 || component > 2) {
            throw new IllegalArgumentException("invalid component number " + component + " for field 99C");
        }
        if (component == 1) {
            return this.getComponent(1);
        }
        if (component == 2) {
            return this.getComponent(2);
        }
        return null;
    }

    @Override
    @Deprecated
    public String componentsPattern() {
        return "SN";
    }

    @Override
    public String typesPattern() {
        return "SN";
    }

    @Override
    public String parserPattern() {
        return PARSER_PATTERN;
    }

    @Override
    public String validatorPattern() {
        return ":4!c//6!n";
    }

    @Override
    public boolean isOptional(int component) {
        return false;
    }

    @Override
    public boolean isGeneric() {
        return true;
    }

    @Override
    public int componentsSize() {
        return 2;
    }

    @Override
    public List<String> getComponentLabels() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("Qualifier");
        result.add("Number");
        return result;
    }

    @Override
    protected Map<Integer, String> getComponentMap() {
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        result.put(1, "qualifier");
        result.put(2, "number");
        return result;
    }

    @Override
    protected Map<String, Integer> getLabelMap() {
        if (this.labelMap != null && !this.labelMap.isEmpty()) {
            return this.labelMap;
        }
        this.labelMap = new HashMap<String, Integer>();
        this.labelMap.put("qualifier", 1);
        this.labelMap.put("number", 2);
        return this.labelMap;
    }

    public String getComponent1() {
        return this.getComponent(1);
    }

    public String getQualifier() {
        return this.getComponent1();
    }

    public String getComponent2() {
        return this.getComponent(2);
    }

    public Long getComponent2AsLong() {
        return SwiftFormatUtils.getLong(this.getComponent(2));
    }

    @Deprecated
    public Number getComponent2AsNumber() {
        Long l = this.getComponent2AsLong();
        return l != null ? new BigDecimal(l) : null;
    }

    public String getNumber() {
        return this.getComponent2();
    }

    public Long getNumberAsLong() {
        return this.getComponent2AsLong();
    }

    @Deprecated
    public Number getNumberAsNumber() {
        return this.getComponent2AsNumber();
    }

    public Field99C setComponent1(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field99C setQualifier(String component1) {
        return this.setComponent1(component1);
    }

    public Field99C setComponent2(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field99C setComponent2(Long component2) {
        this.setComponent(2, SwiftFormatUtils.getLong(component2));
        return this;
    }

    public Field99C setComponent2(Number component2) {
        if (component2 instanceof Long) {
            this.setComponent(2, SwiftFormatUtils.getLong((Long)component2));
        } else if (component2 instanceof BigInteger || component2 instanceof Integer) {
            this.setComponent(2, SwiftFormatUtils.getLong(component2.longValue()));
        } else if (component2 != null) {
            this.setComponent(2, SwiftFormatUtils.getLong(component2.longValue()));
        } else {
            this.setComponent(2, null);
        }
        return this;
    }

    public Field99C setNumber(String component2) {
        return this.setComponent2(component2);
    }

    public Field99C setNumber(Long component2) {
        return this.setComponent2(component2);
    }

    public Field99C setNumber(Number component2) {
        return this.setComponent2(component2);
    }

    @Override
    public String getDSS() {
        return null;
    }

    @Override
    public boolean isDSSPresent() {
        return false;
    }

    @Override
    public String getConditionalQualifier() {
        return this.getComponent(CONDITIONAL_QUALIFIER);
    }

    @Override
    public String getName() {
        return "99C";
    }

    public static Field99C get(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return null;
        }
        Tag t = block.getTagByName("99C");
        if (t == null) {
            return null;
        }
        return new Field99C(t);
    }

    public static Field99C get(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return null;
        }
        return Field99C.get(msg.getBlock4());
    }

    public static List<Field99C> getAll(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return Collections.emptyList();
        }
        return Field99C.getAll(msg.getBlock4());
    }

    public static List<Field99C> getAll(SwiftTagListBlock block) {
        ArrayList<Field99C> result = new ArrayList<Field99C>();
        if (block == null || block.isEmpty()) {
            return result;
        }
        Tag[] arr = block.getTagsByName("99C");
        if (arr != null && arr.length > 0) {
            for (Tag f : arr) {
                result.add(new Field99C(f));
            }
        }
        return result;
    }

    public static Field99C fromJson(String json) {
        Field99C field = new Field99C();
        JsonObject jsonObject = JsonParser.parseString((String)json).getAsJsonObject();
        if (jsonObject.get("qualifier") != null) {
            field.setComponent1(jsonObject.get("qualifier").getAsString());
        }
        if (jsonObject.get("number") != null) {
            field.setComponent2(jsonObject.get("number").getAsString());
        }
        return field;
    }
}

