/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.prowidesoftware.deprecation.DeprecationUtils;
import com.prowidesoftware.swift.model.BIC;
import com.prowidesoftware.swift.model.field.BICContainer;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.PartyIdentifier;
import com.prowidesoftware.swift.model.field.PartyIdentifierUtils;
import com.prowidesoftware.swift.model.field.SwiftParseUtils;
import com.prowidesoftware.swift.utils.SwiftFormatUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public abstract class OptionAPartyField
extends Field
implements BICContainer,
PartyIdentifier {
    public static final String PARSER_PATTERN = "[[/c][/S]$]S";
    @Deprecated
    public static final String COMPONENTS_PATTERN = "SSB";
    public static final String TYPES_PATTERN = "SSB";
    public static final Integer DC_MARK = 1;
    public static final Integer ACCOUNT = 2;
    public static final Integer IDENTIFIER_CODE = 3;
    @Deprecated
    public static final Integer BIC = 3;

    public OptionAPartyField() {
        super(3);
    }

    public OptionAPartyField(String value) {
        super(value);
    }

    @Override
    public void parse(String value) {
        this.init(3);
        List<String> lines = SwiftParseUtils.getLines(value);
        if (lines.isEmpty()) {
            return;
        }
        if (lines.get(0).startsWith("/")) {
            String party = lines.get(0);
            if (StringUtils.startsWith((CharSequence)party, (CharSequence)"/C/") || StringUtils.startsWith((CharSequence)party, (CharSequence)"/D/")) {
                this.setComponent(1, String.valueOf(party.charAt(1)));
                this.setComponent(2, StringUtils.substring((String)party, (int)3));
            } else {
                this.setComponent(2, StringUtils.substring((String)party, (int)1));
            }
            if (lines.size() > 1) {
                this.setComponent(3, lines.get(1));
            }
        } else {
            this.setComponent(3, lines.get(0));
        }
    }

    @Override
    public String getValueDisplay(int component, Locale locale) {
        if (component < 1 || component > 3) {
            throw new IllegalArgumentException("invalid component number " + component + " for field " + this.getName());
        }
        return this.getComponent(component);
    }

    @Override
    public String getValue() {
        StringBuilder result = new StringBuilder();
        if (this.getComponent1() != null) {
            result.append("/").append(this.getComponent1());
        }
        if (this.getComponent2() != null) {
            result.append("/").append(this.getComponent2());
        }
        if (this.getComponent3() != null) {
            if (result.length() > 0) {
                result.append("\r\n");
            }
            result.append(this.getComponent3());
        }
        return result.toString();
    }

    @Override
    public abstract String getName();

    @Override
    @Deprecated
    public final String componentsPattern() {
        DeprecationUtils.phase3(this.getClass(), "componentsPattern()", "Use typesPattern() instead.");
        return this.typesPattern();
    }

    @Override
    public final String typesPattern() {
        return "SSB";
    }

    @Override
    public final String parserPattern() {
        return PARSER_PATTERN;
    }

    @Override
    public abstract String validatorPattern();

    @Override
    public boolean isOptional(int component) {
        if (component == 1) {
            return true;
        }
        return component == 2;
    }

    @Override
    public boolean isGeneric() {
        return false;
    }

    @Override
    public int componentsSize() {
        return 3;
    }

    @Override
    public List<String> getComponentLabels() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("D/C Mark");
        result.add("Account");
        result.add("Identifier Code");
        return result;
    }

    @Override
    protected Map<Integer, String> getComponentMap() {
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        result.put(1, "dCMark");
        result.put(2, "account");
        result.put(3, "identifierCode");
        return result;
    }

    @Override
    protected Map<String, Integer> getLabelMap() {
        if (this.labelMap != null && !this.labelMap.isEmpty()) {
            return this.labelMap;
        }
        this.labelMap = new HashMap<String, Integer>();
        this.labelMap.put("dcmark", 1);
        this.labelMap.put("account", 2);
        this.labelMap.put("identifiercode", 3);
        return this.labelMap;
    }

    public String getComponent1() {
        return this.getComponent(1);
    }

    public String getDCMark() {
        return this.getComponent(1);
    }

    public String getComponent2() {
        return this.getComponent(2);
    }

    public String getAccount() {
        String c = this.getComponent(2);
        if (c != null) {
            for (int i = 0; i < c.length(); ++i) {
                if (c.charAt(i) == '/') continue;
                return c.substring(i);
            }
            return "";
        }
        return null;
    }

    public String getComponent3() {
        return this.getComponent(3);
    }

    public BIC getComponent3AsBIC() {
        return SwiftFormatUtils.getBIC(this.getComponent(3));
    }

    public String getIdentifierCode() {
        return this.getComponent3();
    }

    public BIC getIdentifierCodeAsBIC() {
        return this.getComponent3AsBIC();
    }

    @Deprecated
    public String getBIC() {
        DeprecationUtils.phase3(this.getClass(), "getBIC()", "Use getIdentifierCode() instead.");
        return this.getIdentifierCode();
    }

    @Deprecated
    public BIC getBICAsBIC() {
        DeprecationUtils.phase3(this.getClass(), "getBICAsBIC()", "Use getIdentifierCodeAsBIC() instead.");
        return this.getIdentifierCodeAsBIC();
    }

    @Override
    public List<BIC> bics() {
        ArrayList<BIC> result = new ArrayList<BIC>();
        result.add(SwiftFormatUtils.getBIC(this.getComponent(3)));
        return result;
    }

    @Override
    public String getPartyIdentifier() {
        return PartyIdentifierUtils.getPartyIdentifier(this, 1, 2);
    }

    @Override
    public OptionAPartyField setPartyIdentifier(String partyIdentifier) {
        return (OptionAPartyField)PartyIdentifierUtils.setPartyIdentifier(this, 1, 2, partyIdentifier);
    }

    @Override
    public List<String> bicStrings() {
        ArrayList<String> result = new ArrayList<String>();
        result.add(this.getComponent(3));
        return result;
    }
}

