/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.CurrencyContainer;
import com.prowidesoftware.swift.model.field.CurrencyResolver;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.SwiftParseUtils;
import com.prowidesoftware.swift.utils.SwiftFormatUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Currency;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class Field23
extends Field
implements Serializable,
CurrencyContainer {
    public static final int SRU = 2024;
    private static final long serialVersionUID = 1L;
    public static final String NAME = "23";
    public static final String F_23 = "23";
    public static final Integer CODE_1 = 1;
    public static final Integer BUY_SELL_INDICATOR = 1;
    public static final Integer CODE_2 = 2;
    public static final Integer CALL_PUT_INDICATOR = 2;
    public static final Integer CODE_3 = 3;
    public static final Integer STYLE_INDICATOR = 3;
    public static final Integer CURRENCY = 4;
    public static final Integer MANUAL_AUTOMATIC_INDICATOR = 4;

    public Field23() {
        super(4);
    }

    public Field23(String value) {
        super(value);
    }

    public Field23(Tag tag) {
        this();
        if (tag == null) {
            throw new IllegalArgumentException("tag cannot be null.");
        }
        if (!StringUtils.equals((CharSequence)tag.getName(), (CharSequence)"23")) {
            throw new IllegalArgumentException("cannot create field 23 from tag " + tag.getName() + ", tagname must match the name of the field.");
        }
        this.parse(tag.getValue());
    }

    public static Field23 newInstance(Field23 source) {
        Field23 cp = new Field23();
        cp.setComponents(new ArrayList<String>(source.getComponents()));
        return cp;
    }

    public static Tag tag(String value) {
        return new Tag("23", value);
    }

    public static Tag emptyTag() {
        return new Tag("23", "");
    }

    @Override
    public void parse(String value) {
        this.init(4);
        this.setComponent1(SwiftParseUtils.getTokenFirst(value, null, "/"));
        String toparse = SwiftParseUtils.getTokenSecondLast(value, "/");
        if (StringUtils.isNotBlank((CharSequence)toparse)) {
            this.setComponent2(SwiftParseUtils.getTokenFirst(toparse, null, "/"));
            String toparse2 = SwiftParseUtils.getTokenSecondLast(toparse, "/");
            if (StringUtils.isNotBlank((CharSequence)toparse2)) {
                this.setComponent3(SwiftParseUtils.getTokenFirst(toparse2, null, "/"));
                this.setComponent4(SwiftParseUtils.getTokenSecondLast(toparse2, "/"));
            }
        }
    }

    @Override
    public String getValue() {
        StringBuilder result = new StringBuilder();
        this.append(result, 1);
        if (this.getComponent2() != null || this.getComponent3() != null || this.getComponent4() != null) {
            result.append("/");
            if (this.getComponent2() != null) {
                result.append(this.getComponent2());
            }
            result.append("/");
            if (this.getComponent3() != null) {
                result.append(this.getComponent3());
            }
            if (this.getComponent4() != null) {
                result.append("/").append(this.getComponent4());
            }
        }
        return result.toString();
    }

    @Override
    public String getValueDisplay(int component, Locale locale) {
        if (component < 1 || component > 4) {
            throw new IllegalArgumentException("invalid component number " + component + " for field 23");
        }
        if (component == 1) {
            return this.getComponent(1);
        }
        if (component == 2) {
            return this.getComponent(2);
        }
        if (component == 3) {
            return this.getComponent(3);
        }
        if (component == 4) {
            return this.getComponent(4);
        }
        return null;
    }

    @Override
    public String typesPattern() {
        return "SSSC";
    }

    @Override
    public String parserPattern() {
        return "S[/S/S[/S]]";
    }

    @Override
    public String validatorPattern() {
        return "CUSTOM";
    }

    @Override
    public boolean isOptional(int component) {
        if (component == 2) {
            return true;
        }
        if (component == 3) {
            return true;
        }
        return component == 4;
    }

    @Override
    public boolean isGeneric() {
        return false;
    }

    @Override
    public int componentsSize() {
        return 4;
    }

    @Override
    public List<String> getComponentLabels() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("Code 1");
        result.add("Code 2");
        result.add("Code 3");
        result.add("Currency");
        return result;
    }

    @Override
    protected Map<Integer, String> getComponentMap() {
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        result.put(1, "code1");
        result.put(2, "code2");
        result.put(3, "code3");
        result.put(4, "currency");
        return result;
    }

    @Override
    protected Map<String, Integer> getLabelMap() {
        if (this.labelMap != null && !this.labelMap.isEmpty()) {
            return this.labelMap;
        }
        this.labelMap = new HashMap<String, Integer>();
        this.labelMap.put("code1", 1);
        this.labelMap.put("buysellindicator", 1);
        this.labelMap.put("code2", 2);
        this.labelMap.put("callputindicator", 2);
        this.labelMap.put("code3", 3);
        this.labelMap.put("styleindicator", 3);
        this.labelMap.put("currency", 4);
        this.labelMap.put("manualautomaticindicator", 4);
        return this.labelMap;
    }

    public String getComponent1() {
        return this.getComponent(1);
    }

    public String getCode1() {
        return this.getComponent1();
    }

    public String getBuySellIndicator() {
        return this.getCode1();
    }

    public String getComponent2() {
        return this.getComponent(2);
    }

    public String getCode2() {
        return this.getComponent2();
    }

    public String getCallPutIndicator() {
        return this.getCode2();
    }

    public String getComponent3() {
        return this.getComponent(3);
    }

    public String getCode3() {
        return this.getComponent3();
    }

    public String getStyleIndicator() {
        return this.getCode3();
    }

    public String getComponent4() {
        return this.getComponent(4);
    }

    public Currency getComponent4AsCurrency() {
        return SwiftFormatUtils.getCurrency(this.getComponent(4));
    }

    public String getCurrency() {
        return this.getComponent4();
    }

    public String getManualAutomaticIndicator() {
        return this.getCurrency();
    }

    public Currency getCurrencyAsCurrency() {
        return this.getComponent4AsCurrency();
    }

    public Currency getManualAutomaticIndicatorAsCurrency() {
        return this.getCurrencyAsCurrency();
    }

    public Field23 setComponent1(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field23 setCode1(String component1) {
        return this.setComponent1(component1);
    }

    public Field23 setBuySellIndicator(String component1) {
        return this.setCode1(component1);
    }

    public Field23 setComponent2(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field23 setCode2(String component2) {
        return this.setComponent2(component2);
    }

    public Field23 setCallPutIndicator(String component2) {
        return this.setCode2(component2);
    }

    public Field23 setComponent3(String component3) {
        this.setComponent(3, component3);
        return this;
    }

    public Field23 setCode3(String component3) {
        return this.setComponent3(component3);
    }

    public Field23 setStyleIndicator(String component3) {
        return this.setCode3(component3);
    }

    public Field23 setComponent4(String component4) {
        this.setComponent(4, component4);
        return this;
    }

    public Field23 setComponent4(Currency component4) {
        this.setComponent(4, SwiftFormatUtils.getCurrency(component4));
        return this;
    }

    public Field23 setCurrency(String component4) {
        return this.setComponent4(component4);
    }

    public Field23 setCurrency(Currency component4) {
        return this.setComponent4(component4);
    }

    public Field23 setManualAutomaticIndicator(String component4) {
        return this.setCurrency(component4);
    }

    public Field23 setManualAutomaticIndicator(Currency component4) {
        return this.setCurrency(component4);
    }

    @Override
    public List<String> currencyStrings() {
        return CurrencyResolver.currencyStrings(this);
    }

    @Override
    public List<Currency> currencies() {
        return CurrencyResolver.currencies(this);
    }

    @Override
    public Currency currency() {
        return CurrencyResolver.resolveCurrency(this);
    }

    @Override
    public String currencyString() {
        return CurrencyResolver.resolveCurrencyString(this);
    }

    @Override
    public void initializeCurrencies(String cur) {
        CurrencyResolver.resolveSetCurrency((CurrencyContainer)this, cur);
    }

    @Override
    public void initializeCurrencies(Currency cur) {
        CurrencyResolver.resolveSetCurrency((CurrencyContainer)this, cur);
    }

    @Override
    public String getName() {
        return "23";
    }

    public static Field23 get(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return null;
        }
        Tag t = block.getTagByName("23");
        if (t == null) {
            return null;
        }
        return new Field23(t);
    }

    public static Field23 get(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return null;
        }
        return Field23.get(msg.getBlock4());
    }

    public static List<Field23> getAll(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return Collections.emptyList();
        }
        return Field23.getAll(msg.getBlock4());
    }

    public static List<Field23> getAll(SwiftTagListBlock block) {
        ArrayList<Field23> result = new ArrayList<Field23>();
        if (block == null || block.isEmpty()) {
            return result;
        }
        Tag[] arr = block.getTagsByName("23");
        if (arr != null && arr.length > 0) {
            for (Tag f : arr) {
                result.add(new Field23(f));
            }
        }
        return result;
    }

    public static Field23 fromJson(String json) {
        Field23 field = new Field23();
        JsonObject jsonObject = JsonParser.parseString((String)json).getAsJsonObject();
        if (jsonObject.get("buySellIndicator") != null) {
            field.setComponent1(jsonObject.get("buySellIndicator").getAsString());
        }
        if (jsonObject.get("code1") != null) {
            field.setComponent1(jsonObject.get("code1").getAsString());
        }
        if (jsonObject.get("callPutIndicator") != null) {
            field.setComponent2(jsonObject.get("callPutIndicator").getAsString());
        }
        if (jsonObject.get("code2") != null) {
            field.setComponent2(jsonObject.get("code2").getAsString());
        }
        if (jsonObject.get("styleIndicator") != null) {
            field.setComponent3(jsonObject.get("styleIndicator").getAsString());
        }
        if (jsonObject.get("code3") != null) {
            field.setComponent3(jsonObject.get("code3").getAsString());
        }
        if (jsonObject.get("manualAutomaticIndicator") != null) {
            field.setComponent4(jsonObject.get("manualAutomaticIndicator").getAsString());
        }
        if (jsonObject.get("currency") != null) {
            field.setComponent4(jsonObject.get("currency").getAsString());
        }
        return field;
    }
}

