/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.Field;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class Field26H
extends Field
implements Serializable {
    public static final int SRU = 2024;
    private static final long serialVersionUID = 1L;
    public static final String NAME = "26H";
    public static final String F_26H = "26H";
    public static final Integer COUNTERPARTY_REFERENCE = 1;
    public static final Integer COLLATERAL_TYPE = 1;

    public Field26H() {
        super(1);
    }

    public Field26H(String value) {
        super(value);
    }

    public Field26H(Tag tag) {
        this();
        if (tag == null) {
            throw new IllegalArgumentException("tag cannot be null.");
        }
        if (!StringUtils.equals((CharSequence)tag.getName(), (CharSequence)"26H")) {
            throw new IllegalArgumentException("cannot create field 26H from tag " + tag.getName() + ", tagname must match the name of the field.");
        }
        this.parse(tag.getValue());
    }

    public static Field26H newInstance(Field26H source) {
        Field26H cp = new Field26H();
        cp.setComponents(new ArrayList<String>(source.getComponents()));
        return cp;
    }

    public static Tag tag(String value) {
        return new Tag("26H", value);
    }

    public static Tag emptyTag() {
        return new Tag("26H", "");
    }

    @Override
    public void parse(String value) {
        this.init(1);
        this.setComponent1(value);
    }

    @Override
    public String getValue() {
        StringBuilder result = new StringBuilder();
        this.append(result, 1);
        return result.toString();
    }

    @Override
    public String getValueDisplay(int component, Locale locale) {
        if (component < 1 || component > 1) {
            throw new IllegalArgumentException("invalid component number " + component + " for field 26H");
        }
        if (component == 1) {
            return this.getComponent(1);
        }
        return null;
    }

    @Override
    public String typesPattern() {
        return "S";
    }

    @Override
    public String parserPattern() {
        return "S";
    }

    @Override
    public String validatorPattern() {
        return "16x";
    }

    @Override
    public boolean isOptional(int component) {
        return false;
    }

    @Override
    public boolean isGeneric() {
        return false;
    }

    @Override
    public int componentsSize() {
        return 1;
    }

    @Override
    public List<String> getComponentLabels() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("Counterparty Reference");
        return result;
    }

    @Override
    protected Map<Integer, String> getComponentMap() {
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        result.put(1, "counterpartyReference");
        return result;
    }

    @Override
    protected Map<String, Integer> getLabelMap() {
        if (this.labelMap != null && !this.labelMap.isEmpty()) {
            return this.labelMap;
        }
        this.labelMap = new HashMap<String, Integer>();
        this.labelMap.put("counterpartyreference", 1);
        this.labelMap.put("collateraltype", 1);
        this.labelMap.put("reference", 1);
        return this.labelMap;
    }

    public String getComponent1() {
        return this.getComponent(1);
    }

    public String getCounterpartyReference() {
        return this.getComponent1();
    }

    public String getCollateralType() {
        return this.getCounterpartyReference();
    }

    public Field26H setComponent1(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field26H setCounterpartyReference(String component1) {
        return this.setComponent1(component1);
    }

    public Field26H setCollateralType(String component1) {
        return this.setCounterpartyReference(component1);
    }

    @Override
    public String getName() {
        return "26H";
    }

    public static Field26H get(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return null;
        }
        Tag t = block.getTagByName("26H");
        if (t == null) {
            return null;
        }
        return new Field26H(t);
    }

    public static Field26H get(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return null;
        }
        return Field26H.get(msg.getBlock4());
    }

    public static List<Field26H> getAll(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return Collections.emptyList();
        }
        return Field26H.getAll(msg.getBlock4());
    }

    public static List<Field26H> getAll(SwiftTagListBlock block) {
        ArrayList<Field26H> result = new ArrayList<Field26H>();
        if (block == null || block.isEmpty()) {
            return result;
        }
        Tag[] arr = block.getTagsByName("26H");
        if (arr != null && arr.length > 0) {
            for (Tag f : arr) {
                result.add(new Field26H(f));
            }
        }
        return result;
    }

    public static Field26H fromJson(String json) {
        Field26H field = new Field26H();
        JsonObject jsonObject = JsonParser.parseString((String)json).getAsJsonObject();
        if (jsonObject.get("collateralType") != null) {
            field.setComponent1(jsonObject.get("collateralType").getAsString());
        }
        if (jsonObject.get("reference") != null) {
            field.setComponent1(jsonObject.get("reference").getAsString());
        }
        if (jsonObject.get("counterpartyReference") != null) {
            field.setComponent1(jsonObject.get("counterpartyReference").getAsString());
        }
        return field;
    }
}

