/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.utils.SwiftFormatUtils;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class Field330
extends Field
implements Serializable {
    public static final int SRU = 2024;
    private static final long serialVersionUID = 1L;
    public static final String NAME = "330";
    public static final String F_330 = "330";
    public static final Integer SESSION_NUMBER = 1;
    public static final Integer ISN = 2;
    public static final Integer ISN_NAK = 3;
    public static final Integer OSN = 4;
    public static final Integer OSN_NAK = 5;
    public static final Integer ACK_REPLAY_INDICATOR = 6;

    public Field330() {
        super(6);
    }

    public Field330(String value) {
        super(value);
    }

    public Field330(Tag tag) {
        this();
        if (tag == null) {
            throw new IllegalArgumentException("tag cannot be null.");
        }
        if (!StringUtils.equals((CharSequence)tag.getName(), (CharSequence)"330")) {
            throw new IllegalArgumentException("cannot create field 330 from tag " + tag.getName() + ", tagname must match the name of the field.");
        }
        this.parse(tag.getValue());
    }

    public static Field330 newInstance(Field330 source) {
        Field330 cp = new Field330();
        cp.setComponents(new ArrayList<String>(source.getComponents()));
        return cp;
    }

    public static Tag tag(String value) {
        return new Tag("330", value);
    }

    public static Tag emptyTag() {
        return new Tag("330", "");
    }

    @Override
    public void parse(String value) {
        this.init(6);
        if (value != null) {
            if (value.length() >= 4) {
                this.setComponent1(StringUtils.substring((String)value, (int)0, (int)4));
            }
            if (value.length() >= 10) {
                this.setComponent2(StringUtils.substring((String)value, (int)4, (int)10));
            }
            if (value.length() >= 16) {
                this.setComponent3(StringUtils.substring((String)value, (int)10, (int)16));
            }
            if (value.length() >= 22) {
                this.setComponent4(StringUtils.substring((String)value, (int)16, (int)22));
            }
            if (value.length() >= 28) {
                this.setComponent5(StringUtils.substring((String)value, (int)22, (int)28));
            }
            if (value.length() > 28) {
                this.setComponent6(StringUtils.substring((String)value, (int)28));
            }
        }
    }

    @Override
    public String getValue() {
        StringBuilder result = new StringBuilder();
        result.append(this.joinComponents());
        return result.toString();
    }

    @Override
    public String getValueDisplay(int component, Locale locale) {
        if (component < 1 || component > 6) {
            throw new IllegalArgumentException("invalid component number " + component + " for field 330");
        }
        if (component == 1) {
            return this.getComponent(1);
        }
        if (component == 2) {
            return this.getComponent(2);
        }
        if (component == 3) {
            return this.getComponent(3);
        }
        if (component == 4) {
            return this.getComponent(4);
        }
        if (component == 5) {
            return this.getComponent(5);
        }
        if (component == 6) {
            return this.getComponent(6);
        }
        return null;
    }

    @Override
    public String typesPattern() {
        return "NNNNNN";
    }

    @Override
    public String parserPattern() {
        return "4!N6!N6!N6!N6!N1!N";
    }

    @Override
    public String validatorPattern() {
        return "4!n6!n6!n6!n6!n1!n";
    }

    @Override
    public boolean isOptional(int component) {
        return false;
    }

    @Override
    public boolean isGeneric() {
        return false;
    }

    @Override
    public int componentsSize() {
        return 6;
    }

    @Override
    public List<String> getComponentLabels() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("Session Number");
        result.add("ISN");
        result.add("ISN NAK");
        result.add("OSN");
        result.add("OSN NAK");
        result.add("ACK Replay Indicator");
        return result;
    }

    @Override
    protected Map<Integer, String> getComponentMap() {
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        result.put(1, "sessionNumber");
        result.put(2, "iSN");
        result.put(3, "iSNNAK");
        result.put(4, "oSN");
        result.put(5, "oSNNAK");
        result.put(6, "aCKReplayIndicator");
        return result;
    }

    @Override
    protected Map<String, Integer> getLabelMap() {
        if (this.labelMap != null && !this.labelMap.isEmpty()) {
            return this.labelMap;
        }
        this.labelMap = new HashMap<String, Integer>();
        this.labelMap.put("sessionnumber", 1);
        this.labelMap.put("isn", 2);
        this.labelMap.put("isnnak", 3);
        this.labelMap.put("osn", 4);
        this.labelMap.put("osnnak", 5);
        this.labelMap.put("ackreplayindicator", 6);
        return this.labelMap;
    }

    public String getComponent1() {
        return this.getComponent(1);
    }

    public Long getComponent1AsLong() {
        return SwiftFormatUtils.getLong(this.getComponent(1));
    }

    public String getSessionNumber() {
        return this.getComponent1();
    }

    public Long getSessionNumberAsLong() {
        return this.getComponent1AsLong();
    }

    public String getComponent2() {
        return this.getComponent(2);
    }

    public Long getComponent2AsLong() {
        return SwiftFormatUtils.getLong(this.getComponent(2));
    }

    public String getISN() {
        return this.getComponent2();
    }

    public Long getISNAsLong() {
        return this.getComponent2AsLong();
    }

    public String getComponent3() {
        return this.getComponent(3);
    }

    public Long getComponent3AsLong() {
        return SwiftFormatUtils.getLong(this.getComponent(3));
    }

    public String getISNNAK() {
        return this.getComponent3();
    }

    public Long getISNNAKAsLong() {
        return this.getComponent3AsLong();
    }

    public String getComponent4() {
        return this.getComponent(4);
    }

    public Long getComponent4AsLong() {
        return SwiftFormatUtils.getLong(this.getComponent(4));
    }

    public String getOSN() {
        return this.getComponent4();
    }

    public Long getOSNAsLong() {
        return this.getComponent4AsLong();
    }

    public String getComponent5() {
        return this.getComponent(5);
    }

    public Long getComponent5AsLong() {
        return SwiftFormatUtils.getLong(this.getComponent(5));
    }

    public String getOSNNAK() {
        return this.getComponent5();
    }

    public Long getOSNNAKAsLong() {
        return this.getComponent5AsLong();
    }

    public String getComponent6() {
        return this.getComponent(6);
    }

    public Long getComponent6AsLong() {
        return SwiftFormatUtils.getLong(this.getComponent(6));
    }

    public String getACKReplayIndicator() {
        return this.getComponent6();
    }

    public Long getACKReplayIndicatorAsLong() {
        return this.getComponent6AsLong();
    }

    public Field330 setComponent1(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field330 setComponent1(Long component1) {
        this.setComponent(1, SwiftFormatUtils.getLong(component1));
        return this;
    }

    public Field330 setComponent1(Number component1) {
        if (component1 instanceof Long) {
            this.setComponent(1, SwiftFormatUtils.getLong((Long)component1));
        } else if (component1 instanceof BigInteger || component1 instanceof Integer) {
            this.setComponent(1, SwiftFormatUtils.getLong(component1.longValue()));
        } else if (component1 != null) {
            this.setComponent(1, SwiftFormatUtils.getLong(component1.longValue()));
        } else {
            this.setComponent(1, null);
        }
        return this;
    }

    public Field330 setSessionNumber(String component1) {
        return this.setComponent1(component1);
    }

    public Field330 setSessionNumber(Long component1) {
        return this.setComponent1(component1);
    }

    public Field330 setSessionNumber(Number component1) {
        return this.setComponent1(component1);
    }

    public Field330 setComponent2(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field330 setComponent2(Long component2) {
        this.setComponent(2, SwiftFormatUtils.getLong(component2));
        return this;
    }

    public Field330 setComponent2(Number component2) {
        if (component2 instanceof Long) {
            this.setComponent(2, SwiftFormatUtils.getLong((Long)component2));
        } else if (component2 instanceof BigInteger || component2 instanceof Integer) {
            this.setComponent(2, SwiftFormatUtils.getLong(component2.longValue()));
        } else if (component2 != null) {
            this.setComponent(2, SwiftFormatUtils.getLong(component2.longValue()));
        } else {
            this.setComponent(2, null);
        }
        return this;
    }

    public Field330 setISN(String component2) {
        return this.setComponent2(component2);
    }

    public Field330 setISN(Long component2) {
        return this.setComponent2(component2);
    }

    public Field330 setISN(Number component2) {
        return this.setComponent2(component2);
    }

    public Field330 setComponent3(String component3) {
        this.setComponent(3, component3);
        return this;
    }

    public Field330 setComponent3(Long component3) {
        this.setComponent(3, SwiftFormatUtils.getLong(component3));
        return this;
    }

    public Field330 setComponent3(Number component3) {
        if (component3 instanceof Long) {
            this.setComponent(3, SwiftFormatUtils.getLong((Long)component3));
        } else if (component3 instanceof BigInteger || component3 instanceof Integer) {
            this.setComponent(3, SwiftFormatUtils.getLong(component3.longValue()));
        } else if (component3 != null) {
            this.setComponent(3, SwiftFormatUtils.getLong(component3.longValue()));
        } else {
            this.setComponent(3, null);
        }
        return this;
    }

    public Field330 setISNNAK(String component3) {
        return this.setComponent3(component3);
    }

    public Field330 setISNNAK(Long component3) {
        return this.setComponent3(component3);
    }

    public Field330 setISNNAK(Number component3) {
        return this.setComponent3(component3);
    }

    public Field330 setComponent4(String component4) {
        this.setComponent(4, component4);
        return this;
    }

    public Field330 setComponent4(Long component4) {
        this.setComponent(4, SwiftFormatUtils.getLong(component4));
        return this;
    }

    public Field330 setComponent4(Number component4) {
        if (component4 instanceof Long) {
            this.setComponent(4, SwiftFormatUtils.getLong((Long)component4));
        } else if (component4 instanceof BigInteger || component4 instanceof Integer) {
            this.setComponent(4, SwiftFormatUtils.getLong(component4.longValue()));
        } else if (component4 != null) {
            this.setComponent(4, SwiftFormatUtils.getLong(component4.longValue()));
        } else {
            this.setComponent(4, null);
        }
        return this;
    }

    public Field330 setOSN(String component4) {
        return this.setComponent4(component4);
    }

    public Field330 setOSN(Long component4) {
        return this.setComponent4(component4);
    }

    public Field330 setOSN(Number component4) {
        return this.setComponent4(component4);
    }

    public Field330 setComponent5(String component5) {
        this.setComponent(5, component5);
        return this;
    }

    public Field330 setComponent5(Long component5) {
        this.setComponent(5, SwiftFormatUtils.getLong(component5));
        return this;
    }

    public Field330 setComponent5(Number component5) {
        if (component5 instanceof Long) {
            this.setComponent(5, SwiftFormatUtils.getLong((Long)component5));
        } else if (component5 instanceof BigInteger || component5 instanceof Integer) {
            this.setComponent(5, SwiftFormatUtils.getLong(component5.longValue()));
        } else if (component5 != null) {
            this.setComponent(5, SwiftFormatUtils.getLong(component5.longValue()));
        } else {
            this.setComponent(5, null);
        }
        return this;
    }

    public Field330 setOSNNAK(String component5) {
        return this.setComponent5(component5);
    }

    public Field330 setOSNNAK(Long component5) {
        return this.setComponent5(component5);
    }

    public Field330 setOSNNAK(Number component5) {
        return this.setComponent5(component5);
    }

    public Field330 setComponent6(String component6) {
        this.setComponent(6, component6);
        return this;
    }

    public Field330 setComponent6(Long component6) {
        this.setComponent(6, SwiftFormatUtils.getLong(component6));
        return this;
    }

    public Field330 setComponent6(Number component6) {
        if (component6 instanceof Long) {
            this.setComponent(6, SwiftFormatUtils.getLong((Long)component6));
        } else if (component6 instanceof BigInteger || component6 instanceof Integer) {
            this.setComponent(6, SwiftFormatUtils.getLong(component6.longValue()));
        } else if (component6 != null) {
            this.setComponent(6, SwiftFormatUtils.getLong(component6.longValue()));
        } else {
            this.setComponent(6, null);
        }
        return this;
    }

    public Field330 setACKReplayIndicator(String component6) {
        return this.setComponent6(component6);
    }

    public Field330 setACKReplayIndicator(Long component6) {
        return this.setComponent6(component6);
    }

    public Field330 setACKReplayIndicator(Number component6) {
        return this.setComponent6(component6);
    }

    @Override
    public String getName() {
        return "330";
    }

    public static Field330 get(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return null;
        }
        Tag t = block.getTagByName("330");
        if (t == null) {
            return null;
        }
        return new Field330(t);
    }

    public static Field330 get(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return null;
        }
        return Field330.get(msg.getBlock4());
    }

    public static List<Field330> getAll(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return Collections.emptyList();
        }
        return Field330.getAll(msg.getBlock4());
    }

    public static List<Field330> getAll(SwiftTagListBlock block) {
        ArrayList<Field330> result = new ArrayList<Field330>();
        if (block == null || block.isEmpty()) {
            return result;
        }
        Tag[] arr = block.getTagsByName("330");
        if (arr != null && arr.length > 0) {
            for (Tag f : arr) {
                result.add(new Field330(f));
            }
        }
        return result;
    }

    public static Field330 fromJson(String json) {
        Field330 field = new Field330();
        JsonObject jsonObject = JsonParser.parseString((String)json).getAsJsonObject();
        if (jsonObject.get("sessionNumber") != null) {
            field.setComponent1(jsonObject.get("sessionNumber").getAsString());
        }
        if (jsonObject.get("iSN") != null) {
            field.setComponent2(jsonObject.get("iSN").getAsString());
        }
        if (jsonObject.get("iSNNAK") != null) {
            field.setComponent3(jsonObject.get("iSNNAK").getAsString());
        }
        if (jsonObject.get("oSN") != null) {
            field.setComponent4(jsonObject.get("oSN").getAsString());
        }
        if (jsonObject.get("oSNNAK") != null) {
            field.setComponent5(jsonObject.get("oSNNAK").getAsString());
        }
        if (jsonObject.get("aCKReplayIndicator") != null) {
            field.setComponent6(jsonObject.get("aCKReplayIndicator").getAsString());
        }
        return field;
    }
}

