/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.CurrencyContainer;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.GenericField;
import com.prowidesoftware.swift.model.field.MonetaryAmountContainer;
import com.prowidesoftware.swift.model.field.MonetaryAmountResolver;
import com.prowidesoftware.swift.model.field.SwiftParseUtils;
import com.prowidesoftware.swift.utils.SwiftFormatUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Currency;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class Field92F
extends Field
implements Serializable,
MonetaryAmountContainer,
GenericField {
    public static final int SRU = 2024;
    private static final long serialVersionUID = 1L;
    public static final String NAME = "92F";
    public static final String F_92F = "92F";
    public static final Integer QUALIFIER = 1;
    public static final Integer CURRENCY_CODE = 2;
    public static final Integer AMOUNT = 3;
    public static final Integer CONDITIONAL_QUALIFIER = 2;

    public Field92F() {
        super(3);
    }

    public Field92F(String value) {
        super(value);
    }

    public Field92F(Tag tag) {
        this();
        if (tag == null) {
            throw new IllegalArgumentException("tag cannot be null.");
        }
        if (!StringUtils.equals((CharSequence)tag.getName(), (CharSequence)"92F")) {
            throw new IllegalArgumentException("cannot create field 92F from tag " + tag.getName() + ", tagname must match the name of the field.");
        }
        this.parse(tag.getValue());
    }

    public static Field92F newInstance(Field92F source) {
        Field92F cp = new Field92F();
        cp.setComponents(new ArrayList<String>(source.getComponents()));
        return cp;
    }

    public static Tag tag(String value) {
        return new Tag("92F", value);
    }

    public static Tag emptyTag() {
        return new Tag("92F", "");
    }

    @Override
    public void parse(String value) {
        this.init(3);
        this.setComponent1(SwiftParseUtils.getTokenFirst(value, ":", "//"));
        String toparse = SwiftParseUtils.getTokenSecondLast(value, "//");
        this.setComponent2(SwiftParseUtils.getAlphaPrefixTrimSlash(toparse));
        this.setComponent3(SwiftParseUtils.getNumericSuffix(toparse));
    }

    @Override
    public String getValue() {
        StringBuilder result = new StringBuilder();
        result.append(":");
        this.append(result, 1);
        result.append("//");
        this.append(result, 2);
        this.append(result, 3);
        return result.toString();
    }

    @Override
    public String getValueDisplay(int component, Locale locale) {
        if (component < 1 || component > 3) {
            throw new IllegalArgumentException("invalid component number " + component + " for field 92F");
        }
        if (component == 1) {
            return this.getComponent(1);
        }
        if (component == 2) {
            return this.getComponent(2);
        }
        if (component == 3) {
            NumberFormat f = NumberFormat.getNumberInstance(this.notNull(locale));
            f.setMaximumFractionDigits(13);
            BigDecimal n = this.getComponent3AsBigDecimal();
            if (n != null) {
                return f.format(n);
            }
        }
        return null;
    }

    @Override
    public String typesPattern() {
        return "SCI";
    }

    @Override
    public String parserPattern() {
        return ":S//SN";
    }

    @Override
    public String validatorPattern() {
        return ":4!c//<CUR><AMOUNT>15";
    }

    @Override
    public boolean isOptional(int component) {
        return false;
    }

    @Override
    public boolean isGeneric() {
        return true;
    }

    @Override
    public int componentsSize() {
        return 3;
    }

    @Override
    public List<String> getComponentLabels() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("Qualifier");
        result.add("Currency Code");
        result.add("Amount");
        return result;
    }

    @Override
    protected Map<Integer, String> getComponentMap() {
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        result.put(1, "qualifier");
        result.put(2, "currencyCode");
        result.put(3, "amount");
        return result;
    }

    @Override
    protected Map<String, Integer> getLabelMap() {
        if (this.labelMap != null && !this.labelMap.isEmpty()) {
            return this.labelMap;
        }
        this.labelMap = new HashMap<String, Integer>();
        this.labelMap.put("qualifier", 1);
        this.labelMap.put("currencycode", 2);
        this.labelMap.put("currency", 2);
        this.labelMap.put("amount", 3);
        return this.labelMap;
    }

    public String getComponent1() {
        return this.getComponent(1);
    }

    public String getQualifier() {
        return this.getComponent1();
    }

    public String getComponent2() {
        return this.getComponent(2);
    }

    public Currency getComponent2AsCurrency() {
        return SwiftFormatUtils.getCurrency(this.getComponent(2));
    }

    public String getCurrencyCode() {
        return this.getComponent2();
    }

    public Currency getCurrencyCodeAsCurrency() {
        return this.getComponent2AsCurrency();
    }

    public String getComponent3() {
        return this.getComponent(3);
    }

    public BigDecimal getComponent3AsBigDecimal() {
        return SwiftFormatUtils.getBigDecimal(this.getComponent(3));
    }

    public String getAmount() {
        return this.getComponent3();
    }

    public BigDecimal getAmountAsBigDecimal() {
        return this.getComponent3AsBigDecimal();
    }

    public Field92F setComponent1(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field92F setQualifier(String component1) {
        return this.setComponent1(component1);
    }

    public Field92F setComponent2(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field92F setComponent2(Currency component2) {
        this.setComponent(2, SwiftFormatUtils.getCurrency(component2));
        return this;
    }

    public Field92F setCurrencyCode(String component2) {
        return this.setComponent2(component2);
    }

    public Field92F setCurrencyCode(Currency component2) {
        return this.setComponent2(component2);
    }

    public Field92F setComponent3(String component3) {
        this.setComponent(3, component3);
        return this;
    }

    public Field92F setComponent3(BigDecimal component3) {
        this.setComponent(3, SwiftFormatUtils.getBigDecimal(component3));
        return this;
    }

    public Field92F setComponent3(Number component3) {
        if (component3 instanceof BigDecimal) {
            this.setComponent(3, SwiftFormatUtils.getBigDecimal((BigDecimal)component3));
        } else if (component3 instanceof BigInteger) {
            this.setComponent(3, SwiftFormatUtils.getBigDecimal(new BigDecimal((BigInteger)component3)));
        } else if (component3 instanceof Long || component3 instanceof Integer) {
            this.setComponent(3, SwiftFormatUtils.getBigDecimal(BigDecimal.valueOf(component3.longValue())));
        } else if (component3 != null) {
            this.setComponent(3, SwiftFormatUtils.getBigDecimal(BigDecimal.valueOf(component3.doubleValue())));
        } else {
            this.setComponent(3, null);
        }
        return this;
    }

    public Field92F setAmount(String component3) {
        return this.setComponent3(component3);
    }

    public Field92F setAmount(BigDecimal component3) {
        return this.setComponent3(component3);
    }

    public Field92F setAmount(Number component3) {
        return this.setComponent3(component3);
    }

    @Override
    public List<String> currencyStrings() {
        return MonetaryAmountResolver.currencyStrings(this);
    }

    @Override
    public List<Currency> currencies() {
        return MonetaryAmountResolver.currencies(this);
    }

    @Override
    public Currency currency() {
        return MonetaryAmountResolver.resolveCurrency(this);
    }

    @Override
    public String currencyString() {
        return MonetaryAmountResolver.resolveCurrencyString(this);
    }

    @Override
    public void initializeCurrencies(String cur) {
        MonetaryAmountResolver.resolveSetCurrency((CurrencyContainer)this, cur);
    }

    @Override
    public void initializeCurrencies(Currency cur) {
        MonetaryAmountResolver.resolveSetCurrency((CurrencyContainer)this, cur);
    }

    public List<BigDecimal> amounts() {
        return MonetaryAmountResolver.amounts(this);
    }

    @Override
    public BigDecimal amount() {
        return MonetaryAmountResolver.amount(this);
    }

    @Override
    public String getDSS() {
        return null;
    }

    @Override
    public boolean isDSSPresent() {
        return false;
    }

    @Override
    public String getConditionalQualifier() {
        return this.getComponent(CONDITIONAL_QUALIFIER);
    }

    @Override
    public String getName() {
        return "92F";
    }

    public static Field92F get(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return null;
        }
        Tag t = block.getTagByName("92F");
        if (t == null) {
            return null;
        }
        return new Field92F(t);
    }

    public static Field92F get(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return null;
        }
        return Field92F.get(msg.getBlock4());
    }

    public static List<Field92F> getAll(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return Collections.emptyList();
        }
        return Field92F.getAll(msg.getBlock4());
    }

    public static List<Field92F> getAll(SwiftTagListBlock block) {
        ArrayList<Field92F> result = new ArrayList<Field92F>();
        if (block == null || block.isEmpty()) {
            return result;
        }
        Tag[] arr = block.getTagsByName("92F");
        if (arr != null && arr.length > 0) {
            for (Tag f : arr) {
                result.add(new Field92F(f));
            }
        }
        return result;
    }

    public static Field92F fromJson(String json) {
        Field92F field = new Field92F();
        JsonObject jsonObject = JsonParser.parseString((String)json).getAsJsonObject();
        if (jsonObject.get("qualifier") != null) {
            field.setComponent1(jsonObject.get("qualifier").getAsString());
        }
        if (jsonObject.get("currency") != null) {
            field.setComponent2(jsonObject.get("currency").getAsString());
        }
        if (jsonObject.get("currencyCode") != null) {
            field.setComponent2(jsonObject.get("currencyCode").getAsString());
        }
        if (jsonObject.get("amount") != null) {
            field.setComponent3(jsonObject.get("amount").getAsString());
        }
        return field;
    }
}

