/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.GenericField;
import com.prowidesoftware.swift.model.field.SwiftParseUtils;
import com.prowidesoftware.swift.utils.SwiftFormatUtils;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class Field99A
extends Field
implements Serializable,
GenericField {
    public static final int SRU = 2024;
    private static final long serialVersionUID = 1L;
    public static final String NAME = "99A";
    public static final String F_99A = "99A";
    public static final Integer QUALIFIER = 1;
    public static final Integer SIGN = 2;
    public static final Integer NUMBER = 3;
    public static final Integer CONDITIONAL_QUALIFIER = 2;

    public Field99A() {
        super(3);
    }

    public Field99A(String value) {
        super(value);
    }

    public Field99A(Tag tag) {
        this();
        if (tag == null) {
            throw new IllegalArgumentException("tag cannot be null.");
        }
        if (!StringUtils.equals((CharSequence)tag.getName(), (CharSequence)"99A")) {
            throw new IllegalArgumentException("cannot create field 99A from tag " + tag.getName() + ", tagname must match the name of the field.");
        }
        this.parse(tag.getValue());
    }

    public static Field99A newInstance(Field99A source) {
        Field99A cp = new Field99A();
        cp.setComponents(new ArrayList<String>(source.getComponents()));
        return cp;
    }

    public static Tag tag(String value) {
        return new Tag("99A", value);
    }

    public static Tag emptyTag() {
        return new Tag("99A", "");
    }

    @Override
    public void parse(String value) {
        this.init(3);
        this.setComponent1(SwiftParseUtils.getTokenFirst(value, ":", "//"));
        String toparse = SwiftParseUtils.getTokenSecondLast(value, "//");
        this.setComponent2(SwiftParseUtils.getAlphaPrefixTrimSlash(toparse));
        this.setComponent3(SwiftParseUtils.getNumericSuffix(toparse));
    }

    @Override
    public String getValue() {
        StringBuilder result = new StringBuilder();
        result.append(":");
        this.append(result, 1);
        result.append("//");
        this.append(result, 2);
        this.append(result, 3);
        return result.toString();
    }

    @Override
    public String getValueDisplay(int component, Locale locale) {
        if (component < 1 || component > 3) {
            throw new IllegalArgumentException("invalid component number " + component + " for field 99A");
        }
        if (component == 1) {
            return this.getComponent(1);
        }
        if (component == 2) {
            return this.getComponent(2);
        }
        if (component == 3) {
            return this.getComponent(3);
        }
        return null;
    }

    @Override
    public String typesPattern() {
        return "SSN";
    }

    @Override
    public String parserPattern() {
        return ":S//[S]N";
    }

    @Override
    public String validatorPattern() {
        return ":4!c//[<N>]3!n";
    }

    @Override
    public boolean isOptional(int component) {
        return component == 2;
    }

    @Override
    public boolean isGeneric() {
        return true;
    }

    @Override
    public int componentsSize() {
        return 3;
    }

    @Override
    public List<String> getComponentLabels() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("Qualifier");
        result.add("Sign");
        result.add("Number");
        return result;
    }

    @Override
    protected Map<Integer, String> getComponentMap() {
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        result.put(1, "qualifier");
        result.put(2, "sign");
        result.put(3, "number");
        return result;
    }

    @Override
    protected Map<String, Integer> getLabelMap() {
        if (this.labelMap != null && !this.labelMap.isEmpty()) {
            return this.labelMap;
        }
        this.labelMap = new HashMap<String, Integer>();
        this.labelMap.put("qualifier", 1);
        this.labelMap.put("sign", 2);
        this.labelMap.put("number", 3);
        this.labelMap.put("amount", 3);
        return this.labelMap;
    }

    public String getComponent1() {
        return this.getComponent(1);
    }

    public String getQualifier() {
        return this.getComponent1();
    }

    public String getComponent2() {
        return this.getComponent(2);
    }

    public String getSign() {
        return this.getComponent2();
    }

    public String getComponent3() {
        return this.getComponent(3);
    }

    public Long getComponent3AsLong() {
        return SwiftFormatUtils.getLong(this.getComponent(3));
    }

    public String getNumber() {
        return this.getComponent3();
    }

    public Long getNumberAsLong() {
        return this.getComponent3AsLong();
    }

    public Field99A setComponent1(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field99A setQualifier(String component1) {
        return this.setComponent1(component1);
    }

    public Field99A setComponent2(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field99A setSign(String component2) {
        return this.setComponent2(component2);
    }

    public Field99A setComponent3(String component3) {
        this.setComponent(3, component3);
        return this;
    }

    public Field99A setComponent3(Long component3) {
        this.setComponent(3, SwiftFormatUtils.getLong(component3));
        return this;
    }

    public Field99A setComponent3(Number component3) {
        if (component3 instanceof Long) {
            this.setComponent(3, SwiftFormatUtils.getLong((Long)component3));
        } else if (component3 instanceof BigInteger || component3 instanceof Integer) {
            this.setComponent(3, SwiftFormatUtils.getLong(component3.longValue()));
        } else if (component3 != null) {
            this.setComponent(3, SwiftFormatUtils.getLong(component3.longValue()));
        } else {
            this.setComponent(3, null);
        }
        return this;
    }

    public Field99A setNumber(String component3) {
        return this.setComponent3(component3);
    }

    public Field99A setNumber(Long component3) {
        return this.setComponent3(component3);
    }

    public Field99A setNumber(Number component3) {
        return this.setComponent3(component3);
    }

    @Override
    public String getDSS() {
        return null;
    }

    @Override
    public boolean isDSSPresent() {
        return false;
    }

    @Override
    public String getConditionalQualifier() {
        return this.getComponent(CONDITIONAL_QUALIFIER);
    }

    @Override
    public String getName() {
        return "99A";
    }

    public static Field99A get(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return null;
        }
        Tag t = block.getTagByName("99A");
        if (t == null) {
            return null;
        }
        return new Field99A(t);
    }

    public static Field99A get(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return null;
        }
        return Field99A.get(msg.getBlock4());
    }

    public static List<Field99A> getAll(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return Collections.emptyList();
        }
        return Field99A.getAll(msg.getBlock4());
    }

    public static List<Field99A> getAll(SwiftTagListBlock block) {
        ArrayList<Field99A> result = new ArrayList<Field99A>();
        if (block == null || block.isEmpty()) {
            return result;
        }
        Tag[] arr = block.getTagsByName("99A");
        if (arr != null && arr.length > 0) {
            for (Tag f : arr) {
                result.add(new Field99A(f));
            }
        }
        return result;
    }

    public static Field99A fromJson(String json) {
        Field99A field = new Field99A();
        JsonObject jsonObject = JsonParser.parseString((String)json).getAsJsonObject();
        if (jsonObject.get("qualifier") != null) {
            field.setComponent1(jsonObject.get("qualifier").getAsString());
        }
        if (jsonObject.get("sign") != null) {
            field.setComponent2(jsonObject.get("sign").getAsString());
        }
        if (jsonObject.get("amount") != null) {
            field.setComponent3(jsonObject.get("amount").getAsString());
        }
        if (jsonObject.get("number") != null) {
            field.setComponent3(jsonObject.get("number").getAsString());
        }
        return field;
    }
}

