/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.utils.SwiftFormatUtils;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class Field332
extends Field
implements Serializable {
    public static final int SRU = 2024;
    private static final long serialVersionUID = 1L;
    public static final String NAME = "332";
    public static final String F_332 = "332";
    public static final Integer TOTAL_MESSAGES_SENT = 1;
    public static final Integer TOTAL_MESSAGES_RECEIVED = 2;

    public Field332() {
        super(2);
    }

    public Field332(String value) {
        super(value);
    }

    public Field332(Tag tag) {
        this();
        if (tag == null) {
            throw new IllegalArgumentException("tag cannot be null.");
        }
        if (!StringUtils.equals((CharSequence)tag.getName(), (CharSequence)"332")) {
            throw new IllegalArgumentException("cannot create field 332 from tag " + tag.getName() + ", tagname must match the name of the field.");
        }
        this.parse(tag.getValue());
    }

    public static Field332 newInstance(Field332 source) {
        Field332 cp = new Field332();
        cp.setComponents(new ArrayList<String>(source.getComponents()));
        return cp;
    }

    public static Tag tag(String value) {
        return new Tag("332", value);
    }

    public static Tag emptyTag() {
        return new Tag("332", "");
    }

    @Override
    public void parse(String value) {
        this.init(2);
        if (value != null) {
            if (value.length() >= 6) {
                this.setComponent1(StringUtils.substring((String)value, (int)0, (int)6));
            }
            if (value.length() > 6) {
                this.setComponent2(StringUtils.substring((String)value, (int)6));
            }
        }
    }

    @Override
    public String getValue() {
        StringBuilder result = new StringBuilder();
        result.append(this.joinComponents());
        return result.toString();
    }

    @Override
    public String getValueDisplay(int component, Locale locale) {
        if (component < 1 || component > 2) {
            throw new IllegalArgumentException("invalid component number " + component + " for field 332");
        }
        if (component == 1) {
            return this.getComponent(1);
        }
        return this.getComponent(2);
    }

    @Override
    public String typesPattern() {
        return "NN";
    }

    @Override
    public String parserPattern() {
        return "6!N6!N";
    }

    @Override
    public String validatorPattern() {
        return "6!n6!n";
    }

    @Override
    public boolean isOptional(int component) {
        return false;
    }

    @Override
    public boolean isGeneric() {
        return false;
    }

    @Override
    public int componentsSize() {
        return 2;
    }

    @Override
    public List<String> getComponentLabels() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("Total Messages Sent");
        result.add("Total Messages Received");
        return result;
    }

    @Override
    protected Map<Integer, String> getComponentMap() {
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        result.put(1, "totalMessagesSent");
        result.put(2, "totalMessagesReceived");
        return result;
    }

    @Override
    protected Map<String, Integer> getLabelMap() {
        if (this.labelMap != null && !this.labelMap.isEmpty()) {
            return this.labelMap;
        }
        this.labelMap = new HashMap<String, Integer>();
        this.labelMap.put("totalmessagessent", 1);
        this.labelMap.put("totalmessagesreceived", 2);
        return this.labelMap;
    }

    public String getComponent1() {
        return this.getComponent(1);
    }

    public Long getComponent1AsLong() {
        return SwiftFormatUtils.getLong(this.getComponent(1));
    }

    public String getTotalMessagesSent() {
        return this.getComponent1();
    }

    public Long getTotalMessagesSentAsLong() {
        return this.getComponent1AsLong();
    }

    public String getComponent2() {
        return this.getComponent(2);
    }

    public Long getComponent2AsLong() {
        return SwiftFormatUtils.getLong(this.getComponent(2));
    }

    public String getTotalMessagesReceived() {
        return this.getComponent2();
    }

    public Long getTotalMessagesReceivedAsLong() {
        return this.getComponent2AsLong();
    }

    public Field332 setComponent1(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field332 setComponent1(Number component1) {
        if (component1 instanceof Long) {
            this.setComponent(1, SwiftFormatUtils.getLong((Long)component1));
        } else if (component1 instanceof BigInteger || component1 instanceof Integer) {
            this.setComponent(1, SwiftFormatUtils.getLong(component1.longValue()));
        } else if (component1 != null) {
            this.setComponent(1, SwiftFormatUtils.getLong(component1.longValue()));
        } else {
            this.setComponent(1, null);
        }
        return this;
    }

    public Field332 setTotalMessagesSent(String component1) {
        return this.setComponent1(component1);
    }

    public Field332 setTotalMessagesSent(Number component1) {
        return this.setComponent1(component1);
    }

    public Field332 setComponent2(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field332 setComponent2(Number component2) {
        if (component2 instanceof Long) {
            this.setComponent(2, SwiftFormatUtils.getLong((Long)component2));
        } else if (component2 instanceof BigInteger || component2 instanceof Integer) {
            this.setComponent(2, SwiftFormatUtils.getLong(component2.longValue()));
        } else if (component2 != null) {
            this.setComponent(2, SwiftFormatUtils.getLong(component2.longValue()));
        } else {
            this.setComponent(2, null);
        }
        return this;
    }

    public Field332 setTotalMessagesReceived(String component2) {
        return this.setComponent2(component2);
    }

    public Field332 setTotalMessagesReceived(Number component2) {
        return this.setComponent2(component2);
    }

    @Override
    public String getName() {
        return "332";
    }

    public static Field332 get(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return null;
        }
        Tag t = block.getTagByName("332");
        if (t == null) {
            return null;
        }
        return new Field332(t);
    }

    public static Field332 get(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return null;
        }
        return Field332.get(msg.getBlock4());
    }

    public static List<Field332> getAll(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return Collections.emptyList();
        }
        return Field332.getAll(msg.getBlock4());
    }

    public static List<Field332> getAll(SwiftTagListBlock block) {
        ArrayList<Field332> result = new ArrayList<Field332>();
        if (block == null || block.isEmpty()) {
            return result;
        }
        Tag[] arr = block.getTagsByName("332");
        if (arr != null) {
            for (Tag f : arr) {
                result.add(new Field332(f));
            }
        }
        return result;
    }

    public static Field332 fromJson(String json) {
        Field332 field = new Field332();
        JsonObject jsonObject = JsonParser.parseString((String)json).getAsJsonObject();
        if (jsonObject.get("totalMessagesSent") != null) {
            field.setComponent1(jsonObject.get("totalMessagesSent").getAsString());
        }
        if (jsonObject.get("totalMessagesReceived") != null) {
            field.setComponent2(jsonObject.get("totalMessagesReceived").getAsString());
        }
        return field;
    }
}

