/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.io;

import com.prowidesoftware.swift.io.AbstractWriter;
import com.prowidesoftware.swift.model.mt.AbstractMT;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Objects;

public class PPCWriter
extends AbstractWriter {
    private static final int SECTOR = 512;

    public PPCWriter(Writer writer) {
        super(writer);
    }

    public PPCWriter(File _file, Charset _charset) throws FileNotFoundException {
        super(_file, _charset);
    }

    public PPCWriter(OutputStream _stream, Charset _charset) {
        super(_stream, _charset);
    }

    public static void write(AbstractMT msg, Writer writer) throws IOException {
        Objects.requireNonNull(msg, "message to write cannot be null");
        PPCWriter.write(msg.message(), writer);
    }

    public static void write(String msg, Writer writer) throws IOException {
        Objects.requireNonNull(writer, "writer has not been initialized");
        Objects.requireNonNull(msg, "message to write cannot be null");
        writer.write(1);
        writer.write(msg);
        writer.write(3);
        int length = msg.length() + 2;
        int pad = PPCWriter.requiredPadding(length);
        for (int i = 0; i < pad; ++i) {
            writer.write(32);
        }
    }

    private static int requiredPadding(int length) {
        return (512 - length % 512) % 512;
    }

    public void write(String msg) throws IOException {
        PPCWriter.write(msg, this.writer);
    }

    public void write(AbstractMT msg) throws IOException {
        PPCWriter.write(msg, this.writer);
    }
}

