/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.DateContainer;
import com.prowidesoftware.swift.model.field.DateResolver;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.utils.SwiftFormatUtils;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class Field109
extends Field
implements Serializable,
DateContainer {
    public static final int SRU = 2024;
    private static final long serialVersionUID = 1L;
    public static final String NAME = "109";
    public static final String F_109 = "109";
    public static final Integer DATE = 1;
    public static final Integer TIME = 2;
    public static final Integer MIR = 3;

    public Field109() {
        super(3);
    }

    public Field109(String value) {
        super(value);
    }

    public Field109(Tag tag) {
        this();
        if (tag == null) {
            throw new IllegalArgumentException("tag cannot be null.");
        }
        if (!StringUtils.equals((CharSequence)tag.getName(), (CharSequence)"109")) {
            throw new IllegalArgumentException("cannot create field 109 from tag " + tag.getName() + ", tagname must match the name of the field.");
        }
        this.parse(tag.getValue());
    }

    public static Field109 newInstance(Field109 source) {
        Field109 cp = new Field109();
        cp.setComponents(new ArrayList<String>(source.getComponents()));
        return cp;
    }

    public static Tag tag(String value) {
        return new Tag("109", value);
    }

    public static Tag emptyTag() {
        return new Tag("109", "");
    }

    @Override
    public void parse(String value) {
        this.init(3);
        if (value != null) {
            if (value.length() >= 6) {
                this.setComponent1(StringUtils.substring((String)value, (int)0, (int)6));
            }
            if (value.length() >= 12) {
                this.setComponent2(StringUtils.substring((String)value, (int)6, (int)12));
            }
            if (value.length() > 12) {
                this.setComponent3(StringUtils.substring((String)value, (int)12));
            }
        }
    }

    @Override
    public String getValue() {
        StringBuilder result = new StringBuilder();
        result.append(this.joinComponents());
        return result.toString();
    }

    @Override
    public String getValueDisplay(int component, Locale locale) {
        Calendar cal;
        DateFormat f;
        if (component < 1 || component > 3) {
            throw new IllegalArgumentException("invalid component number " + component + " for field 109");
        }
        if (component == 1) {
            f = DateFormat.getDateInstance(2, this.notNull(locale));
            cal = this.getComponent1AsCalendar();
            if (cal != null) {
                return f.format(cal.getTime());
            }
        }
        if (component == 2) {
            f = new SimpleDateFormat("HH:mm:ss", this.notNull(locale));
            cal = this.getComponent2AsCalendar();
            if (cal != null) {
                return f.format(cal.getTime());
            }
        }
        return this.getComponent(3);
    }

    @Override
    public String typesPattern() {
        return "DTS";
    }

    @Override
    public String parserPattern() {
        return "<DATE2><TIME2>S";
    }

    @Override
    public String validatorPattern() {
        return "<DATE2><TIME2><MIR>";
    }

    @Override
    public boolean isOptional(int component) {
        return false;
    }

    @Override
    public boolean isGeneric() {
        return false;
    }

    @Override
    public int componentsSize() {
        return 3;
    }

    @Override
    public List<String> getComponentLabels() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("Date");
        result.add("Time");
        result.add("MIR");
        return result;
    }

    @Override
    protected Map<Integer, String> getComponentMap() {
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        result.put(1, "date");
        result.put(2, "time");
        result.put(3, "mIR");
        return result;
    }

    @Override
    protected Map<String, Integer> getLabelMap() {
        if (this.labelMap != null && !this.labelMap.isEmpty()) {
            return this.labelMap;
        }
        this.labelMap = new HashMap<String, Integer>();
        this.labelMap.put("date", 1);
        this.labelMap.put("time", 2);
        this.labelMap.put("mir", 3);
        return this.labelMap;
    }

    public String getComponent1() {
        return this.getComponent(1);
    }

    public Calendar getComponent1AsCalendar() {
        return SwiftFormatUtils.getDate4(this.getComponent(1));
    }

    public String getDate() {
        return this.getComponent1();
    }

    public Calendar getDateAsCalendar() {
        return this.getComponent1AsCalendar();
    }

    public String getComponent2() {
        return this.getComponent(2);
    }

    public Calendar getComponent2AsCalendar() {
        return SwiftFormatUtils.getTime2(this.getComponent(2));
    }

    public String getTime() {
        return this.getComponent2();
    }

    public Calendar getTimeAsCalendar() {
        return this.getComponent2AsCalendar();
    }

    public String getComponent3() {
        return this.getComponent(3);
    }

    public String getMIR() {
        return this.getComponent3();
    }

    public Field109 setComponent1(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field109 setComponent1(Calendar component1) {
        this.setComponent(1, SwiftFormatUtils.getDate4(component1));
        return this;
    }

    public Field109 setDate(String component1) {
        return this.setComponent1(component1);
    }

    public Field109 setDate(Calendar component1) {
        return this.setComponent1(component1);
    }

    public Field109 setComponent2(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field109 setComponent2(Calendar component2) {
        this.setComponent(2, SwiftFormatUtils.getTime2(component2));
        return this;
    }

    public Field109 setTime(String component2) {
        return this.setComponent2(component2);
    }

    public Field109 setTime(Calendar component2) {
        return this.setComponent2(component2);
    }

    public Field109 setComponent3(String component3) {
        this.setComponent(3, component3);
        return this;
    }

    public Field109 setMIR(String component3) {
        return this.setComponent3(component3);
    }

    @Override
    public List<Calendar> dates() {
        return DateResolver.dates(this);
    }

    public Calendar date() {
        return DateResolver.date(this);
    }

    @Override
    public String getName() {
        return "109";
    }

    public static Field109 get(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return null;
        }
        Tag t = block.getTagByName("109");
        if (t == null) {
            return null;
        }
        return new Field109(t);
    }

    public static Field109 get(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return null;
        }
        return Field109.get(msg.getBlock4());
    }

    public static List<Field109> getAll(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return Collections.emptyList();
        }
        return Field109.getAll(msg.getBlock4());
    }

    public static List<Field109> getAll(SwiftTagListBlock block) {
        ArrayList<Field109> result = new ArrayList<Field109>();
        if (block == null || block.isEmpty()) {
            return result;
        }
        Tag[] arr = block.getTagsByName("109");
        if (arr != null) {
            for (Tag f : arr) {
                result.add(new Field109(f));
            }
        }
        return result;
    }

    public static Field109 fromJson(String json) {
        Field109 field = new Field109();
        JsonObject jsonObject = JsonParser.parseString((String)json).getAsJsonObject();
        if (jsonObject.get("date") != null) {
            field.setComponent1(jsonObject.get("date").getAsString());
        }
        if (jsonObject.get("time") != null) {
            field.setComponent2(jsonObject.get("time").getAsString());
        }
        if (jsonObject.get("mIR") != null) {
            field.setComponent3(jsonObject.get("mIR").getAsString());
        }
        return field;
    }
}

