/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.SwiftParseUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class Field22S
extends Field
implements Serializable {
    public static final int SRU = 2024;
    private static final long serialVersionUID = 1L;
    public static final String NAME = "22S";
    public static final String F_22S = "22S";
    public static final Integer SIDE_INDICATOR = 1;
    public static final Integer IDENTIFICATION = 2;

    public Field22S() {
        super(2);
    }

    public Field22S(String value) {
        super(value);
    }

    public Field22S(Tag tag) {
        this();
        if (tag == null) {
            throw new IllegalArgumentException("tag cannot be null.");
        }
        if (!StringUtils.equals((CharSequence)tag.getName(), (CharSequence)"22S")) {
            throw new IllegalArgumentException("cannot create field 22S from tag " + tag.getName() + ", tagname must match the name of the field.");
        }
        this.parse(tag.getValue());
    }

    public static Field22S newInstance(Field22S source) {
        Field22S cp = new Field22S();
        cp.setComponents(new ArrayList<String>(source.getComponents()));
        return cp;
    }

    public static Tag tag(String value) {
        return new Tag("22S", value);
    }

    public static Tag emptyTag() {
        return new Tag("22S", "");
    }

    @Override
    public void parse(String value) {
        this.init(2);
        this.setComponent1(SwiftParseUtils.getTokenFirst(value, "/"));
        this.setComponent2(SwiftParseUtils.getTokenSecondLast(value, "/"));
    }

    @Override
    public String getValue() {
        StringBuilder result = new StringBuilder();
        this.append(result, 1);
        result.append("/");
        this.append(result, 2);
        return result.toString();
    }

    @Override
    public String getValueDisplay(int component, Locale locale) {
        if (component < 1 || component > 2) {
            throw new IllegalArgumentException("invalid component number " + component + " for field 22S");
        }
        if (component == 1) {
            return this.getComponent(1);
        }
        return this.getComponent(2);
    }

    @Override
    public String typesPattern() {
        return "SS";
    }

    @Override
    public String parserPattern() {
        return "S/S";
    }

    @Override
    public String validatorPattern() {
        return "1!a/35x";
    }

    @Override
    public boolean isOptional(int component) {
        return false;
    }

    @Override
    public boolean isGeneric() {
        return false;
    }

    @Override
    public int componentsSize() {
        return 2;
    }

    @Override
    public List<String> getComponentLabels() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("Side Indicator");
        result.add("Identification");
        return result;
    }

    @Override
    protected Map<Integer, String> getComponentMap() {
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        result.put(1, "sideIndicator");
        result.put(2, "identification");
        return result;
    }

    @Override
    protected Map<String, Integer> getLabelMap() {
        if (this.labelMap != null && !this.labelMap.isEmpty()) {
            return this.labelMap;
        }
        this.labelMap = new HashMap<String, Integer>();
        this.labelMap.put("sideindicator", 1);
        this.labelMap.put("identification", 2);
        return this.labelMap;
    }

    public String getComponent1() {
        return this.getComponent(1);
    }

    public String getSideIndicator() {
        return this.getComponent1();
    }

    public String getComponent2() {
        return this.getComponent(2);
    }

    public String getIdentification() {
        return this.getComponent2();
    }

    public Field22S setComponent1(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field22S setSideIndicator(String component1) {
        return this.setComponent1(component1);
    }

    public Field22S setComponent2(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field22S setIdentification(String component2) {
        return this.setComponent2(component2);
    }

    @Override
    public String getName() {
        return "22S";
    }

    public static Field22S get(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return null;
        }
        Tag t = block.getTagByName("22S");
        if (t == null) {
            return null;
        }
        return new Field22S(t);
    }

    public static Field22S get(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return null;
        }
        return Field22S.get(msg.getBlock4());
    }

    public static List<Field22S> getAll(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return Collections.emptyList();
        }
        return Field22S.getAll(msg.getBlock4());
    }

    public static List<Field22S> getAll(SwiftTagListBlock block) {
        ArrayList<Field22S> result = new ArrayList<Field22S>();
        if (block == null || block.isEmpty()) {
            return result;
        }
        Tag[] arr = block.getTagsByName("22S");
        if (arr != null) {
            for (Tag f : arr) {
                result.add(new Field22S(f));
            }
        }
        return result;
    }

    public static Field22S fromJson(String json) {
        Field22S field = new Field22S();
        JsonObject jsonObject = JsonParser.parseString((String)json).getAsJsonObject();
        if (jsonObject.get("sideIndicator") != null) {
            field.setComponent1(jsonObject.get("sideIndicator").getAsString());
        }
        if (jsonObject.get("identification") != null) {
            field.setComponent2(jsonObject.get("identification").getAsString());
        }
        return field;
    }
}

