/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.mt.mt4xx;

import com.prowidesoftware.swift.model.MtSwiftMessage;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.Field20;
import com.prowidesoftware.swift.model.field.Field21;
import com.prowidesoftware.swift.model.field.Field32A;
import com.prowidesoftware.swift.model.field.Field32B;
import com.prowidesoftware.swift.model.field.Field32K;
import com.prowidesoftware.swift.model.field.Field72;
import com.prowidesoftware.swift.model.mt.AbstractMT;
import com.prowidesoftware.swift.utils.Lib;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;

public class MT410
extends AbstractMT
implements Serializable {
    public static final int SRU = 2024;
    private static final long serialVersionUID = 1L;
    private static final Logger log = Logger.getLogger(MT410.class.getName());
    public static final String NAME = "410";

    public MT410(SwiftMessage m) {
        super(m);
        this.sanityCheck(m);
    }

    public MT410(MtSwiftMessage m) {
        this(m.message());
    }

    public static MT410 parse(MtSwiftMessage m) {
        if (m == null) {
            return null;
        }
        return new MT410(m);
    }

    public MT410() {
        this("TESTARZZ", "TESTARZZ");
    }

    public MT410(String sender, String receiver) {
        super(410, sender, receiver);
    }

    public MT410(String fin) {
        SwiftMessage parsed;
        if (fin != null && (parsed = MT410.read(fin)) != null) {
            this.m = parsed;
            this.sanityCheck(parsed);
        }
    }

    private void sanityCheck(SwiftMessage param) {
        if (param.isServiceMessage()) {
            log.warning("Creating an MT410 object from FIN content with a Service Message. Check if the MT410 you are intended to read is prepended with and ACK.");
        } else if (!StringUtils.equals((CharSequence)param.getType(), (CharSequence)NAME)) {
            log.warning("Creating an MT410 object from FIN content with message type " + param.getType());
        }
    }

    public static MT410 parse(String fin) {
        if (fin == null) {
            return null;
        }
        return new MT410(fin);
    }

    public MT410(InputStream stream) throws IOException {
        this(Lib.readStream(stream));
    }

    public static MT410 parse(InputStream stream) throws IOException {
        if (stream == null) {
            return null;
        }
        return new MT410(stream);
    }

    public MT410(File file) throws IOException {
        this(Lib.readFile(file));
    }

    public static MT410 parse(File file) throws IOException {
        if (file == null) {
            return null;
        }
        return new MT410(file);
    }

    @Override
    public String getMessageType() {
        return NAME;
    }

    @Override
    public MT410 append(SwiftTagListBlock block) {
        super.append(block);
        return this;
    }

    @Override
    public MT410 append(Tag ... tags) {
        super.append(tags);
        return this;
    }

    @Override
    public MT410 append(Field ... fields) {
        super.append(fields);
        return this;
    }

    public static MT410 fromJson(String json) {
        return (MT410)AbstractMT.fromJson(json);
    }

    public Field72 getField72() {
        Tag t = this.tag("72");
        if (t != null) {
            return new Field72(t.getValue());
        }
        return null;
    }

    public List<Field20> getField20() {
        ArrayList<Field20> result = new ArrayList<Field20>();
        Tag[] tags = this.tags("20");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field20(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field21> getField21() {
        ArrayList<Field21> result = new ArrayList<Field21>();
        Tag[] tags = this.tags("21");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field21(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field32A> getField32A() {
        ArrayList<Field32A> result = new ArrayList<Field32A>();
        Tag[] tags = this.tags("32A");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field32A(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field32B> getField32B() {
        ArrayList<Field32B> result = new ArrayList<Field32B>();
        Tag[] tags = this.tags("32B");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field32B(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field32K> getField32K() {
        ArrayList<Field32K> result = new ArrayList<Field32K>();
        Tag[] tags = this.tags("32K");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field32K(tag.getValue()));
            }
        }
        return result;
    }

    public List<Loop1> getLoop1List() {
        return MT410.getLoop1List(super.getSwiftMessageNotNullOrException().getBlock4());
    }

    public static List<Loop1> getLoop1List(SwiftTagListBlock parentSequence) {
        List<SwiftTagListBlock> blocks;
        if (parentSequence != null && (blocks = parentSequence.getSubBlocksDelimitedWithOptionalTail(Loop1.START, Loop1.END, Loop1.TAIL)) != null && !blocks.isEmpty()) {
            ArrayList<Loop1> result = new ArrayList<Loop1>(blocks.size());
            for (SwiftTagListBlock b : blocks) {
                result.add(new Loop1(b));
            }
            return result;
        }
        return Collections.emptyList();
    }

    public static class Loop1
    extends SwiftTagListBlock {
        private static final long serialVersionUID = 1L;
        public static final String[] START = new String[]{"20"};
        protected static final String[] END = new String[]{"32A", "32B", "32K"};
        protected static final String[] TAIL = new String[0];

        private Loop1() {
            super(new ArrayList<Tag>());
        }

        private Loop1(SwiftTagListBlock content) {
            super(content.getTags());
        }

        public static Loop1 newInstance(Tag ... tags) {
            return Loop1.newInstance(0, 0, tags);
        }

        public static Loop1 newInstance(int start, int end, Tag ... tags) {
            Loop1 result = new Loop1();
            result.append(new Tag(START[start], ""));
            if (tags != null && tags.length > 0) {
                for (Tag t : tags) {
                    result.append(t);
                }
            }
            result.append(new Tag(END[end], ""));
            return result;
        }
    }
}

