/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.SwiftParseUtils;
import com.prowidesoftware.swift.utils.SwiftFormatUtils;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class Field133
extends Field
implements Serializable {
    public static final int SRU = 2024;
    private static final long serialVersionUID = 1L;
    public static final String NAME = "133";
    public static final String F_133 = "133";
    public static final Integer BROADCAST_INDICATOR = 1;
    public static final Integer UNSEQUENCED_BROADCAST = 2;
    public static final Integer BROADCAST_ISSUER = 3;
    public static final Integer BROADCAST_NUMBER = 4;

    public Field133() {
        super(4);
    }

    public Field133(String value) {
        super(value);
    }

    public Field133(Tag tag) {
        this();
        if (tag == null) {
            throw new IllegalArgumentException("tag cannot be null.");
        }
        if (!StringUtils.equals((CharSequence)tag.getName(), (CharSequence)"133")) {
            throw new IllegalArgumentException("cannot create field 133 from tag " + tag.getName() + ", tagname must match the name of the field.");
        }
        this.parse(tag.getValue());
    }

    public static Field133 newInstance(Field133 source) {
        Field133 cp = new Field133();
        cp.setComponents(new ArrayList<String>(source.getComponents()));
        return cp;
    }

    public static Tag tag(String value) {
        return new Tag("133", value);
    }

    public static Tag emptyTag() {
        return new Tag("133", "");
    }

    @Override
    public void parse(String value) {
        this.init(4);
        if (value != null) {
            String toparse = SwiftParseUtils.getAlphaPrefix(value);
            if (toparse != null && !toparse.isEmpty()) {
                this.setComponent1(StringUtils.substring((String)toparse, (int)0, (int)1));
                if (toparse.length() >= 4) {
                    this.setComponent2(StringUtils.substring((String)toparse, (int)1, (int)4));
                    if (toparse.length() > 4) {
                        this.setComponent3(StringUtils.substring((String)toparse, (int)4));
                    }
                } else {
                    this.setComponent2(StringUtils.substring((String)toparse, (int)1));
                }
            }
            this.setComponent4(SwiftParseUtils.getNumericSuffix(value));
        }
    }

    @Override
    public String getValue() {
        StringBuilder result = new StringBuilder();
        result.append(this.joinComponents());
        return result.toString();
    }

    @Override
    public String getValueDisplay(int component, Locale locale) {
        if (component < 1 || component > 4) {
            throw new IllegalArgumentException("invalid component number " + component + " for field 133");
        }
        if (component == 1) {
            return this.getComponent(1);
        }
        if (component == 2) {
            return this.getComponent(2);
        }
        if (component == 3) {
            return this.getComponent(3);
        }
        return this.getComponent(4);
    }

    @Override
    public String typesPattern() {
        return "cSKN";
    }

    @Override
    public String parserPattern() {
        return "c3!S<CC>N";
    }

    @Override
    public String validatorPattern() {
        return "1a3!x<CC>4!n";
    }

    @Override
    public boolean isOptional(int component) {
        return false;
    }

    @Override
    public boolean isGeneric() {
        return false;
    }

    @Override
    public int componentsSize() {
        return 4;
    }

    @Override
    public List<String> getComponentLabels() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("Broadcast Indicator");
        result.add("Unsequenced Broadcast");
        result.add("Broadcast Issuer");
        result.add("Broadcast Number");
        return result;
    }

    @Override
    protected Map<Integer, String> getComponentMap() {
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        result.put(1, "broadcastIndicator");
        result.put(2, "unsequencedBroadcast");
        result.put(3, "broadcastIssuer");
        result.put(4, "broadcastNumber");
        return result;
    }

    @Override
    protected Map<String, Integer> getLabelMap() {
        if (this.labelMap != null && !this.labelMap.isEmpty()) {
            return this.labelMap;
        }
        this.labelMap = new HashMap<String, Integer>();
        this.labelMap.put("broadcastindicator", 1);
        this.labelMap.put("unsequencedbroadcast", 2);
        this.labelMap.put("broadcastissuer", 3);
        this.labelMap.put("broadcastnumber", 4);
        return this.labelMap;
    }

    public String getComponent1() {
        return this.getComponent(1);
    }

    public String getBroadcastIndicator() {
        return this.getComponent1();
    }

    public String getComponent2() {
        return this.getComponent(2);
    }

    public String getUnsequencedBroadcast() {
        return this.getComponent2();
    }

    public String getComponent3() {
        return this.getComponent(3);
    }

    public String getBroadcastIssuer() {
        return this.getComponent3();
    }

    public String getComponent4() {
        return this.getComponent(4);
    }

    public Long getComponent4AsLong() {
        return SwiftFormatUtils.getLong(this.getComponent(4));
    }

    public String getBroadcastNumber() {
        return this.getComponent4();
    }

    public Long getBroadcastNumberAsLong() {
        return this.getComponent4AsLong();
    }

    public Field133 setComponent1(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field133 setBroadcastIndicator(String component1) {
        return this.setComponent1(component1);
    }

    public Field133 setComponent2(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field133 setUnsequencedBroadcast(String component2) {
        return this.setComponent2(component2);
    }

    public Field133 setComponent3(String component3) {
        this.setComponent(3, component3);
        return this;
    }

    public Field133 setBroadcastIssuer(String component3) {
        return this.setComponent3(component3);
    }

    public Field133 setComponent4(String component4) {
        this.setComponent(4, component4);
        return this;
    }

    public Field133 setComponent4(Number component4) {
        if (component4 instanceof Long) {
            this.setComponent(4, SwiftFormatUtils.getLong((Long)component4));
        } else if (component4 instanceof BigInteger || component4 instanceof Integer) {
            this.setComponent(4, SwiftFormatUtils.getLong(component4.longValue()));
        } else if (component4 != null) {
            this.setComponent(4, SwiftFormatUtils.getLong(component4.longValue()));
        } else {
            this.setComponent(4, null);
        }
        return this;
    }

    public Field133 setBroadcastNumber(String component4) {
        return this.setComponent4(component4);
    }

    public Field133 setBroadcastNumber(Number component4) {
        return this.setComponent4(component4);
    }

    @Override
    public String getName() {
        return "133";
    }

    public static Field133 get(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return null;
        }
        Tag t = block.getTagByName("133");
        if (t == null) {
            return null;
        }
        return new Field133(t);
    }

    public static Field133 get(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return null;
        }
        return Field133.get(msg.getBlock4());
    }

    public static List<Field133> getAll(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return Collections.emptyList();
        }
        return Field133.getAll(msg.getBlock4());
    }

    public static List<Field133> getAll(SwiftTagListBlock block) {
        ArrayList<Field133> result = new ArrayList<Field133>();
        if (block == null || block.isEmpty()) {
            return result;
        }
        Tag[] arr = block.getTagsByName("133");
        if (arr != null) {
            for (Tag f : arr) {
                result.add(new Field133(f));
            }
        }
        return result;
    }

    public static Field133 fromJson(String json) {
        Field133 field = new Field133();
        JsonObject jsonObject = JsonParser.parseString((String)json).getAsJsonObject();
        if (jsonObject.get("broadcastIndicator") != null) {
            field.setComponent1(jsonObject.get("broadcastIndicator").getAsString());
        }
        if (jsonObject.get("unsequencedBroadcast") != null) {
            field.setComponent2(jsonObject.get("unsequencedBroadcast").getAsString());
        }
        if (jsonObject.get("broadcastIssuer") != null) {
            field.setComponent3(jsonObject.get("broadcastIssuer").getAsString());
        }
        if (jsonObject.get("broadcastNumber") != null) {
            field.setComponent4(jsonObject.get("broadcastNumber").getAsString());
        }
        return field;
    }
}

