/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.CurrencyContainer;
import com.prowidesoftware.swift.model.field.DateContainer;
import com.prowidesoftware.swift.model.field.DateResolver;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.MonetaryAmountContainer;
import com.prowidesoftware.swift.model.field.MonetaryAmountResolver;
import com.prowidesoftware.swift.model.field.SwiftParseUtils;
import com.prowidesoftware.swift.utils.SwiftFormatUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DateFormat;
import java.text.Format;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Currency;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class Field34A
extends Field
implements Serializable,
MonetaryAmountContainer,
DateContainer {
    public static final int SRU = 2024;
    private static final long serialVersionUID = 1L;
    public static final String NAME = "34A";
    public static final String F_34A = "34A";
    public static final Integer DATE = 1;
    public static final Integer CURRENCY = 2;
    public static final Integer AMOUNT = 3;

    public Field34A() {
        super(3);
    }

    public Field34A(String value) {
        super(value);
    }

    public Field34A(Tag tag) {
        this();
        if (tag == null) {
            throw new IllegalArgumentException("tag cannot be null.");
        }
        if (!StringUtils.equals((CharSequence)tag.getName(), (CharSequence)"34A")) {
            throw new IllegalArgumentException("cannot create field 34A from tag " + tag.getName() + ", tagname must match the name of the field.");
        }
        this.parse(tag.getValue());
    }

    public static Field34A newInstance(Field34A source) {
        Field34A cp = new Field34A();
        cp.setComponents(new ArrayList<String>(source.getComponents()));
        return cp;
    }

    public static Tag tag(String value) {
        return new Tag("34A", value);
    }

    public static Tag emptyTag() {
        return new Tag("34A", "");
    }

    @Override
    public void parse(String value) {
        this.init(3);
        if (value != null) {
            if (value.length() >= 6) {
                this.setComponent1(StringUtils.substring((String)value, (int)0, (int)6));
            }
            String toparse = StringUtils.substring((String)value, (int)6);
            this.setComponent2(SwiftParseUtils.getAlphaPrefix(toparse));
            this.setComponent3(SwiftParseUtils.getNumericSuffix(toparse));
        }
    }

    @Override
    public String getValue() {
        StringBuilder result = new StringBuilder();
        result.append(this.joinComponents());
        return result.toString();
    }

    @Override
    public String getValueDisplay(int component, Locale locale) {
        Format f;
        if (component < 1 || component > 3) {
            throw new IllegalArgumentException("invalid component number " + component + " for field 34A");
        }
        if (component == 1) {
            f = DateFormat.getDateInstance(2, this.notNull(locale));
            Calendar cal = this.getComponent1AsCalendar();
            if (cal != null) {
                return ((DateFormat)f).format(cal.getTime());
            }
        }
        if (component == 2) {
            return this.getComponent(2);
        }
        f = NumberFormat.getNumberInstance(this.notNull(locale));
        ((NumberFormat)f).setMaximumFractionDigits(13);
        BigDecimal n = this.getComponent3AsBigDecimal();
        if (n != null) {
            return f.format(n);
        }
        return null;
    }

    @Override
    public String typesPattern() {
        return "ECI";
    }

    @Override
    public String parserPattern() {
        return "<DATE2>SN";
    }

    @Override
    public String validatorPattern() {
        return "<DATE2><CUR><AMOUNT>15";
    }

    @Override
    public boolean isOptional(int component) {
        return false;
    }

    @Override
    public boolean isGeneric() {
        return false;
    }

    @Override
    public int componentsSize() {
        return 3;
    }

    @Override
    public List<String> getComponentLabels() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("Date");
        result.add("Currency");
        result.add("Amount");
        return result;
    }

    @Override
    protected Map<Integer, String> getComponentMap() {
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        result.put(1, "date");
        result.put(2, "currency");
        result.put(3, "amount");
        return result;
    }

    @Override
    protected Map<String, Integer> getLabelMap() {
        if (this.labelMap != null && !this.labelMap.isEmpty()) {
            return this.labelMap;
        }
        this.labelMap = new HashMap<String, Integer>();
        this.labelMap.put("date", 1);
        this.labelMap.put("currency", 2);
        this.labelMap.put("amount", 3);
        return this.labelMap;
    }

    public String getComponent1() {
        return this.getComponent(1);
    }

    public Calendar getComponent1AsCalendar() {
        return SwiftFormatUtils.getDate2(this.getComponent(1));
    }

    public String getDate() {
        return this.getComponent1();
    }

    public Calendar getDateAsCalendar() {
        return this.getComponent1AsCalendar();
    }

    public String getComponent2() {
        return this.getComponent(2);
    }

    public Currency getComponent2AsCurrency() {
        return SwiftFormatUtils.getCurrency(this.getComponent(2));
    }

    public String getCurrency() {
        return this.getComponent2();
    }

    public Currency getCurrencyAsCurrency() {
        return this.getComponent2AsCurrency();
    }

    public String getComponent3() {
        return this.getComponent(3);
    }

    public BigDecimal getComponent3AsBigDecimal() {
        return SwiftFormatUtils.getBigDecimal(this.getComponent(3));
    }

    public String getAmount() {
        return this.getComponent3();
    }

    public BigDecimal getAmountAsBigDecimal() {
        return this.getComponent3AsBigDecimal();
    }

    public Field34A setComponent1(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field34A setComponent1(Calendar component1) {
        this.setComponent(1, SwiftFormatUtils.getDate2(component1));
        return this;
    }

    public Field34A setDate(String component1) {
        return this.setComponent1(component1);
    }

    public Field34A setDate(Calendar component1) {
        return this.setComponent1(component1);
    }

    public Field34A setComponent2(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field34A setComponent2(Currency component2) {
        this.setComponent(2, SwiftFormatUtils.getCurrency(component2));
        return this;
    }

    public Field34A setCurrency(String component2) {
        return this.setComponent2(component2);
    }

    public Field34A setCurrency(Currency component2) {
        return this.setComponent2(component2);
    }

    public Field34A setComponent3(String component3) {
        this.setComponent(3, component3);
        return this;
    }

    public Field34A setComponent3(Number component3) {
        if (component3 instanceof BigDecimal) {
            this.setComponent(3, SwiftFormatUtils.getBigDecimal((BigDecimal)component3));
        } else if (component3 instanceof BigInteger) {
            this.setComponent(3, SwiftFormatUtils.getBigDecimal(new BigDecimal((BigInteger)component3)));
        } else if (component3 instanceof Long || component3 instanceof Integer) {
            this.setComponent(3, SwiftFormatUtils.getBigDecimal(BigDecimal.valueOf(component3.longValue())));
        } else if (component3 != null) {
            this.setComponent(3, SwiftFormatUtils.getBigDecimal(BigDecimal.valueOf(component3.doubleValue())));
        } else {
            this.setComponent(3, null);
        }
        return this;
    }

    public Field34A setAmount(String component3) {
        return this.setComponent3(component3);
    }

    public Field34A setAmount(Number component3) {
        return this.setComponent3(component3);
    }

    @Override
    public List<String> currencyStrings() {
        return MonetaryAmountResolver.currencyStrings(this);
    }

    @Override
    public List<Currency> currencies() {
        return MonetaryAmountResolver.currencies(this);
    }

    @Override
    public Currency currency() {
        return MonetaryAmountResolver.resolveCurrency(this);
    }

    @Override
    public String currencyString() {
        return MonetaryAmountResolver.resolveCurrencyString(this);
    }

    @Override
    public void initializeCurrencies(String cur) {
        MonetaryAmountResolver.resolveSetCurrency((CurrencyContainer)this, cur);
    }

    @Override
    public void initializeCurrencies(Currency cur) {
        MonetaryAmountResolver.resolveSetCurrency((CurrencyContainer)this, cur);
    }

    public List<BigDecimal> amounts() {
        return MonetaryAmountResolver.amounts(this);
    }

    @Override
    public BigDecimal amount() {
        return MonetaryAmountResolver.amount(this);
    }

    @Override
    public List<Calendar> dates() {
        return DateResolver.dates(this);
    }

    public Calendar date() {
        return DateResolver.date(this);
    }

    @Override
    public String getName() {
        return "34A";
    }

    public static Field34A get(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return null;
        }
        Tag t = block.getTagByName("34A");
        if (t == null) {
            return null;
        }
        return new Field34A(t);
    }

    public static Field34A get(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return null;
        }
        return Field34A.get(msg.getBlock4());
    }

    public static List<Field34A> getAll(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return Collections.emptyList();
        }
        return Field34A.getAll(msg.getBlock4());
    }

    public static List<Field34A> getAll(SwiftTagListBlock block) {
        ArrayList<Field34A> result = new ArrayList<Field34A>();
        if (block == null || block.isEmpty()) {
            return result;
        }
        Tag[] arr = block.getTagsByName("34A");
        if (arr != null) {
            for (Tag f : arr) {
                result.add(new Field34A(f));
            }
        }
        return result;
    }

    public static Field34A fromJson(String json) {
        Field34A field = new Field34A();
        JsonObject jsonObject = JsonParser.parseString((String)json).getAsJsonObject();
        if (jsonObject.get("date") != null) {
            field.setComponent1(jsonObject.get("date").getAsString());
        }
        if (jsonObject.get("currency") != null) {
            field.setComponent2(jsonObject.get("currency").getAsString());
        }
        if (jsonObject.get("amount") != null) {
            field.setComponent3(jsonObject.get("amount").getAsString());
        }
        return field;
    }
}

