/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.mt.mt0xx;

import com.prowidesoftware.swift.model.MtSwiftMessage;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.Field202;
import com.prowidesoftware.swift.model.field.Field203;
import com.prowidesoftware.swift.model.field.Field270;
import com.prowidesoftware.swift.model.field.Field305;
import com.prowidesoftware.swift.model.mt.AbstractMT;
import com.prowidesoftware.swift.utils.Lib;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;

public class MT056
extends AbstractMT
implements Serializable {
    public static final int SRU = 2024;
    private static final long serialVersionUID = 1L;
    private static final Logger log = Logger.getLogger(MT056.class.getName());
    public static final String NAME = "056";

    public MT056(SwiftMessage m) {
        super(m);
        this.sanityCheck(m);
    }

    public MT056(MtSwiftMessage m) {
        this(m.message());
    }

    public static MT056 parse(MtSwiftMessage m) {
        if (m == null) {
            return null;
        }
        return new MT056(m);
    }

    public MT056() {
        this("TESTARZZ", "TESTARZZ");
    }

    public MT056(String sender, String receiver) {
        super(56, sender, receiver);
    }

    public MT056(String fin) {
        SwiftMessage parsed;
        if (fin != null && (parsed = MT056.read(fin)) != null) {
            this.m = parsed;
            this.sanityCheck(parsed);
        }
    }

    private void sanityCheck(SwiftMessage param) {
        if (param.isServiceMessage()) {
            log.warning("Creating an MT056 object from FIN content with a Service Message. Check if the MT056 you are intended to read is prepended with and ACK.");
        } else if (!StringUtils.equals((CharSequence)param.getType(), (CharSequence)NAME)) {
            log.warning("Creating an MT056 object from FIN content with message type " + param.getType());
        }
    }

    public static MT056 parse(String fin) {
        if (fin == null) {
            return null;
        }
        return new MT056(fin);
    }

    public MT056(InputStream stream) throws IOException {
        this(Lib.readStream(stream));
    }

    public static MT056 parse(InputStream stream) throws IOException {
        if (stream == null) {
            return null;
        }
        return new MT056(stream);
    }

    public MT056(File file) throws IOException {
        this(Lib.readFile(file));
    }

    public static MT056 parse(File file) throws IOException {
        if (file == null) {
            return null;
        }
        return new MT056(file);
    }

    @Override
    public String getMessageType() {
        return NAME;
    }

    @Override
    public MT056 append(SwiftTagListBlock block) {
        super.append(block);
        return this;
    }

    @Override
    public MT056 append(Tag ... tags) {
        super.append(tags);
        return this;
    }

    @Override
    public MT056 append(Field ... fields) {
        super.append(fields);
        return this;
    }

    public static MT056 fromJson(String json) {
        return (MT056)AbstractMT.fromJson(json);
    }

    public Field202 getField202() {
        Tag t = this.tag("202");
        if (t != null) {
            return new Field202(t.getValue());
        }
        return null;
    }

    public Field203 getField203() {
        Tag t = this.tag("203");
        if (t != null) {
            return new Field203(t.getValue());
        }
        return null;
    }

    public Field305 getField305() {
        Tag t = this.tag("305");
        if (t != null) {
            return new Field305(t.getValue());
        }
        return null;
    }

    public List<Field270> getField270() {
        ArrayList<Field270> result = new ArrayList<Field270>();
        Tag[] tags = this.tags("270");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field270(tag.getValue()));
            }
        }
        return result;
    }
}

