/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model;

import com.prowidesoftware.swift.model.BbanStructureDTO;
import com.prowidesoftware.swift.model.BbanStructureEntryDTO;
import com.prowidesoftware.swift.model.IBAN;
import com.prowidesoftware.swift.model.IbanValidationResult;
import com.prowidesoftware.swift.model.SwiftCharsetUtils;
import com.prowidesoftware.swift.utils.IsoUtils;

class IbanValidationUtils {
    static final String IBAN_DEFAULT_CHECK_DIGIT = "00";
    private static final int MOD = 97;
    private static final long MAX = 999999999L;
    private static final int MAX_BBAN_LENGTH = 30;

    private IbanValidationUtils() {
        throw new AssertionError();
    }

    static IbanValidationResult validateCountryCode(String iban) {
        if (iban.length() < 2) {
            return IbanValidationResult.MISSING_COUNTRY_CODE;
        }
        String countryCode = IBAN.getCountryCode(iban);
        if (!(countryCode.equals(countryCode.toUpperCase()) && Character.isLetter(countryCode.charAt(0)) && Character.isLetter(countryCode.charAt(1)))) {
            IbanValidationResult result = IbanValidationResult.INVALID_COUNTRY_CODE_CHARSET;
            result.setFound(countryCode);
            return result;
        }
        if (!IsoUtils.getInstance().isValidISOCountry(countryCode)) {
            IbanValidationResult result = IbanValidationResult.INVALID_COUNTRY_CODE;
            result.setFound(countryCode);
            return result;
        }
        return null;
    }

    static IbanValidationResult validateCheckDigitPresence(String iban) {
        if (iban.length() < 4) {
            return IbanValidationResult.MISSING_CHECK_DIGITS;
        }
        String checkDigit = IBAN.getCheckDigits(iban);
        if (!Character.isDigit(checkDigit.charAt(0)) || !Character.isDigit(checkDigit.charAt(1))) {
            IbanValidationResult result = IbanValidationResult.INVALID_CHECK_DIGITS_FORMAT;
            result.setFound(checkDigit);
            return result;
        }
        return null;
    }

    static IbanValidationResult validateBbanPresence(String iban) {
        if (iban.length() <= 4) {
            return IbanValidationResult.MISSING_BBAN;
        }
        return null;
    }

    static IbanValidationResult validateBbanMaxLength(String bban) {
        if (bban.length() > 30) {
            IbanValidationResult result = IbanValidationResult.BBAN_MAX_LENGTH;
            result.setExpectedLength(30);
            result.setFoundLength(bban.length());
            return result;
        }
        return null;
    }

    static IbanValidationResult validateBban(String bban, BbanStructureDTO structure) {
        int expectedBbanLength = IbanValidationUtils.getBbanLengh(structure);
        if (expectedBbanLength != bban.length()) {
            IbanValidationResult result = IbanValidationResult.BBAN_INVALID_LENGTH;
            result.setFound(bban);
            result.setFoundLength(bban.length());
            result.setExpectedLength(expectedBbanLength);
            return result;
        }
        int bbanEntryOffset = 0;
        for (BbanStructureEntryDTO entry : structure.getValidation_rules()) {
            int entryLength = entry.getLength();
            String entryValue = bban.substring(bbanEntryOffset, bbanEntryOffset + entryLength);
            bbanEntryOffset += entryLength;
            IbanValidationResult result = IbanValidationUtils.validateBbanEntryCharacterType(entry, entryValue);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private static int getBbanLengh(BbanStructureDTO bbanStructure) {
        int length = 0;
        for (BbanStructureEntryDTO entry : bbanStructure.getValidation_rules()) {
            length += entry.getLength();
        }
        return length;
    }

    private static IbanValidationResult validateBbanEntryCharacterType(BbanStructureEntryDTO entry, String entryValue) {
        if (SwiftCharsetUtils.is(entryValue, entry.getCharacterType()) != -1) {
            IbanValidationResult result = null;
            switch (entry.getCharacterType()) {
                case a: {
                    result = IbanValidationResult.BBAN_INVALID_UPPER_CASE_LETTERS;
                    break;
                }
                case c: {
                    result = IbanValidationResult.BBAN_INVALID_DIGITS_OR_LETTERS;
                    break;
                }
                case n: {
                    result = IbanValidationResult.BBAN_INVALID_DIGITS;
                    break;
                }
            }
            if (result != null) {
                result.setFound(entryValue);
                result.setBbanEntryType(entry.getEntryType());
                return result;
            }
        }
        return null;
    }

    static IbanValidationResult validateCheckDigit(String iban) {
        if (IbanValidationUtils.calculateMod(iban) != 1) {
            String checkDigit = IBAN.getCheckDigits(iban);
            String expectedCheckDigit = IbanValidationUtils.calculateCheckDigit(iban);
            IbanValidationResult result = IbanValidationResult.INVALID_CHECK_DIGITS;
            result.setExpectedCheckDigit(expectedCheckDigit);
            result.setFound(checkDigit);
            return result;
        }
        return null;
    }

    static IbanValidationResult validateCharacters(String iban) {
        for (int i = 0; i < iban.length(); ++i) {
            int numericValue = Character.getNumericValue(iban.charAt(i));
            if (numericValue >= 0 && numericValue <= 35) continue;
            IbanValidationResult result = IbanValidationResult.INVALID_CHARACTERS;
            result.setFound(String.valueOf(iban.charAt(i)));
            return result;
        }
        return null;
    }

    private static String calculateCheckDigit(String iban) {
        String reformattedIban = IbanValidationUtils.replaceCheckDigit(iban, IBAN_DEFAULT_CHECK_DIGIT);
        int modResult = IbanValidationUtils.calculateMod(reformattedIban);
        int checkDigitIntValue = 98 - modResult;
        String checkDigit = Integer.toString(checkDigitIntValue);
        return checkDigitIntValue > 9 ? checkDigit : "0" + checkDigit;
    }

    private static String replaceCheckDigit(String iban, String checkDigit) {
        return IBAN.getCountryCode(iban) + checkDigit + IBAN.getBban(iban);
    }

    private static int calculateMod(String iban) {
        String reformattedIban = IBAN.getBban(iban) + IBAN.getCountryCode(iban) + IBAN.getCheckDigits(iban);
        long total = 0L;
        for (int i = 0; i < reformattedIban.length(); ++i) {
            int numericValue = Character.getNumericValue(reformattedIban.charAt(i));
            total = (numericValue > 9 ? total * 100L : total * 10L) + (long)numericValue;
            if (total <= 999999999L) continue;
            total %= 97L;
        }
        return (int)(total % 97L);
    }
}

