/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model;

import com.prowidesoftware.swift.model.BIC;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class LogicalTerminalAddress
extends BIC {
    private Character lTIdentifier = null;

    public LogicalTerminalAddress(String code) {
        if (code != null) {
            this.setInstitution(StringUtils.trimToNull((String)StringUtils.substring((String)code, (int)0, (int)4)));
            this.setCountry(StringUtils.trimToNull((String)StringUtils.substring((String)code, (int)4, (int)6)));
            this.setLocation(StringUtils.trimToNull((String)StringUtils.substring((String)code, (int)6, (int)8)));
            if (code.length() > 8) {
                if (code.length() == 9) {
                    this.lTIdentifier = Character.valueOf(code.charAt(8));
                } else if (code.length() >= 12) {
                    this.lTIdentifier = Character.valueOf(code.charAt(8));
                    this.branch = StringUtils.trimToNull((String)StringUtils.substring((String)code, (int)9));
                } else {
                    this.branch = StringUtils.trimToNull((String)StringUtils.substring((String)code, (int)8));
                }
            }
        }
    }

    public Character getLTIdentifier() {
        return this.lTIdentifier;
    }

    public void setLTIdentifier(Character _lTIdentifier) {
        this.lTIdentifier = _lTIdentifier;
    }

    public String getSenderLogicalTerminalAddress() {
        char lt = Character.toUpperCase(this.lTIdentifier == null ? (char)'X' : this.lTIdentifier.charValue());
        if (this.getBic8() != null) {
            return this.getBic8() + lt + this.getBranchOrDefault();
        }
        return null;
    }

    public String getReceiverLogicalTerminalAddress() {
        if (this.getBic8() != null) {
            return this.getBic8() + "X" + this.getBranchOrDefault();
        }
        return null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        LogicalTerminalAddress that = (LogicalTerminalAddress)o;
        return Objects.equals(this.lTIdentifier, that.lTIdentifier);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.lTIdentifier);
    }
}

