/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.DateContainer;
import com.prowidesoftware.swift.model.field.DateResolver;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.utils.SwiftFormatUtils;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class Field271
extends Field
implements Serializable,
DateContainer {
    public static final int SRU = 2025;
    private static final long serialVersionUID = 1L;
    public static final String NAME = "271";
    public static final String F_271 = "271";
    public static final Integer TIMESTAMP = 1;
    public static final Integer LOGOUT_BLOCK = 2;

    public Field271() {
        super(2);
    }

    public Field271(String value) {
        super(value);
    }

    public Field271(Tag tag) {
        this();
        if (tag == null) {
            throw new IllegalArgumentException("tag cannot be null.");
        }
        if (!StringUtils.equals((CharSequence)tag.getName(), (CharSequence)"271")) {
            throw new IllegalArgumentException("cannot create field 271 from tag " + tag.getName() + ", tagname must match the name of the field.");
        }
        this.parse(tag.getValue());
    }

    public static Field271 newInstance(Field271 source) {
        Field271 cp = new Field271();
        cp.setComponents(new ArrayList<String>(source.getComponents()));
        return cp;
    }

    public static Tag tag(String value) {
        return new Tag("271", value);
    }

    public static Tag emptyTag() {
        return new Tag("271", "");
    }

    @Override
    public void parse(String value) {
        this.init(2);
        if (value != null) {
            if (value.length() >= 10) {
                this.setComponent1(StringUtils.substring((String)value, (int)0, (int)10));
            }
            if (value.length() > 10) {
                this.setComponent2(StringUtils.substring((String)value, (int)10));
            }
        }
    }

    @Override
    public String getValue() {
        StringBuilder result = new StringBuilder();
        result.append(this.joinComponents());
        return result.toString();
    }

    @Override
    public String getValueDisplay(int component, Locale locale) {
        if (component < 1 || component > 2) {
            throw new IllegalArgumentException("invalid component number " + component + " for field 271");
        }
        if (component == 1) {
            DateFormat df = DateFormat.getDateInstance(2, this.notNull(locale));
            SimpleDateFormat tf = new SimpleDateFormat("HH:mm", this.notNull(locale));
            Calendar cal = this.getComponent1AsCalendar();
            if (cal != null) {
                return df.format(cal.getTime()) + " " + tf.format(cal.getTime());
            }
        }
        return this.getComponent(2);
    }

    @Override
    public String typesPattern() {
        return "US";
    }

    @Override
    public String parserPattern() {
        return "10!NS";
    }

    @Override
    public String validatorPattern() {
        return "<YYMMDDHHMM><?>";
    }

    @Override
    public boolean isOptional(int component) {
        return false;
    }

    @Override
    public boolean isGeneric() {
        return false;
    }

    @Override
    public int componentsSize() {
        return 2;
    }

    @Override
    public List<String> getComponentLabels() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("Timestamp");
        result.add("Logout Block");
        return result;
    }

    @Override
    protected Map<Integer, String> getComponentMap() {
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        result.put(1, "timestamp");
        result.put(2, "logoutBlock");
        return result;
    }

    @Override
    protected Map<String, Integer> getLabelMap() {
        if (this.labelMap != null && !this.labelMap.isEmpty()) {
            return this.labelMap;
        }
        this.labelMap = new HashMap<String, Integer>();
        this.labelMap.put("timestamp", 1);
        this.labelMap.put("logoutblock", 2);
        return this.labelMap;
    }

    public String getComponent1() {
        return this.getComponent(1);
    }

    public Calendar getComponent1AsCalendar() {
        return SwiftFormatUtils.getDateTimeShortYear(this.getComponent(1));
    }

    public String getTimestamp() {
        return this.getComponent1();
    }

    public Calendar getTimestampAsCalendar() {
        return this.getComponent1AsCalendar();
    }

    public String getComponent2() {
        return this.getComponent(2);
    }

    public String getLogoutBlock() {
        return this.getComponent2();
    }

    public Field271 setComponent1(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field271 setComponent1(Calendar component1) {
        this.setComponent(1, SwiftFormatUtils.getDateTimeShortYear(component1));
        return this;
    }

    public Field271 setTimestamp(String component1) {
        return this.setComponent1(component1);
    }

    public Field271 setTimestamp(Calendar component1) {
        return this.setComponent1(component1);
    }

    public Field271 setComponent2(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field271 setLogoutBlock(String component2) {
        return this.setComponent2(component2);
    }

    @Override
    public List<Calendar> dates() {
        return DateResolver.dates(this);
    }

    public Calendar date() {
        return DateResolver.date(this);
    }

    @Override
    public String getName() {
        return "271";
    }

    public static Field271 get(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return null;
        }
        Tag t = block.getTagByName("271");
        if (t == null) {
            return null;
        }
        return new Field271(t);
    }

    public static Field271 get(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return null;
        }
        return Field271.get(msg.getBlock4());
    }

    public static List<Field271> getAll(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return Collections.emptyList();
        }
        return Field271.getAll(msg.getBlock4());
    }

    public static List<Field271> getAll(SwiftTagListBlock block) {
        ArrayList<Field271> result = new ArrayList<Field271>();
        if (block == null || block.isEmpty()) {
            return result;
        }
        Tag[] arr = block.getTagsByName("271");
        if (arr != null) {
            for (Tag f : arr) {
                result.add(new Field271(f));
            }
        }
        return result;
    }

    public static Field271 fromJson(String json) {
        Field271 field = new Field271();
        JsonObject jsonObject = JsonParser.parseString((String)json).getAsJsonObject();
        if (jsonObject.get("timestamp") != null) {
            field.setComponent1(jsonObject.get("timestamp").getAsString());
        }
        if (jsonObject.get("logoutBlock") != null) {
            field.setComponent2(jsonObject.get("logoutBlock").getAsString());
        }
        return field;
    }
}

