/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.mt.mt0xx;

import com.prowidesoftware.swift.model.MtSwiftMessage;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.Field173;
import com.prowidesoftware.swift.model.mt.AbstractMT;
import com.prowidesoftware.swift.utils.Lib;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;

public class MT008
extends AbstractMT
implements Serializable {
    public static final int SRU = 2025;
    private static final long serialVersionUID = 1L;
    private static final Logger log = Logger.getLogger(MT008.class.getName());
    public static final String NAME = "008";

    public MT008(SwiftMessage m) {
        super(m);
        this.sanityCheck(m);
    }

    public MT008(MtSwiftMessage m) {
        this(m.message());
    }

    public static MT008 parse(MtSwiftMessage m) {
        if (m == null) {
            return null;
        }
        return new MT008(m);
    }

    public MT008() {
        this("TESTARZZ", "TESTARZZ");
    }

    public MT008(String sender, String receiver) {
        super(8, sender, receiver);
    }

    public MT008(String fin) {
        SwiftMessage parsed;
        if (fin != null && (parsed = MT008.read(fin)) != null) {
            this.m = parsed;
            this.sanityCheck(parsed);
        }
    }

    private void sanityCheck(SwiftMessage param) {
        if (param.isServiceMessage()) {
            log.warning("Creating an MT008 object from FIN content with a Service Message. Check if the MT008 you are intended to read is prepended with and ACK.");
        } else if (!StringUtils.equals((CharSequence)param.getType(), (CharSequence)NAME)) {
            log.warning("Creating an MT008 object from FIN content with message type " + param.getType());
        }
    }

    public static MT008 parse(String fin) {
        if (fin == null) {
            return null;
        }
        return new MT008(fin);
    }

    public MT008(InputStream stream) throws IOException {
        this(Lib.readStream(stream));
    }

    public static MT008 parse(InputStream stream) throws IOException {
        if (stream == null) {
            return null;
        }
        return new MT008(stream);
    }

    public MT008(File file) throws IOException {
        this(Lib.readFile(file));
    }

    public static MT008 parse(File file) throws IOException {
        if (file == null) {
            return null;
        }
        return new MT008(file);
    }

    @Override
    public String getMessageType() {
        return NAME;
    }

    @Override
    public MT008 append(SwiftTagListBlock block) {
        super.append(block);
        return this;
    }

    @Override
    public MT008 append(Tag ... tags) {
        super.append(tags);
        return this;
    }

    @Override
    public MT008 append(Field ... fields) {
        super.append(fields);
        return this;
    }

    public static MT008 fromJson(String json) {
        return (MT008)AbstractMT.fromJson(json);
    }

    public Field173 getField173() {
        Tag t = this.tag("173");
        if (t != null) {
            return new Field173(t.getValue());
        }
        return null;
    }
}

