/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.mt.mt0xx;

import com.prowidesoftware.swift.model.MtSwiftMessage;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.Field120;
import com.prowidesoftware.swift.model.field.Field122;
import com.prowidesoftware.swift.model.field.Field123;
import com.prowidesoftware.swift.model.field.Field124;
import com.prowidesoftware.swift.model.field.Field125;
import com.prowidesoftware.swift.model.field.Field126;
import com.prowidesoftware.swift.model.mt.AbstractMT;
import com.prowidesoftware.swift.utils.Lib;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;

public class MT073
extends AbstractMT
implements Serializable {
    public static final int SRU = 2025;
    private static final long serialVersionUID = 1L;
    private static final Logger log = Logger.getLogger(MT073.class.getName());
    public static final String NAME = "073";

    public MT073(SwiftMessage m) {
        super(m);
        this.sanityCheck(m);
    }

    public MT073(MtSwiftMessage m) {
        this(m.message());
    }

    public static MT073 parse(MtSwiftMessage m) {
        if (m == null) {
            return null;
        }
        return new MT073(m);
    }

    public MT073() {
        this("TESTARZZ", "TESTARZZ");
    }

    public MT073(String sender, String receiver) {
        super(73, sender, receiver);
    }

    public MT073(String fin) {
        SwiftMessage parsed;
        if (fin != null && (parsed = MT073.read(fin)) != null) {
            this.m = parsed;
            this.sanityCheck(parsed);
        }
    }

    private void sanityCheck(SwiftMessage param) {
        if (param.isServiceMessage()) {
            log.warning("Creating an MT073 object from FIN content with a Service Message. Check if the MT073 you are intended to read is prepended with and ACK.");
        } else if (!StringUtils.equals((CharSequence)param.getType(), (CharSequence)NAME)) {
            log.warning("Creating an MT073 object from FIN content with message type " + param.getType());
        }
    }

    public static MT073 parse(String fin) {
        if (fin == null) {
            return null;
        }
        return new MT073(fin);
    }

    public MT073(InputStream stream) throws IOException {
        this(Lib.readStream(stream));
    }

    public static MT073 parse(InputStream stream) throws IOException {
        if (stream == null) {
            return null;
        }
        return new MT073(stream);
    }

    public MT073(File file) throws IOException {
        this(Lib.readFile(file));
    }

    public static MT073 parse(File file) throws IOException {
        if (file == null) {
            return null;
        }
        return new MT073(file);
    }

    @Override
    public String getMessageType() {
        return NAME;
    }

    @Override
    public MT073 append(SwiftTagListBlock block) {
        super.append(block);
        return this;
    }

    @Override
    public MT073 append(Tag ... tags) {
        super.append(tags);
        return this;
    }

    @Override
    public MT073 append(Field ... fields) {
        super.append(fields);
        return this;
    }

    public static MT073 fromJson(String json) {
        return (MT073)AbstractMT.fromJson(json);
    }

    public Field123 getField123() {
        Tag t = this.tag("123");
        if (t != null) {
            return new Field123(t.getValue());
        }
        return null;
    }

    public List<Field120> getField120() {
        ArrayList<Field120> result = new ArrayList<Field120>();
        Tag[] tags = this.tags("120");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field120(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field124> getField124() {
        ArrayList<Field124> result = new ArrayList<Field124>();
        Tag[] tags = this.tags("124");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field124(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field126> getField126() {
        ArrayList<Field126> result = new ArrayList<Field126>();
        Tag[] tags = this.tags("126");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field126(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field122> getField122() {
        ArrayList<Field122> result = new ArrayList<Field122>();
        Tag[] tags = this.tags("122");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field122(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field125> getField125() {
        ArrayList<Field125> result = new ArrayList<Field125>();
        Tag[] tags = this.tags("125");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field125(tag.getValue()));
            }
        }
        return result;
    }
}

