/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.GenericField;
import com.prowidesoftware.swift.model.field.SwiftParseUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class Field94S
extends Field
implements Serializable,
GenericField {
    public static final int SRU = 2025;
    private static final long serialVersionUID = 1L;
    public static final String NAME = "94S";
    public static final String F_94S = "94S";
    public static final Integer QUALIFIER = 1;
    public static final Integer DATA_SOURCE_SCHEME = 2;
    public static final Integer PLACE_CODE = 3;
    public static final Integer NARRATIVE = 4;
    public static final Integer CONDITIONAL_QUALIFIER = 3;

    public Field94S() {
        super(4);
    }

    public Field94S(String value) {
        super(value);
    }

    public Field94S(Tag tag) {
        this();
        if (tag == null) {
            throw new IllegalArgumentException("tag cannot be null.");
        }
        if (!StringUtils.equals((CharSequence)tag.getName(), (CharSequence)"94S")) {
            throw new IllegalArgumentException("cannot create field 94S from tag " + tag.getName() + ", tagname must match the name of the field.");
        }
        this.parse(tag.getValue());
    }

    public static Field94S newInstance(Field94S source) {
        Field94S cp = new Field94S();
        cp.setComponents(new ArrayList<String>(source.getComponents()));
        return cp;
    }

    public static Tag tag(String value) {
        return new Tag("94S", value);
    }

    public static Tag emptyTag() {
        return new Tag("94S", "");
    }

    @Override
    public void parse(String value) {
        this.init(4);
        this.setComponent1(SwiftParseUtils.getTokenFirst(value, ":", "/"));
        this.setComponent2(SwiftParseUtils.getTokenSecond(value, "/"));
        this.setComponent3(SwiftParseUtils.getTokenThird(value, "/"));
        this.setComponent4(SwiftParseUtils.getTokenForthLast(value, "/"));
    }

    @Override
    public String getValue() {
        StringBuilder result = new StringBuilder();
        result.append(":");
        this.append(result, 1);
        result.append("/");
        this.append(result, 2);
        result.append("/");
        this.append(result, 3);
        if (this.getComponent4() != null) {
            result.append("/").append(this.getComponent4());
        }
        return result.toString();
    }

    @Override
    public String getValueDisplay(int component, Locale locale) {
        if (component < 1 || component > 4) {
            throw new IllegalArgumentException("invalid component number " + component + " for field 94S");
        }
        if (component == 1) {
            return this.getComponent(1);
        }
        if (component == 2) {
            return this.getComponent(2);
        }
        if (component == 3) {
            return this.getComponent(3);
        }
        return this.getComponent(4);
    }

    @Override
    public String typesPattern() {
        return "SSSS";
    }

    @Override
    public String parserPattern() {
        return ":S/[S]/S[/S]";
    }

    @Override
    public String validatorPattern() {
        return ":4!c/[8c]/4!c[/140x]";
    }

    @Override
    public boolean isOptional(int component) {
        if (component == 2) {
            return true;
        }
        return component == 4;
    }

    @Override
    public boolean isGeneric() {
        return true;
    }

    @Override
    public int componentsSize() {
        return 4;
    }

    @Override
    public List<String> getComponentLabels() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("Qualifier");
        result.add("Data Source Scheme");
        result.add("Place Code");
        result.add("Narrative");
        return result;
    }

    @Override
    protected Map<Integer, String> getComponentMap() {
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        result.put(1, "qualifier");
        result.put(2, "dataSourceScheme");
        result.put(3, "placeCode");
        result.put(4, "narrative");
        return result;
    }

    @Override
    protected Map<String, Integer> getLabelMap() {
        if (this.labelMap != null && !this.labelMap.isEmpty()) {
            return this.labelMap;
        }
        this.labelMap = new HashMap<String, Integer>();
        this.labelMap.put("qualifier", 1);
        this.labelMap.put("datasourcescheme", 2);
        this.labelMap.put("placecode", 3);
        this.labelMap.put("narrative", 4);
        return this.labelMap;
    }

    public String getComponent1() {
        return this.getComponent(1);
    }

    public String getQualifier() {
        return this.getComponent1();
    }

    public String getComponent2() {
        return this.getComponent(2);
    }

    public String getDataSourceScheme() {
        return this.getComponent2();
    }

    public String getComponent3() {
        return this.getComponent(3);
    }

    public String getPlaceCode() {
        return this.getComponent3();
    }

    public String getComponent4() {
        return this.getComponent(4);
    }

    public String getNarrative() {
        return this.getComponent4();
    }

    public Field94S setComponent1(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field94S setQualifier(String component1) {
        return this.setComponent1(component1);
    }

    public Field94S setComponent2(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field94S setDataSourceScheme(String component2) {
        return this.setComponent2(component2);
    }

    public Field94S setComponent3(String component3) {
        this.setComponent(3, component3);
        return this;
    }

    public Field94S setPlaceCode(String component3) {
        return this.setComponent3(component3);
    }

    public Field94S setComponent4(String component4) {
        this.setComponent(4, component4);
        return this;
    }

    public Field94S setNarrative(String component4) {
        return this.setComponent4(component4);
    }

    @Override
    public String getDSS() {
        return this.getComponent2();
    }

    @Override
    public boolean isDSSPresent() {
        return this.getComponent2() != null;
    }

    @Override
    public String getConditionalQualifier() {
        return this.getComponent(CONDITIONAL_QUALIFIER);
    }

    @Override
    public String getName() {
        return "94S";
    }

    public static Field94S get(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return null;
        }
        Tag t = block.getTagByName("94S");
        if (t == null) {
            return null;
        }
        return new Field94S(t);
    }

    public static Field94S get(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return null;
        }
        return Field94S.get(msg.getBlock4());
    }

    public static List<Field94S> getAll(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return Collections.emptyList();
        }
        return Field94S.getAll(msg.getBlock4());
    }

    public static List<Field94S> getAll(SwiftTagListBlock block) {
        ArrayList<Field94S> result = new ArrayList<Field94S>();
        if (block == null || block.isEmpty()) {
            return result;
        }
        Tag[] arr = block.getTagsByName("94S");
        if (arr != null) {
            for (Tag f : arr) {
                result.add(new Field94S(f));
            }
        }
        return result;
    }

    public static Field94S fromJson(String json) {
        Field94S field = new Field94S();
        JsonObject jsonObject = JsonParser.parseString((String)json).getAsJsonObject();
        if (jsonObject.get("qualifier") != null) {
            field.setComponent1(jsonObject.get("qualifier").getAsString());
        }
        if (jsonObject.get("dataSourceScheme") != null) {
            field.setComponent2(jsonObject.get("dataSourceScheme").getAsString());
        }
        if (jsonObject.get("placeCode") != null) {
            field.setComponent3(jsonObject.get("placeCode").getAsString());
        }
        if (jsonObject.get("narrative") != null) {
            field.setComponent4(jsonObject.get("narrative").getAsString());
        }
        return field;
    }
}

