/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.javadoc;

import com.puppycrawl.tools.checkstyle.checks.javadoc.HtmlTag;
import java.util.LinkedList;
import java.util.List;

class TagParser {
    private final List<HtmlTag> tags = new LinkedList<HtmlTag>();

    TagParser(String[] text, int lineNo) {
        this.parseTags(text, lineNo);
    }

    public HtmlTag nextTag() {
        return this.tags.remove(0);
    }

    public boolean hasNextTag() {
        return !this.tags.isEmpty();
    }

    private void add(HtmlTag tag) {
        this.tags.add(tag);
    }

    private void parseTags(String[] text, int lineNo) {
        int nLines = text.length;
        Point position = new Point(0, 0);
        while (position.getLineNo() < nLines) {
            position = TagParser.isCommentTag(text, position) ? TagParser.skipHtmlComment(text, position) : (TagParser.isTag(text, position) ? this.parseTag(text, lineNo, nLines, position) : TagParser.getNextPoint(text, position));
            position = TagParser.findChar(text, '<', position);
        }
    }

    private Point parseTag(String[] text, int lineNo, int nLines, Point position) {
        Point endTag = TagParser.findChar(text, '>', position);
        boolean incompleteTag = endTag.getLineNo() >= nLines;
        String tagId = TagParser.getTagId(text, position);
        boolean closedTag = endTag.getLineNo() < nLines && text[endTag.getLineNo()].charAt(endTag.getColumnNo() - 1) == '/';
        this.add(new HtmlTag(tagId, position.getLineNo() + lineNo, position.getColumnNo(), closedTag, incompleteTag, text[position.getLineNo()]));
        return endTag;
    }

    private static boolean isTag(String[] javadocText, Point pos) {
        String text;
        int column = pos.getColumnNo() + 1;
        return column >= (text = javadocText[pos.getLineNo()]).length() || Character.isJavaIdentifierStart(text.charAt(column)) || text.charAt(column) == '/';
    }

    private static String getTagId(String[] javadocText, Point tagStart) {
        String text;
        String tagId = "";
        int column = tagStart.getColumnNo() + 1;
        if (column < (text = javadocText[tagStart.getLineNo()]).length()) {
            int position;
            if (text.charAt(column) == '/') {
                ++column;
            }
            text = text.substring(column);
            for (position = 0; position < text.length() && Character.isJavaIdentifierPart(text.charAt(position)); ++position) {
            }
            tagId = text.substring(0, position);
        }
        return tagId;
    }

    private static boolean isCommentTag(String[] text, Point pos) {
        return text[pos.getLineNo()].startsWith("<!--", pos.getColumnNo());
    }

    private static Point skipHtmlComment(String[] text, Point fromPoint) {
        Point toPoint = fromPoint;
        while (toPoint.getLineNo() < text.length && !text[toPoint.getLineNo()].substring(0, toPoint.getColumnNo() + 1).endsWith("-->")) {
            toPoint = TagParser.findChar(text, '>', TagParser.getNextPoint(text, toPoint));
        }
        return toPoint;
    }

    private static Point findChar(String[] text, char character, Point from) {
        Point curr = new Point(from.getLineNo(), from.getColumnNo());
        while (curr.getLineNo() < text.length && text[curr.getLineNo()].charAt(curr.getColumnNo()) != character) {
            curr = TagParser.getNextPoint(text, curr);
        }
        return curr;
    }

    private static Point getNextPoint(String[] text, Point from) {
        int line;
        int column = from.getColumnNo() + 1;
        for (line = from.getLineNo(); line < text.length && column >= text[line].length(); ++line) {
            column = 0;
        }
        return new Point(line, column);
    }

    private static final class Point {
        private final int lineNo;
        private final int columnNo;

        private Point(int lineNo, int columnNo) {
            this.lineNo = lineNo;
            this.columnNo = columnNo;
        }

        public int getLineNo() {
            return this.lineNo;
        }

        public int getColumnNo() {
            return this.columnNo;
        }
    }
}

