/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.coding;

import com.puppycrawl.tools.checkstyle.StatelessCheck;
import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.utils.TokenUtil;
import java.util.HashMap;

@StatelessCheck
public class OverloadMethodsDeclarationOrderCheck
extends AbstractCheck {
    public static final String MSG_KEY = "overload.methods.declaration";

    @Override
    public int[] getDefaultTokens() {
        return this.getRequiredTokens();
    }

    @Override
    public int[] getAcceptableTokens() {
        return this.getRequiredTokens();
    }

    @Override
    public int[] getRequiredTokens() {
        return new int[]{6};
    }

    @Override
    public void visitToken(DetailAST ast) {
        int parentType = ast.getParent().getType();
        int[] tokenTypes = new int[]{14, 154, 15, 136, 199};
        if (TokenUtil.isOfType(parentType, tokenTypes)) {
            this.checkOverloadMethodsGrouping(ast);
        }
    }

    private void checkOverloadMethodsGrouping(DetailAST objectBlock) {
        boolean allowedDistance = true;
        HashMap<String, Integer> methodIndexMap = new HashMap<String, Integer>();
        HashMap<String, Integer> methodLineNumberMap = new HashMap<String, Integer>();
        int currentIndex = 0;
        for (DetailAST currentToken = objectBlock.getFirstChild(); currentToken != null; currentToken = currentToken.getNextSibling()) {
            boolean isMethod;
            if (currentToken.getType() != 9) continue;
            String methodName = currentToken.findFirstToken(58).getText();
            Integer previousIndex = (Integer)methodIndexMap.get(methodName);
            DetailAST previousSibling = currentToken.getPreviousSibling();
            boolean bl = isMethod = previousSibling.getType() == 9;
            if (!(previousIndex == null || isMethod && ++currentIndex - previousIndex <= 1)) {
                int previousLineWithOverloadMethod = (Integer)methodLineNumberMap.get(methodName);
                this.log(currentToken, MSG_KEY, previousLineWithOverloadMethod);
            }
            methodIndexMap.put(methodName, currentIndex);
            methodLineNumberMap.put(methodName, currentToken.getLineNo());
        }
    }
}

