/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.meta;

import com.puppycrawl.tools.checkstyle.FileStatefulCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.DetailNode;
import com.puppycrawl.tools.checkstyle.checks.javadoc.AbstractJavadocCheck;
import com.puppycrawl.tools.checkstyle.meta.MetadataGenerationException;
import com.puppycrawl.tools.checkstyle.meta.ModuleDetails;
import com.puppycrawl.tools.checkstyle.meta.ModulePropertyDetails;
import com.puppycrawl.tools.checkstyle.meta.ModuleType;
import com.puppycrawl.tools.checkstyle.meta.XmlMetaWriter;
import com.puppycrawl.tools.checkstyle.utils.TokenUtil;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;

@FileStatefulCheck
public class JavadocMetadataScraper
extends AbstractJavadocCheck {
    public static final String MSG_DESC_MISSING = "javadocmetadatascraper.description.missing";
    private static final Map<String, ModuleDetails> MODULE_DETAILS_STORE = new HashMap<String, ModuleDetails>();
    private static final Pattern PROPERTY_TAG = Pattern.compile("\\s*Property\\s*");
    private static final Pattern TYPE_TAG = Pattern.compile("^ Type is\\s.*");
    private static final Pattern VALIDATION_TYPE_TAG = Pattern.compile("\\s.*Validation type is\\s.*");
    private static final Pattern DEFAULT_VALUE_TAG = Pattern.compile("^ Default value is:*.*");
    private static final Pattern EXAMPLES_TAG = Pattern.compile("\\s*To configure the (default )?check.*");
    private static final Pattern PARENT_TAG = Pattern.compile("\\s*Parent is\\s*");
    private static final Pattern VIOLATION_MESSAGES_TAG = Pattern.compile("\\s*Violation Message Keys:\\s*");
    private static final Pattern TOKEN_TEXT_PATTERN = Pattern.compile("([A-Z_]{2,})+");
    private static final Pattern DESC_CLEAN = Pattern.compile("-\\s");
    private static final Pattern FILE_SEPARATOR_PATTERN = Pattern.compile(Pattern.quote(System.getProperty("file.separator")));
    private static final Pattern QUOTE_PATTERN = Pattern.compile("\"");
    private static final String JAVA_FILE_EXTENSION = ".java";
    private static final Set<String> PROPERTIES_TO_NOT_WRITE = Set.of("null", "the charset property of the parent <a href=https://checkstyle.org/config.html#Checker>Checker</a> module");
    private static final String PROP_TYPE_MISSING = "Type for property '%s' is missing";
    private static final String PROP_DEFAULT_VALUE_MISSING = "Default value for property '%s' is missing";
    private ModuleDetails moduleDetails;
    private boolean scrapingViolationMessageList;
    private boolean toScan;
    private DetailNode rootNode;
    private int propertySectionStartIdx;
    private int exampleSectionStartIdx;
    private int parentSectionStartIdx;
    private boolean writeXmlOutput = true;

    public final void setWriteXmlOutput(boolean writeXmlOutput) {
        this.writeXmlOutput = writeXmlOutput;
    }

    @Override
    public int[] getDefaultJavadocTokens() {
        return new int[]{10000, 10008, 10011, 16};
    }

    @Override
    public int[] getRequiredJavadocTokens() {
        return this.getAcceptableJavadocTokens();
    }

    @Override
    public void beginJavadocTree(DetailNode rootAst) {
        if (this.isTopLevelClassJavadoc()) {
            this.moduleDetails = new ModuleDetails();
            this.toScan = false;
            this.scrapingViolationMessageList = false;
            this.propertySectionStartIdx = -1;
            this.exampleSectionStartIdx = -1;
            this.parentSectionStartIdx = -1;
            String moduleName = this.getModuleSimpleName();
            String checkModuleExtension = "Check";
            if (moduleName.endsWith("Check")) {
                moduleName = moduleName.substring(0, moduleName.length() - "Check".length());
            }
            this.moduleDetails.setName(moduleName);
            this.moduleDetails.setFullQualifiedName(JavadocMetadataScraper.getPackageName(this.getFilePath()));
            this.moduleDetails.setModuleType(this.getModuleType());
        }
    }

    @Override
    public void visitJavadocToken(DetailNode ast) {
        if (this.toScan) {
            this.scrapeContent(ast);
        }
        if (ast.getType() == 10000) {
            DetailAST parent = JavadocMetadataScraper.getParent(this.getBlockCommentAst());
            if (parent.getType() == 14) {
                this.rootNode = ast;
                this.toScan = true;
            }
        } else if (ast.getType() == 16) {
            this.toScan = false;
        }
    }

    @Override
    public void finishJavadocTree(DetailNode rootAst) {
        this.moduleDetails.setDescription(this.getDescriptionText());
        if (this.isTopLevelClassJavadoc()) {
            if (this.moduleDetails.getDescription().isEmpty()) {
                String fullQualifiedName = this.moduleDetails.getFullQualifiedName();
                this.log(rootAst.getLineNumber(), MSG_DESC_MISSING, fullQualifiedName.substring(fullQualifiedName.lastIndexOf(46) + 1));
            } else if (this.writeXmlOutput) {
                try {
                    XmlMetaWriter.write(this.moduleDetails);
                }
                catch (ParserConfigurationException | TransformerException ex) {
                    throw new IllegalStateException("Failed to write metadata into XML file for module: " + this.getModuleSimpleName(), ex);
                }
            }
            if (!this.writeXmlOutput) {
                MODULE_DETAILS_STORE.put(this.moduleDetails.getFullQualifiedName(), this.moduleDetails);
            }
        }
    }

    private void scrapeContent(DetailNode ast) {
        if (ast.getType() == 10008) {
            if (JavadocMetadataScraper.isParentText(ast)) {
                this.parentSectionStartIdx = JavadocMetadataScraper.getParentIndexOf(ast);
                this.moduleDetails.setParent(JavadocMetadataScraper.getParentText(ast));
            } else if (JavadocMetadataScraper.isViolationMessagesText(ast)) {
                this.scrapingViolationMessageList = true;
            } else if (this.exampleSectionStartIdx == -1 && JavadocMetadataScraper.isExamplesText(ast)) {
                this.exampleSectionStartIdx = JavadocMetadataScraper.getParentIndexOf(ast);
            }
        } else if (ast.getType() == 10011) {
            if (JavadocMetadataScraper.isPropertyList(ast)) {
                if (this.propertySectionStartIdx == -1) {
                    this.propertySectionStartIdx = JavadocMetadataScraper.getParentIndexOf(ast);
                }
                this.moduleDetails.addToProperties(JavadocMetadataScraper.createProperties(ast));
            } else if (this.scrapingViolationMessageList) {
                this.moduleDetails.addToViolationMessages(JavadocMetadataScraper.getViolationMessages(ast));
            }
        }
    }

    private static ModulePropertyDetails createProperties(DetailNode nodeLi) {
        ModulePropertyDetails modulePropertyDetails = new ModulePropertyDetails();
        Optional<DetailNode> propertyNameNode = JavadocMetadataScraper.getFirstChildOfType(nodeLi, 10072, 0);
        if (propertyNameNode.isPresent()) {
            String defaultValue;
            DetailNode propertyNameTag = propertyNameNode.orElseThrow();
            String propertyName = JavadocMetadataScraper.getTextFromTag(propertyNameTag);
            DetailNode propertyType = JavadocMetadataScraper.getFirstChildOfMatchingText(nodeLi, TYPE_TAG).orElseThrow(() -> new MetadataGenerationException(String.format(Locale.ROOT, PROP_TYPE_MISSING, propertyName)));
            String propertyDesc = DESC_CLEAN.matcher(JavadocMetadataScraper.constructSubTreeText(nodeLi, propertyNameTag.getIndex() + 1, propertyType.getIndex() - 1)).replaceAll(Matcher.quoteReplacement(""));
            modulePropertyDetails.setDescription(propertyDesc.trim());
            modulePropertyDetails.setName(propertyName);
            modulePropertyDetails.setType(JavadocMetadataScraper.getTagTextFromProperty(nodeLi, propertyType));
            Optional<DetailNode> validationTypeNodeOpt = JavadocMetadataScraper.getFirstChildOfMatchingText(nodeLi, VALIDATION_TYPE_TAG);
            if (validationTypeNodeOpt.isPresent()) {
                DetailNode validationTypeNode = validationTypeNodeOpt.orElseThrow();
                modulePropertyDetails.setValidationType(JavadocMetadataScraper.getTagTextFromProperty(nodeLi, validationTypeNode));
            }
            if (!PROPERTIES_TO_NOT_WRITE.contains(defaultValue = JavadocMetadataScraper.getFirstChildOfMatchingText(nodeLi, DEFAULT_VALUE_TAG).map(defaultValueNode -> JavadocMetadataScraper.getPropertyDefaultText(nodeLi, defaultValueNode)).orElseThrow(() -> new MetadataGenerationException(String.format(Locale.ROOT, PROP_DEFAULT_VALUE_MISSING, propertyName))))) {
                modulePropertyDetails.setDefaultValue(defaultValue);
            }
        }
        return modulePropertyDetails;
    }

    private static String getTagTextFromProperty(DetailNode nodeLi, DetailNode propertyMeta) {
        Optional<DetailNode> tagNodeOpt = JavadocMetadataScraper.getFirstChildOfType(nodeLi, 10072, propertyMeta.getIndex() + 1);
        DetailNode tagNode = null;
        if (tagNodeOpt.isPresent()) {
            tagNode = tagNodeOpt.orElseThrow();
        }
        return JavadocMetadataScraper.getTextFromTag(tagNode);
    }

    private static String cleanDefaultTokensText(String initialText) {
        LinkedHashSet<String> tokens = new LinkedHashSet<String>();
        Matcher matcher = TOKEN_TEXT_PATTERN.matcher(initialText);
        while (matcher.find()) {
            tokens.add(matcher.group(0));
        }
        return String.join((CharSequence)",", tokens);
    }

    private static String constructSubTreeText(DetailNode node, int childLeftLimit, int childRightLimit) {
        DetailNode detailNode = node;
        ArrayDeque<DetailNode> stack = new ArrayDeque<DetailNode>();
        stack.addFirst(detailNode);
        HashSet<DetailNode> visited = new HashSet<DetailNode>();
        StringBuilder result = new StringBuilder(1024);
        while (!stack.isEmpty()) {
            detailNode = (DetailNode)stack.removeFirst();
            if (visited.add(detailNode)) {
                String childText = detailNode.getText();
                if (detailNode.getType() != 1 && !TOKEN_TEXT_PATTERN.matcher(childText).matches()) {
                    result.insert(0, childText);
                }
            }
            for (DetailNode child : detailNode.getChildren()) {
                if (child.getParent().equals(node) && (child.getIndex() < childLeftLimit || child.getIndex() > childRightLimit) || visited.contains(child)) continue;
                stack.addFirst(child);
            }
        }
        return result.toString().trim();
    }

    private String getDescriptionText() {
        int descriptionEndIdx = this.propertySectionStartIdx > -1 ? this.propertySectionStartIdx : (this.exampleSectionStartIdx > -1 ? this.exampleSectionStartIdx : this.parentSectionStartIdx);
        return JavadocMetadataScraper.constructSubTreeText(this.rootNode, 0, descriptionEndIdx - 1);
    }

    private static String getPropertyDefaultText(DetailNode nodeLi, DetailNode defaultValueNode) {
        String result;
        Optional<DetailNode> propertyDefaultValueTag = JavadocMetadataScraper.getFirstChildOfType(nodeLi, 10072, defaultValueNode.getIndex() + 1);
        if (propertyDefaultValueTag.isPresent()) {
            result = JavadocMetadataScraper.getTextFromTag(propertyDefaultValueTag.orElseThrow());
        } else {
            String tokenText = JavadocMetadataScraper.constructSubTreeText(nodeLi, defaultValueNode.getIndex(), nodeLi.getChildren().length);
            result = JavadocMetadataScraper.cleanDefaultTokensText(tokenText);
        }
        return result;
    }

    private static String getViolationMessages(DetailNode nodeLi) {
        Optional<DetailNode> resultNode = JavadocMetadataScraper.getFirstChildOfType(nodeLi, 10072, 0);
        return resultNode.map(JavadocMetadataScraper::getTextFromTag).orElse("");
    }

    private static String getTextFromTag(DetailNode nodeTag) {
        return Optional.ofNullable(nodeTag).map(JavadocMetadataScraper::getText).orElse("");
    }

    private static Optional<DetailNode> getFirstChildOfType(DetailNode node, int tokenType, int offset) {
        return Arrays.stream(node.getChildren()).filter(child -> child.getIndex() >= offset && child.getType() == tokenType).findFirst();
    }

    private static String getText(DetailNode parentNode) {
        return Arrays.stream(parentNode.getChildren()).filter(child -> child.getType() == 10074).map(node -> QUOTE_PATTERN.matcher(node.getText().trim()).replaceAll("")).collect(Collectors.joining(" "));
    }

    private static Optional<DetailNode> getFirstChildOfMatchingText(DetailNode node, Pattern pattern) {
        return Arrays.stream(node.getChildren()).filter(child -> pattern.matcher(child.getText()).matches()).findFirst();
    }

    private static DetailAST getParent(DetailAST commentBlock) {
        DetailAST parentNode = commentBlock.getParent();
        DetailAST result = parentNode;
        if (result.getType() == 159) {
            result = parentNode.getParent().getParent();
        } else if (result.getType() == 5) {
            result = parentNode.getParent();
        }
        return result;
    }

    private static int getParentIndexOf(DetailNode node) {
        DetailNode currNode = node;
        while (currNode.getParent().getIndex() != -1) {
            currNode = currNode.getParent();
        }
        return currNode.getIndex();
    }

    private static String getParentText(DetailNode nodeParagraph) {
        return JavadocMetadataScraper.getFirstChildOfType(nodeParagraph, 10072, 0).map(JavadocMetadataScraper::getTextFromTag).orElse(null);
    }

    private ModuleType getModuleType() {
        String simpleModuleName = this.getModuleSimpleName();
        ModuleType result = simpleModuleName.endsWith("FileFilter") ? ModuleType.FILEFILTER : (simpleModuleName.endsWith("Filter") ? ModuleType.FILTER : ModuleType.CHECK);
        return result;
    }

    private String getModuleSimpleName() {
        String fullFileName = this.getFilePath();
        String[] pathTokens = FILE_SEPARATOR_PATTERN.split(fullFileName);
        String fileName = pathTokens[pathTokens.length - 1];
        return fileName.substring(0, fileName.length() - JAVA_FILE_EXTENSION.length());
    }

    private static String getPackageName(String filePath) {
        ArrayDeque<String> result = new ArrayDeque<String>();
        String[] filePathTokens = FILE_SEPARATOR_PATTERN.split(filePath);
        for (int i = filePathTokens.length - 1; i >= 0 && !"java".equals(filePathTokens[i]) && !"resources".equals(filePathTokens[i]); --i) {
            result.addFirst(filePathTokens[i]);
        }
        String fileName = (String)result.removeLast();
        result.addLast(fileName.substring(0, fileName.length() - JAVA_FILE_EXTENSION.length()));
        return String.join((CharSequence)".", result);
    }

    public static Map<String, ModuleDetails> getModuleDetailsStore() {
        return Collections.unmodifiableMap(MODULE_DETAILS_STORE);
    }

    public static void resetModuleDetailsStore() {
        MODULE_DETAILS_STORE.clear();
    }

    private boolean isTopLevelClassJavadoc() {
        DetailAST parent = JavadocMetadataScraper.getParent(this.getBlockCommentAst());
        Optional<DetailAST> className = TokenUtil.findFirstTokenByPredicate(parent, child -> parent.getType() == 14 && child.getType() == 58);
        return className.isPresent() && this.getModuleSimpleName().equals(className.orElseThrow().getText());
    }

    private static boolean isExamplesText(DetailNode ast) {
        return JavadocMetadataScraper.isChildNodeTextMatches(ast, EXAMPLES_TAG);
    }

    private static boolean isPropertyList(DetailNode nodeLi) {
        return JavadocMetadataScraper.isChildNodeTextMatches(nodeLi, PROPERTY_TAG);
    }

    private static boolean isViolationMessagesText(DetailNode nodeParagraph) {
        return JavadocMetadataScraper.isChildNodeTextMatches(nodeParagraph, VIOLATION_MESSAGES_TAG);
    }

    private static boolean isParentText(DetailNode nodeParagraph) {
        return JavadocMetadataScraper.isChildNodeTextMatches(nodeParagraph, PARENT_TAG);
    }

    private static boolean isChildNodeTextMatches(DetailNode ast, Pattern pattern) {
        return JavadocMetadataScraper.getFirstChildOfType(ast, 10074, 0).map(DetailNode::getText).map(pattern::matcher).map(Matcher::matches).orElse(Boolean.FALSE);
    }
}

