/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.javadoc;

import com.puppycrawl.tools.checkstyle.StatelessCheck;
import com.puppycrawl.tools.checkstyle.api.DetailNode;
import com.puppycrawl.tools.checkstyle.checks.javadoc.AbstractJavadocCheck;
import com.puppycrawl.tools.checkstyle.utils.CommonUtil;
import com.puppycrawl.tools.checkstyle.utils.JavadocUtil;
import com.puppycrawl.tools.checkstyle.utils.TokenUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import javax.annotation.Nullable;

@StatelessCheck
public class SummaryJavadocCheck
extends AbstractJavadocCheck {
    public static final String MSG_SUMMARY_FIRST_SENTENCE = "summary.first.sentence";
    public static final String MSG_SUMMARY_JAVADOC = "summary.javaDoc";
    public static final String MSG_SUMMARY_JAVADOC_MISSING = "summary.javaDoc.missing";
    public static final String MSG_SUMMARY_MISSING_PERIOD = "summary.javaDoc.missing.period";
    private static final Pattern JAVADOC_MULTILINE_TO_SINGLELINE_PATTERN = Pattern.compile("\n +(\\*)|^ +(\\*)");
    private static final Pattern HTML_ELEMENTS = Pattern.compile("<[^>]*>");
    private static final String DEFAULT_PERIOD = ".";
    private static final String SUMMARY_TEXT = "@summary";
    private static final String RETURN_TEXT = "@return";
    private static final BitSet ALLOWED_TYPES = TokenUtil.asBitSet(4, 10068, 10074);
    private Pattern forbiddenSummaryFragments = CommonUtil.createPattern("^$");
    private String period = ".";

    public void setForbiddenSummaryFragments(Pattern pattern) {
        this.forbiddenSummaryFragments = pattern;
    }

    public void setPeriod(String period) {
        this.period = period;
    }

    @Override
    public int[] getDefaultJavadocTokens() {
        return new int[]{10000};
    }

    @Override
    public int[] getRequiredJavadocTokens() {
        return this.getAcceptableJavadocTokens();
    }

    @Override
    public void visitJavadocToken(DetailNode ast) {
        Optional<DetailNode> inlineTagNode = SummaryJavadocCheck.getInlineTagNode(ast);
        boolean shouldValidateUntaggedSummary = true;
        if (inlineTagNode.isPresent()) {
            DetailNode node = inlineTagNode.get();
            if (SummaryJavadocCheck.isSummaryTag(node) && SummaryJavadocCheck.isDefinedFirst(node)) {
                shouldValidateUntaggedSummary = false;
                this.validateSummaryTag(node);
            } else if (SummaryJavadocCheck.isInlineReturnTag(node)) {
                shouldValidateUntaggedSummary = false;
                this.validateInlineReturnTag(node);
            }
        }
        if (shouldValidateUntaggedSummary && !SummaryJavadocCheck.startsWithInheritDoc(ast)) {
            this.validateUntaggedSummary(ast);
        }
    }

    private void validateUntaggedSummary(DetailNode ast) {
        String summaryDoc = SummaryJavadocCheck.getSummarySentence(ast);
        if (summaryDoc.isEmpty()) {
            this.log(ast.getLineNumber(), MSG_SUMMARY_JAVADOC_MISSING, new Object[0]);
        } else if (!this.period.isEmpty()) {
            if (summaryDoc.contains(this.period)) {
                String firstSentence = SummaryJavadocCheck.getFirstSentenceOrNull(ast, this.period);
                if (firstSentence == null) {
                    this.log(ast.getLineNumber(), MSG_SUMMARY_FIRST_SENTENCE, new Object[0]);
                } else if (this.containsForbiddenFragment(firstSentence)) {
                    this.log(ast.getLineNumber(), MSG_SUMMARY_JAVADOC, new Object[0]);
                }
            } else {
                this.log(ast.getLineNumber(), MSG_SUMMARY_FIRST_SENTENCE, new Object[0]);
            }
        }
    }

    private static Optional<DetailNode> getInlineTagNode(DetailNode javadoc) {
        return Arrays.stream(javadoc.getChildren()).filter(SummaryJavadocCheck::isInlineTagPresent).findFirst().map(SummaryJavadocCheck::getInlineTagNodeForAst);
    }

    private static boolean isDefinedFirst(DetailNode inlineSummaryTag) {
        boolean isDefinedFirst = true;
        DetailNode currentAst = inlineSummaryTag;
        while (currentAst != null && isDefinedFirst) {
            switch (currentAst.getType()) {
                case 10074: {
                    isDefinedFirst = currentAst.getText().isBlank();
                    break;
                }
                case 10001: {
                    isDefinedFirst = !SummaryJavadocCheck.isTextPresentInsideHtmlTag(currentAst);
                    break;
                }
            }
            currentAst = JavadocUtil.getPreviousSibling(currentAst);
        }
        return isDefinedFirst;
    }

    public static boolean isTextPresentInsideHtmlTag(DetailNode node) {
        DetailNode nestedChild = JavadocUtil.getFirstChild(node);
        if (node.getType() == 10001) {
            nestedChild = JavadocUtil.getFirstChild(nestedChild);
        }
        boolean isTextPresentInsideHtmlTag = false;
        while (nestedChild != null && !isTextPresentInsideHtmlTag) {
            switch (nestedChild.getType()) {
                case 10074: {
                    isTextPresentInsideHtmlTag = !nestedChild.getText().isBlank();
                    break;
                }
                case 10001: 
                case 10005: {
                    isTextPresentInsideHtmlTag = SummaryJavadocCheck.isTextPresentInsideHtmlTag(nestedChild);
                    break;
                }
            }
            nestedChild = JavadocUtil.getNextSibling(nestedChild);
        }
        return isTextPresentInsideHtmlTag;
    }

    private static boolean isInlineTagPresent(DetailNode ast) {
        return SummaryJavadocCheck.getInlineTagNodeForAst(ast) != null;
    }

    private static DetailNode getInlineTagNodeForAst(DetailNode ast) {
        DetailNode node = ast;
        DetailNode result = null;
        if (node.getType() == 10072) {
            result = node;
        } else if (node.getType() == 10005) {
            node = node.getChildren()[1];
            result = SummaryJavadocCheck.getInlineTagNodeForAst(node);
        } else if (node.getType() == 10001 && node.getChildren()[0].getChildren().length > 1) {
            node = node.getChildren()[0].getChildren()[1];
            result = SummaryJavadocCheck.getInlineTagNodeForAst(node);
        }
        return result;
    }

    private static boolean isSummaryTag(DetailNode javadocInlineTag) {
        return SummaryJavadocCheck.isInlineTagWithName(javadocInlineTag, SUMMARY_TEXT);
    }

    private static boolean isInlineReturnTag(DetailNode javadocInlineTag) {
        return SummaryJavadocCheck.isInlineTagWithName(javadocInlineTag, RETURN_TEXT);
    }

    private static boolean isInlineTagWithName(DetailNode javadocInlineTag, String name) {
        DetailNode[] child = javadocInlineTag.getChildren();
        return name.equals(child[1].getText());
    }

    private void validateSummaryTag(DetailNode inlineSummaryTag) {
        String inlineSummary = SummaryJavadocCheck.getContentOfInlineCustomTag(inlineSummaryTag);
        String summaryVisible = SummaryJavadocCheck.getVisibleContent(inlineSummary);
        if (summaryVisible.isEmpty()) {
            this.log(inlineSummaryTag.getLineNumber(), MSG_SUMMARY_JAVADOC_MISSING, new Object[0]);
        } else if (!this.period.isEmpty()) {
            boolean isPeriodNotAtEnd;
            boolean bl = isPeriodNotAtEnd = summaryVisible.lastIndexOf(this.period) != summaryVisible.length() - 1;
            if (isPeriodNotAtEnd) {
                this.log(inlineSummaryTag.getLineNumber(), MSG_SUMMARY_MISSING_PERIOD, new Object[0]);
            } else if (this.containsForbiddenFragment(inlineSummary)) {
                this.log(inlineSummaryTag.getLineNumber(), MSG_SUMMARY_JAVADOC, new Object[0]);
            }
        }
    }

    private void validateInlineReturnTag(DetailNode inlineReturnTag) {
        String inlineReturn = SummaryJavadocCheck.getContentOfInlineCustomTag(inlineReturnTag);
        String returnVisible = SummaryJavadocCheck.getVisibleContent(inlineReturn);
        if (returnVisible.isEmpty()) {
            this.log(inlineReturnTag.getLineNumber(), MSG_SUMMARY_JAVADOC_MISSING, new Object[0]);
        } else if (this.containsForbiddenFragment(inlineReturn)) {
            this.log(inlineReturnTag.getLineNumber(), MSG_SUMMARY_JAVADOC, new Object[0]);
        }
    }

    public static String getContentOfInlineCustomTag(DetailNode inlineTag) {
        DetailNode[] childrenOfInlineTag = inlineTag.getChildren();
        StringBuilder customTagContent = new StringBuilder(256);
        int indexOfContentOfSummaryTag = 3;
        if (childrenOfInlineTag.length != 3) {
            DetailNode currentNode = childrenOfInlineTag[3];
            while (currentNode.getType() != 20) {
                SummaryJavadocCheck.extractInlineTagContent(currentNode, customTagContent);
                currentNode = JavadocUtil.getNextSibling(currentNode);
            }
        }
        return customTagContent.toString();
    }

    private static void extractInlineTagContent(DetailNode node, StringBuilder customTagContent) {
        DetailNode[] children = node.getChildren();
        if (children.length == 0) {
            customTagContent.append(node.getText());
        } else {
            for (DetailNode child : children) {
                if (child.getType() == 1) continue;
                SummaryJavadocCheck.extractInlineTagContent(child, customTagContent);
            }
        }
    }

    private static String getVisibleContent(String summary) {
        String visibleSummary = HTML_ELEMENTS.matcher(summary).replaceAll("");
        return visibleSummary.trim();
    }

    private boolean containsForbiddenFragment(String firstSentence) {
        String javadocText = JAVADOC_MULTILINE_TO_SINGLELINE_PATTERN.matcher(firstSentence).replaceAll(" ");
        return this.forbiddenSummaryFragments.matcher(SummaryJavadocCheck.trimExcessWhitespaces(javadocText)).find();
    }

    private static String trimExcessWhitespaces(String text) {
        StringBuilder result = new StringBuilder(256);
        boolean previousWhitespace = true;
        for (char letter : text.toCharArray()) {
            char print;
            if (Character.isWhitespace(letter)) {
                if (previousWhitespace) continue;
                previousWhitespace = true;
                print = ' ';
            } else {
                previousWhitespace = false;
                print = letter;
            }
            result.append(print);
        }
        return result.toString();
    }

    private static boolean startsWithInheritDoc(DetailNode root) {
        boolean found = false;
        for (DetailNode child : root.getChildren()) {
            if (child.getType() == 10072 && child.getChildren()[1].getType() == 47) {
                found = true;
            }
            if ((child.getType() == 10074 || child.getType() == 10001) && !CommonUtil.isBlank(child.getText())) break;
        }
        return found;
    }

    private static String getSummarySentence(DetailNode ast) {
        StringBuilder result = new StringBuilder(256);
        for (DetailNode child : ast.getChildren()) {
            if (child.getType() != -1 && ALLOWED_TYPES.get(child.getType())) {
                result.append(child.getText());
                continue;
            }
            String summary = result.toString();
            if (child.getType() != 10001 || !CommonUtil.isBlank(summary)) continue;
            result.append(SummaryJavadocCheck.getStringInsideTag(summary, child.getChildren()[0].getChildren()[0]));
        }
        return result.toString().trim();
    }

    private static String getStringInsideTag(String result, DetailNode detailNode) {
        StringBuilder contents = new StringBuilder(result);
        DetailNode tempNode = detailNode;
        while (tempNode != null) {
            if (tempNode.getType() == 10074) {
                contents.append(tempNode.getText());
            }
            tempNode = JavadocUtil.getNextSibling(tempNode);
        }
        return contents.toString();
    }

    @Nullable
    private static String getFirstSentenceOrNull(DetailNode ast, String period) {
        ArrayList<String> sentenceParts = new ArrayList<String>();
        String sentence = null;
        for (String text : SummaryJavadocCheck.streamTextParts(ast)::iterator) {
            String sentenceEnding = SummaryJavadocCheck.findSentenceEndingOrNull(text, period);
            if (sentenceEnding != null) {
                sentenceParts.add(sentenceEnding);
                sentence = String.join((CharSequence)"", sentenceParts);
                break;
            }
            sentenceParts.add(text);
        }
        return sentence;
    }

    private static Stream<String> streamTextParts(DetailNode node) {
        Stream<String> stream = node.getChildren().length == 0 ? Stream.of(node.getText()) : Stream.of(node.getChildren()).flatMap(SummaryJavadocCheck::streamTextParts);
        return stream;
    }

    @Nullable
    private static String findSentenceEndingOrNull(String text, String period) {
        int periodIndex = text.indexOf(period);
        String sentenceEnding = null;
        while (periodIndex >= 0) {
            int afterPeriodIndex = periodIndex + period.length();
            if (!DEFAULT_PERIOD.equals(period) || afterPeriodIndex >= text.length() || Character.isWhitespace(text.charAt(afterPeriodIndex))) {
                sentenceEnding = text.substring(0, periodIndex);
                break;
            }
            periodIndex = text.indexOf(period, afterPeriodIndex);
        }
        return sentenceEnding;
    }
}

