/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.blocks;

import com.puppycrawl.tools.checkstyle.StatelessCheck;
import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.checks.blocks.RightCurlyOption;
import com.puppycrawl.tools.checkstyle.utils.CommonUtil;
import com.puppycrawl.tools.checkstyle.utils.TokenUtil;
import java.util.Arrays;
import java.util.Locale;

@StatelessCheck
public class RightCurlyCheck
extends AbstractCheck {
    public static final String MSG_KEY_LINE_BREAK_BEFORE = "line.break.before";
    public static final String MSG_KEY_LINE_ALONE = "line.alone";
    public static final String MSG_KEY_LINE_SAME = "line.same";
    private RightCurlyOption option = RightCurlyOption.SAME;

    public void setOption(String optionStr) {
        this.option = RightCurlyOption.valueOf(optionStr.trim().toUpperCase(Locale.ENGLISH));
    }

    @Override
    public int[] getDefaultTokens() {
        return new int[]{95, 96, 97, 83, 92};
    }

    @Override
    public int[] getAcceptableTokens() {
        return new int[]{95, 96, 97, 83, 92, 14, 9, 8, 91, 84, 85, 12, 11, 157, 154, 15, 199, 203};
    }

    @Override
    public int[] getRequiredTokens() {
        return CommonUtil.EMPTY_INT_ARRAY;
    }

    @Override
    public void visitToken(DetailAST ast) {
        String violation;
        Details details = Details.getDetails(ast);
        DetailAST rcurly = details.rcurly;
        if (rcurly != null && !(violation = this.validate(details)).isEmpty()) {
            this.log(rcurly, violation, "}", rcurly.getColumnNo() + 1);
        }
    }

    private String validate(Details details) {
        String violation = "";
        if (RightCurlyCheck.shouldHaveLineBreakBefore(this.option, details)) {
            violation = MSG_KEY_LINE_BREAK_BEFORE;
        } else if (RightCurlyCheck.shouldBeOnSameLine(this.option, details)) {
            violation = MSG_KEY_LINE_SAME;
        } else if (RightCurlyCheck.shouldBeAloneOnLine(this.option, details, this.getLine(details.rcurly.getLineNo() - 1))) {
            violation = MSG_KEY_LINE_ALONE;
        }
        return violation;
    }

    private static boolean shouldHaveLineBreakBefore(RightCurlyOption bracePolicy, Details details) {
        return bracePolicy == RightCurlyOption.SAME && !RightCurlyCheck.hasLineBreakBefore(details.rcurly) && !TokenUtil.areOnSameLine(details.lcurly, details.rcurly);
    }

    private static boolean shouldBeOnSameLine(RightCurlyOption bracePolicy, Details details) {
        return bracePolicy == RightCurlyOption.SAME && !details.shouldCheckLastRcurly && !TokenUtil.areOnSameLine(details.rcurly, details.nextToken);
    }

    private static boolean shouldBeAloneOnLine(RightCurlyOption bracePolicy, Details details, String targetSrcLine) {
        return bracePolicy == RightCurlyOption.ALONE && RightCurlyCheck.shouldBeAloneOnLineWithAloneOption(details, targetSrcLine) || (bracePolicy == RightCurlyOption.ALONE_OR_SINGLELINE || details.shouldCheckLastRcurly) && RightCurlyCheck.shouldBeAloneOnLineWithNotAloneOption(details, targetSrcLine);
    }

    private static boolean shouldBeAloneOnLineWithAloneOption(Details details, String targetSrcLine) {
        return !RightCurlyCheck.isAloneOnLine(details, targetSrcLine);
    }

    private static boolean shouldBeAloneOnLineWithNotAloneOption(Details details, String targetSrcLine) {
        return RightCurlyCheck.shouldBeAloneOnLineWithAloneOption(details, targetSrcLine) && !RightCurlyCheck.isBlockAloneOnSingleLine(details);
    }

    private static boolean isAloneOnLine(Details details, String targetSrcLine) {
        DetailAST rcurly = details.rcurly;
        DetailAST nextToken = details.nextToken;
        return (nextToken == null || !TokenUtil.areOnSameLine(rcurly, nextToken) || RightCurlyCheck.skipDoubleBraceInstInit(details)) && CommonUtil.hasWhitespaceBefore(details.rcurly.getColumnNo(), targetSrcLine);
    }

    private static boolean skipDoubleBraceInstInit(Details details) {
        boolean skipDoubleBraceInstInit = false;
        DetailAST tokenAfterNextToken = Details.getNextToken(details.nextToken);
        if (tokenAfterNextToken != null) {
            DetailAST rcurly = details.rcurly;
            skipDoubleBraceInstInit = rcurly.getParent().getParent().getType() == 11 && details.nextToken.getType() == 73 && !TokenUtil.areOnSameLine(rcurly, Details.getNextToken(tokenAfterNextToken));
        }
        return skipDoubleBraceInstInit;
    }

    private static boolean isBlockAloneOnSingleLine(Details details) {
        DetailAST nextToken = details.nextToken;
        while (nextToken != null && nextToken.getType() == 92) {
            nextToken = Details.getNextToken(nextToken);
        }
        if (nextToken != null && nextToken.getType() == 175) {
            DetailAST doWhileSemi = nextToken.getParent();
            nextToken = Details.getNextToken(doWhileSemi);
        }
        return TokenUtil.areOnSameLine(details.lcurly, details.rcurly) && (nextToken == null || !TokenUtil.areOnSameLine(details.rcurly, nextToken) || RightCurlyCheck.isRightcurlyFollowedBySemicolon(details));
    }

    private static boolean isRightcurlyFollowedBySemicolon(Details details) {
        return details.nextToken.getType() == 45;
    }

    private static boolean hasLineBreakBefore(DetailAST rightCurly) {
        DetailAST previousToken = rightCurly.getPreviousSibling();
        if (previousToken == null) {
            previousToken = rightCurly.getParent();
        }
        return !TokenUtil.areOnSameLine(rightCurly, previousToken);
    }

    private static final class Details {
        private static final int[] TOKENS_WITH_NO_CHILD_SLIST = new int[]{14, 154, 157, 15, 199};
        private final DetailAST rcurly;
        private final DetailAST lcurly;
        private final DetailAST nextToken;
        private final boolean shouldCheckLastRcurly;

        private Details(DetailAST lcurly, DetailAST rcurly, DetailAST nextToken, boolean shouldCheckLastRcurly) {
            this.lcurly = lcurly;
            this.rcurly = rcurly;
            this.nextToken = nextToken;
            this.shouldCheckLastRcurly = shouldCheckLastRcurly;
        }

        private static Details getDetails(DetailAST ast) {
            Details details;
            switch (ast.getType()) {
                case 95: 
                case 96: {
                    details = Details.getDetailsForTryCatch(ast);
                    break;
                }
                case 83: {
                    details = Details.getDetailsForIf(ast);
                    break;
                }
                case 85: {
                    details = Details.getDetailsForDoLoops(ast);
                    break;
                }
                default: {
                    details = Details.getDetailsForOthers(ast);
                }
            }
            return details;
        }

        private static Details getDetailsForTryCatch(DetailAST ast) {
            boolean shouldCheckLastRcurly;
            DetailAST nextToken;
            DetailAST lcurly;
            int tokenType = ast.getType();
            if (tokenType == 95) {
                lcurly = ast.getFirstChild().getType() == 176 ? ast.getFirstChild().getNextSibling() : ast.getFirstChild();
                nextToken = lcurly.getNextSibling();
            } else {
                nextToken = ast.getNextSibling();
                lcurly = ast.getLastChild();
            }
            if (nextToken == null) {
                shouldCheckLastRcurly = true;
                nextToken = Details.getNextToken(ast);
            } else {
                shouldCheckLastRcurly = false;
            }
            DetailAST rcurly = lcurly.getLastChild();
            return new Details(lcurly, rcurly, nextToken, shouldCheckLastRcurly);
        }

        private static Details getDetailsForIf(DetailAST ast) {
            DetailAST lcurly;
            boolean shouldCheckLastRcurly;
            DetailAST nextToken = ast.findFirstToken(92);
            if (nextToken == null) {
                shouldCheckLastRcurly = true;
                nextToken = Details.getNextToken(ast);
                lcurly = ast.getLastChild();
            } else {
                shouldCheckLastRcurly = false;
                lcurly = nextToken.getPreviousSibling();
            }
            DetailAST rcurly = null;
            if (lcurly.getType() == 7) {
                rcurly = lcurly.getLastChild();
            }
            return new Details(lcurly, rcurly, nextToken, shouldCheckLastRcurly);
        }

        private static Details getDetailsForOthers(DetailAST ast) {
            DetailAST lcurly;
            DetailAST rcurly = null;
            int tokenType = ast.getType();
            if (Details.isTokenWithNoChildSlist(tokenType)) {
                DetailAST child;
                lcurly = child = ast.getLastChild();
                rcurly = child.getLastChild();
            } else {
                lcurly = ast.findFirstToken(7);
                if (lcurly != null) {
                    rcurly = lcurly.getLastChild();
                }
            }
            return new Details(lcurly, rcurly, Details.getNextToken(ast), true);
        }

        private static boolean isTokenWithNoChildSlist(int tokenType) {
            return Arrays.stream(TOKENS_WITH_NO_CHILD_SLIST).anyMatch(token -> token == tokenType);
        }

        private static Details getDetailsForDoLoops(DetailAST ast) {
            DetailAST lcurly = ast.findFirstToken(7);
            DetailAST nextToken = ast.findFirstToken(175);
            DetailAST rcurly = null;
            if (lcurly != null) {
                rcurly = lcurly.getLastChild();
            }
            return new Details(lcurly, rcurly, nextToken, false);
        }

        private static DetailAST getNextToken(DetailAST ast) {
            DetailAST next = null;
            for (DetailAST parent = ast; next == null && parent != null; parent = parent.getParent()) {
                next = parent.getNextSibling();
            }
            return next;
        }
    }
}

