/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.xpath;

import com.puppycrawl.tools.checkstyle.xpath.AbstractNode;
import com.puppycrawl.tools.checkstyle.xpath.AttributeNode;
import com.puppycrawl.tools.checkstyle.xpath.iterators.DescendantIterator;
import com.puppycrawl.tools.checkstyle.xpath.iterators.FollowingIterator;
import com.puppycrawl.tools.checkstyle.xpath.iterators.PrecedingIterator;
import com.puppycrawl.tools.checkstyle.xpath.iterators.ReverseListIterator;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.sf.saxon.om.NamespaceUri;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.tree.iter.ArrayIterator;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.tree.iter.EmptyIterator;
import net.sf.saxon.tree.iter.SingleNodeIterator;
import net.sf.saxon.tree.util.Navigator;

public abstract class AbstractElementNode
extends AbstractNode {
    protected static final String TEXT_ATTRIBUTE_NAME = "text";
    private static final AbstractNode[] EMPTY_ABSTRACT_NODE_ARRAY = new AbstractNode[0];
    private static final AttributeNode ATTRIBUTE_NODE_UNINITIALIZED = new AttributeNode(null, null);
    private final AbstractNode root;
    private final AbstractNode parent;
    private final int depth;
    private final int indexAmongSiblings;
    private AttributeNode attributeNode = ATTRIBUTE_NODE_UNINITIALIZED;

    protected AbstractElementNode(AbstractNode root, AbstractNode parent, int depth, int indexAmongSiblings) {
        super(root.getTreeInfo());
        this.parent = parent;
        this.root = root;
        this.depth = depth;
        this.indexAmongSiblings = indexAmongSiblings;
    }

    protected abstract AttributeNode createAttributeNode();

    public int compareOrder(NodeInfo other) {
        int result = 0;
        if (other instanceof AbstractNode && (result = Integer.compare(this.depth, ((AbstractNode)other).getDepth())) == 0) {
            result = AbstractElementNode.compareCommonAncestorChildrenOrder(this, other);
        }
        return result;
    }

    private static int compareCommonAncestorChildrenOrder(NodeInfo first, NodeInfo second) {
        NodeInfo child1 = first;
        NodeInfo child2 = second;
        while (!child1.getParent().equals((Object)child2.getParent())) {
            child1 = child1.getParent();
            child2 = child2.getParent();
        }
        int index1 = ((AbstractElementNode)child1).indexAmongSiblings;
        int index2 = ((AbstractElementNode)child2).indexAmongSiblings;
        return Integer.compare(index1, index2);
    }

    @Override
    public int getDepth() {
        return this.depth;
    }

    public String getAttributeValue(NamespaceUri namespace, String localPart) {
        String result = TEXT_ATTRIBUTE_NAME.equals(localPart) ? (String)Optional.ofNullable(this.getAttributeNode()).map(AttributeNode::getStringValue).orElse(null) : null;
        return result;
    }

    public int getNodeKind() {
        return 1;
    }

    public NodeInfo getParent() {
        return this.parent;
    }

    public AbstractNode getRoot() {
        return this.root;
    }

    public AxisIterator iterateAxis(int axisNumber) {
        return switch (axisNumber) {
            case 0 -> new Navigator.AncestorEnumeration((NodeInfo)this, false);
            case 1 -> new Navigator.AncestorEnumeration((NodeInfo)this, true);
            case 2 -> SingleNodeIterator.makeIterator((NodeInfo)this.getAttributeNode());
            case 3 -> {
                if (this.hasChildNodes()) {
                    yield new ArrayIterator.OfNodes((NodeInfo[])this.getChildren().toArray(EMPTY_ABSTRACT_NODE_ARRAY));
                }
                yield EmptyIterator.ofNodes();
            }
            case 4 -> {
                if (this.hasChildNodes()) {
                    yield new DescendantIterator(this, DescendantIterator.StartWith.CHILDREN);
                }
                yield EmptyIterator.ofNodes();
            }
            case 5 -> new DescendantIterator(this, DescendantIterator.StartWith.CURRENT_NODE);
            case 9 -> SingleNodeIterator.makeIterator((NodeInfo)this.parent);
            case 12 -> SingleNodeIterator.makeIterator((NodeInfo)this);
            case 7 -> this.getFollowingSiblingsIterator();
            case 11 -> this.getPrecedingSiblingsIterator();
            case 6 -> new FollowingIterator(this);
            case 10 -> new PrecedingIterator(this);
            default -> throw AbstractElementNode.throwUnsupportedOperationException();
        };
    }

    private AxisIterator getPrecedingSiblingsIterator() {
        Object result = this.indexAmongSiblings == 0 ? EmptyIterator.ofNodes() : new ReverseListIterator(this.getPrecedingSiblings());
        return result;
    }

    private AxisIterator getFollowingSiblingsIterator() {
        Object result = this.indexAmongSiblings == this.parent.getChildren().size() - 1 ? EmptyIterator.ofNodes() : new ArrayIterator.OfNodes((NodeInfo[])this.getFollowingSiblings().toArray(EMPTY_ABSTRACT_NODE_ARRAY));
        return result;
    }

    private List<AbstractNode> getFollowingSiblings() {
        List<AbstractNode> siblings = this.parent.getChildren();
        return siblings.subList(this.indexAmongSiblings + 1, siblings.size());
    }

    private List<AbstractNode> getPrecedingSiblings() {
        List<AbstractNode> siblings = this.parent.getChildren();
        return Collections.unmodifiableList(siblings.subList(0, this.indexAmongSiblings));
    }

    private AttributeNode getAttributeNode() {
        if (this.attributeNode == ATTRIBUTE_NODE_UNINITIALIZED) {
            this.attributeNode = this.createAttributeNode();
        }
        return this.attributeNode;
    }

    private static UnsupportedOperationException throwUnsupportedOperationException() {
        return new UnsupportedOperationException("Operation is not supported");
    }
}

