/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.sizes;

import com.puppycrawl.tools.checkstyle.StatelessCheck;
import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.utils.AnnotationUtil;
import com.puppycrawl.tools.checkstyle.utils.CommonUtil;
import java.util.Collections;
import java.util.Set;

@StatelessCheck
public class ParameterNumberCheck
extends AbstractCheck {
    public static final String MSG_KEY = "maxParam";
    private static final int DEFAULT_MAX_PARAMETERS = 7;
    private int max = 7;
    private boolean ignoreOverriddenMethods;
    private Set<String> ignoreAnnotatedBy = Collections.emptySet();

    public void setMax(int max) {
        this.max = max;
    }

    public void setIgnoreOverriddenMethods(boolean ignoreOverriddenMethods) {
        this.ignoreOverriddenMethods = ignoreOverriddenMethods;
    }

    public void setIgnoreAnnotatedBy(String ... annotationNames) {
        this.ignoreAnnotatedBy = Set.of(annotationNames);
    }

    @Override
    public int[] getDefaultTokens() {
        return this.getAcceptableTokens();
    }

    @Override
    public int[] getAcceptableTokens() {
        return new int[]{9, 8};
    }

    @Override
    public int[] getRequiredTokens() {
        return CommonUtil.EMPTY_INT_ARRAY;
    }

    @Override
    public void visitToken(DetailAST ast) {
        DetailAST params = ast.findFirstToken(20);
        int count = params.getChildCount(21);
        if (count > this.max && !this.shouldIgnoreNumberOfParameters(ast)) {
            DetailAST name = ast.findFirstToken(58);
            this.log(name, MSG_KEY, this.max, count);
        }
    }

    private boolean shouldIgnoreNumberOfParameters(DetailAST ast) {
        return this.isIgnoredOverriddenMethod(ast) || this.isAnnotatedByIgnoredAnnotations(ast);
    }

    private boolean isIgnoredOverriddenMethod(DetailAST ast) {
        return this.ignoreOverriddenMethods && AnnotationUtil.hasOverrideAnnotation(ast);
    }

    private boolean isAnnotatedByIgnoredAnnotations(DetailAST ast) {
        return AnnotationUtil.containsAnnotation(ast, this.ignoreAnnotatedBy);
    }
}

