/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.coding;

import com.puppycrawl.tools.checkstyle.StatelessCheck;
import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.utils.TokenUtil;

@StatelessCheck
public class TextBlockGoogleStyleFormattingCheck
extends AbstractCheck {
    public static final String MSG_OPEN_QUOTES_ERROR = "textblock.format.open";
    public static final String MSG_CLOSE_QUOTES_ERROR = "textblock.format.close";
    public static final String MSG_VERTICALLY_UNALIGNED = "textblock.vertically.unaligned";

    @Override
    public int[] getDefaultTokens() {
        return this.getRequiredTokens();
    }

    @Override
    public int[] getAcceptableTokens() {
        return this.getRequiredTokens();
    }

    @Override
    public int[] getRequiredTokens() {
        return new int[]{204};
    }

    @Override
    public void visitToken(DetailAST ast) {
        DetailAST closingQuotes;
        if (!TextBlockGoogleStyleFormattingCheck.openingQuotesAreAloneOnTheLine(ast)) {
            this.log(ast, MSG_OPEN_QUOTES_ERROR, new Object[0]);
        }
        if (!TextBlockGoogleStyleFormattingCheck.closingQuotesAreAloneOnTheLine(closingQuotes = TextBlockGoogleStyleFormattingCheck.getClosingQuotes(ast))) {
            this.log(closingQuotes, MSG_CLOSE_QUOTES_ERROR, new Object[0]);
        }
        if (!TextBlockGoogleStyleFormattingCheck.quotesAreVerticallyAligned(ast, closingQuotes)) {
            this.log(closingQuotes, MSG_VERTICALLY_UNALIGNED, new Object[0]);
        }
    }

    private static boolean quotesAreVerticallyAligned(DetailAST openQuotes, DetailAST closeQuotes) {
        return openQuotes.getColumnNo() == closeQuotes.getColumnNo();
    }

    private static DetailAST getClosingQuotes(DetailAST ast) {
        return ast.getFirstChild().getNextSibling();
    }

    private static boolean openingQuotesAreAloneOnTheLine(DetailAST openingQuotes) {
        DetailAST parent = openingQuotes;
        boolean quotesAreNotPreceded = true;
        while (quotesAreNotPreceded || parent.getType() == 34 || parent.getType() == 28) {
            if ((parent = parent.getParent()).getType() == 9) {
                quotesAreNotPreceded = !TextBlockGoogleStyleFormattingCheck.quotesArePrecededWithComma(openingQuotes);
            } else if (parent.getType() == 109 && openingQuotes.getPreviousSibling() != null) {
                quotesAreNotPreceded = !TokenUtil.areOnSameLine(openingQuotes, openingQuotes.getPreviousSibling());
            } else {
                boolean bl = quotesAreNotPreceded = !TokenUtil.areOnSameLine(openingQuotes, parent);
            }
            if (!TokenUtil.isOfType(parent.getType(), 88, 10, 9, 8, 154)) continue;
            break;
        }
        return quotesAreNotPreceded;
    }

    private static boolean quotesArePrecededWithComma(DetailAST openingQuotes) {
        DetailAST expression = openingQuotes.getParent();
        return expression.getPreviousSibling() != null && TokenUtil.areOnSameLine(openingQuotes, expression.getPreviousSibling());
    }

    private static boolean closingQuotesAreAloneOnTheLine(DetailAST closingQuotes) {
        DetailAST content = closingQuotes.getPreviousSibling();
        String text = content.getText();
        int index = text.length() - 1;
        while (text.charAt(index) == ' ') {
            --index;
        }
        return Character.isWhitespace(text.charAt(index));
    }
}

