/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.annotation;

import com.puppycrawl.tools.checkstyle.StatelessCheck;
import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.utils.AnnotationUtil;
import com.puppycrawl.tools.checkstyle.utils.CommonUtil;
import java.util.ArrayDeque;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@StatelessCheck
public class SuppressWarningsCheck
extends AbstractCheck {
    public static final String MSG_KEY_SUPPRESSED_WARNING_NOT_ALLOWED = "suppressed.warning.not.allowed";
    private static final String SUPPRESS_WARNINGS = "SuppressWarnings";
    private static final String FQ_SUPPRESS_WARNINGS = "java.lang.SuppressWarnings";
    private Pattern format = Pattern.compile("^\\s*+$");

    public final void setFormat(Pattern pattern) {
        this.format = pattern;
    }

    @Override
    public final int[] getDefaultTokens() {
        return this.getAcceptableTokens();
    }

    @Override
    public final int[] getAcceptableTokens() {
        return new int[]{14, 15, 154, 157, 161, 155, 21, 10, 9, 8, 203, 199, 198};
    }

    @Override
    public int[] getRequiredTokens() {
        return CommonUtil.EMPTY_INT_ARRAY;
    }

    @Override
    public void visitToken(DetailAST ast) {
        DetailAST annotation = SuppressWarningsCheck.getSuppressWarnings(ast);
        if (annotation != null) {
            DetailAST warningHolder = SuppressWarningsCheck.findWarningsHolder(annotation);
            DetailAST token = warningHolder.findFirstToken(160);
            DetailAST parent = Objects.requireNonNullElse(token, warningHolder);
            DetailAST warning = parent.findFirstToken(28);
            if (warning == null) {
                this.logMatch(warningHolder, "");
            } else {
                this.processWarnings(warning);
            }
        }
    }

    private void processWarnings(DetailAST warning) {
        for (DetailAST current = warning; current != null; current = current.getNextSibling()) {
            if (current.getType() != 28) continue;
            this.processWarningExpr(current.getFirstChild(), current);
        }
    }

    private void processWarningExpr(DetailAST fChild, DetailAST warning) {
        switch (fChild.getType()) {
            case 139: {
                this.logMatch(warning, SuppressWarningsCheck.removeQuotes(warning.getFirstChild().getText()));
                break;
            }
            case 109: {
                this.walkConditional(fChild);
                break;
            }
        }
    }

    private static DetailAST getSuppressWarnings(DetailAST ast) {
        DetailAST annotation = AnnotationUtil.getAnnotation(ast, SUPPRESS_WARNINGS);
        if (annotation == null) {
            annotation = AnnotationUtil.getAnnotation(ast, FQ_SUPPRESS_WARNINGS);
        }
        return annotation;
    }

    private void logMatch(DetailAST ast, String warningText) {
        Matcher matcher = this.format.matcher(warningText);
        if (matcher.matches()) {
            this.log(ast, MSG_KEY_SUPPRESSED_WARNING_NOT_ALLOWED, warningText);
        }
    }

    private static DetailAST findWarningsHolder(DetailAST annotation) {
        DetailAST annValuePair = annotation.findFirstToken(160);
        DetailAST annArrayInitParent = Objects.requireNonNullElse(annValuePair, annotation);
        DetailAST annArrayInit = annArrayInitParent.findFirstToken(162);
        return Objects.requireNonNullElse(annArrayInit, annotation);
    }

    private static String removeQuotes(String warning) {
        return warning.substring(1, warning.length() - 1);
    }

    private void walkConditional(DetailAST cond) {
        ArrayDeque<DetailAST> condStack = new ArrayDeque<DetailAST>();
        condStack.push(cond);
        while (!condStack.isEmpty()) {
            DetailAST currentCond = (DetailAST)condStack.pop();
            if (currentCond.getType() == 109) {
                condStack.push(SuppressWarningsCheck.getCondRight(currentCond));
                condStack.push(SuppressWarningsCheck.getCondLeft(currentCond));
                continue;
            }
            String warningText = SuppressWarningsCheck.removeQuotes(currentCond.getText());
            this.logMatch(currentCond, warningText);
        }
    }

    private static DetailAST getCondLeft(DetailAST cond) {
        DetailAST colon = cond.findFirstToken(82);
        return colon.getPreviousSibling();
    }

    private static DetailAST getCondRight(DetailAST cond) {
        DetailAST colon = cond.findFirstToken(82);
        return colon.getNextSibling();
    }
}

