/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.design;

import com.puppycrawl.tools.checkstyle.StatelessCheck;
import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.utils.TokenUtil;

@StatelessCheck
public class OneTopLevelClassCheck
extends AbstractCheck {
    public static final String MSG_KEY = "one.top.level.class";

    @Override
    public int[] getDefaultTokens() {
        return this.getRequiredTokens();
    }

    @Override
    public int[] getAcceptableTokens() {
        return this.getRequiredTokens();
    }

    @Override
    public int[] getRequiredTokens() {
        return new int[]{1};
    }

    @Override
    public void visitToken(DetailAST compilationUnit) {
        String typeName;
        boolean publicTypeFound = false;
        DetailAST firstType = null;
        for (DetailAST currentNode = compilationUnit.getFirstChild(); currentNode != null; currentNode = currentNode.getNextSibling()) {
            if (!OneTopLevelClassCheck.isTypeDef(currentNode)) continue;
            if (OneTopLevelClassCheck.isPublic(currentNode)) {
                publicTypeFound = true;
            }
            if (firstType == null) {
                firstType = currentNode;
                continue;
            }
            if (OneTopLevelClassCheck.isPublic(currentNode)) continue;
            typeName = currentNode.findFirstToken(58).getText();
            this.log(currentNode, MSG_KEY, typeName);
        }
        if (publicTypeFound && !OneTopLevelClassCheck.isPublic(firstType)) {
            typeName = firstType.findFirstToken(58).getText();
            this.log(firstType, MSG_KEY, typeName);
        }
    }

    private static boolean isTypeDef(DetailAST node) {
        return TokenUtil.isTypeDeclaration(node.getType());
    }

    private static boolean isPublic(DetailAST typeDef) {
        DetailAST modifiers = typeDef.findFirstToken(5);
        return modifiers.findFirstToken(62) != null;
    }
}

