/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.javadoc;

import com.puppycrawl.tools.checkstyle.StatelessCheck;
import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FileContents;
import com.puppycrawl.tools.checkstyle.api.Scope;
import com.puppycrawl.tools.checkstyle.api.TextBlock;
import com.puppycrawl.tools.checkstyle.checks.javadoc.InvalidJavadocTag;
import com.puppycrawl.tools.checkstyle.checks.javadoc.JavadocTag;
import com.puppycrawl.tools.checkstyle.checks.javadoc.JavadocTagInfo;
import com.puppycrawl.tools.checkstyle.checks.javadoc.JavadocTags;
import com.puppycrawl.tools.checkstyle.utils.AnnotationUtil;
import com.puppycrawl.tools.checkstyle.utils.CheckUtil;
import com.puppycrawl.tools.checkstyle.utils.CommonUtil;
import com.puppycrawl.tools.checkstyle.utils.JavadocUtil;
import com.puppycrawl.tools.checkstyle.utils.ScopeUtil;
import com.puppycrawl.tools.checkstyle.utils.TokenUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@StatelessCheck
public class JavadocTypeCheck
extends AbstractCheck {
    public static final String MSG_UNKNOWN_TAG = "javadoc.unknownTag";
    public static final String MSG_TAG_FORMAT = "type.tagFormat";
    public static final String MSG_MISSING_TAG = "type.missingTag";
    public static final String MSG_UNUSED_TAG = "javadoc.unusedTag";
    public static final String MSG_UNUSED_TAG_GENERAL = "javadoc.unusedTagGeneral";
    private static final String OPEN_ANGLE_BRACKET = "<";
    private static final String CLOSE_ANGLE_BRACKET = ">";
    private static final String SPACE = " ";
    private static final String JAVADOC_TAG_TOKEN = "@";
    private static final Pattern TYPE_NAME_IN_JAVADOC_TAG = Pattern.compile("^<([^>]+)");
    private static final Pattern TYPE_NAME_IN_JAVADOC_TAG_SPLITTER = Pattern.compile("\\s+");
    private Scope scope = Scope.PRIVATE;
    private Scope excludeScope;
    private Pattern authorFormat;
    private Pattern versionFormat;
    private boolean allowMissingParamTags;
    private boolean allowUnknownTags;
    private Set<String> allowedAnnotations = Set.of("Generated");

    public void setScope(Scope scope) {
        this.scope = scope;
    }

    public void setExcludeScope(Scope excludeScope) {
        this.excludeScope = excludeScope;
    }

    public void setAuthorFormat(Pattern pattern) {
        this.authorFormat = pattern;
    }

    public void setVersionFormat(Pattern pattern) {
        this.versionFormat = pattern;
    }

    public void setAllowMissingParamTags(boolean flag) {
        this.allowMissingParamTags = flag;
    }

    public void setAllowUnknownTags(boolean flag) {
        this.allowUnknownTags = flag;
    }

    public void setAllowedAnnotations(String ... userAnnotations) {
        this.allowedAnnotations = Set.of(userAnnotations);
    }

    @Override
    public int[] getDefaultTokens() {
        return this.getAcceptableTokens();
    }

    @Override
    public int[] getAcceptableTokens() {
        return new int[]{15, 14, 154, 157, 199};
    }

    @Override
    public int[] getRequiredTokens() {
        return CommonUtil.EMPTY_INT_ARRAY;
    }

    @Override
    public void visitToken(DetailAST ast) {
        int lineNo;
        FileContents contents;
        TextBlock textBlock;
        if (this.shouldCheck(ast) && (textBlock = (contents = this.getFileContents()).getJavadocBefore(lineNo = ast.getLineNo())) != null) {
            List<JavadocTag> tags = this.getJavadocTags(textBlock);
            if (ScopeUtil.isOuterMostType(ast)) {
                this.checkTag(ast, tags, JavadocTagInfo.AUTHOR.getName(), this.authorFormat);
                this.checkTag(ast, tags, JavadocTagInfo.VERSION.getName(), this.versionFormat);
            }
            List<String> typeParamNames = CheckUtil.getTypeParameterNames(ast);
            List<String> recordComponentNames = JavadocTypeCheck.getRecordComponentNames(ast);
            if (!this.allowMissingParamTags) {
                typeParamNames.forEach(typeParamName -> this.checkTypeParamTag(ast, (Collection<JavadocTag>)tags, (String)typeParamName));
                recordComponentNames.forEach(componentName -> this.checkComponentParamTag(ast, (Collection<JavadocTag>)tags, (String)componentName));
            }
            this.checkUnusedParamTags(tags, typeParamNames, recordComponentNames);
        }
    }

    private boolean shouldCheck(DetailAST ast) {
        Scope surroundingScope = ScopeUtil.getSurroundingScope(ast);
        return surroundingScope.isIn(this.scope) && (this.excludeScope == null || !surroundingScope.isIn(this.excludeScope)) && !AnnotationUtil.containsAnnotation(ast, this.allowedAnnotations);
    }

    private List<JavadocTag> getJavadocTags(TextBlock textBlock) {
        JavadocTags tags = JavadocUtil.getJavadocTags(textBlock, JavadocUtil.JavadocTagType.BLOCK);
        if (!this.allowUnknownTags) {
            String[] lines = textBlock.getText();
            tags.getInvalidTags().stream().filter(tag -> !JavadocTypeCheck.isTagInsideCodeOrLiteralBlock(lines, textBlock, tag)).forEach(tag -> this.log(tag.getLine(), tag.getCol(), MSG_UNKNOWN_TAG, tag.getName()));
        }
        return tags.getValidTags();
    }

    private static boolean isTagInsideCodeOrLiteralBlock(String[] lines, TextBlock textBlock, InvalidJavadocTag tag) {
        int tagLineIndex = tag.getLine() - textBlock.getStartLineNo();
        String textBefore = String.join((CharSequence)"\n", Arrays.copyOfRange(lines, 0, tagLineIndex));
        return JavadocTypeCheck.isInsideInlineTag(textBefore);
    }

    private static boolean isInsideInlineTag(String textBefore) {
        boolean insideVerbatimTag = false;
        int braceDepth = 0;
        for (int index = 0; index < textBefore.length(); ++index) {
            char ch = textBefore.charAt(index);
            if (ch == '{') {
                if (textBefore.startsWith("{@code", index) || textBefore.startsWith("{@literal", index) || textBefore.startsWith("{@snippet", index)) {
                    insideVerbatimTag = true;
                }
                ++braceDepth;
                continue;
            }
            if (ch != '}' || --braceDepth != 0) continue;
            insideVerbatimTag = false;
        }
        return insideVerbatimTag;
    }

    private void checkTag(DetailAST ast, Iterable<JavadocTag> tags, String tagName, Pattern formatPattern) {
        if (formatPattern != null) {
            boolean hasTag = false;
            for (JavadocTag tag : tags) {
                if (!tag.getTagName().equals(tagName)) continue;
                hasTag = true;
                if (formatPattern.matcher(tag.getFirstArg()).find()) continue;
                this.log(ast, MSG_TAG_FORMAT, JAVADOC_TAG_TOKEN + tagName, formatPattern.pattern());
            }
            if (!hasTag) {
                this.log(ast, MSG_MISSING_TAG, JAVADOC_TAG_TOKEN + tagName);
            }
        }
    }

    private void checkComponentParamTag(DetailAST ast, Collection<JavadocTag> tags, String recordComponentName) {
        boolean found = tags.stream().filter(JavadocTag::isParamTag).anyMatch(tag -> tag.getFirstArg().indexOf(recordComponentName) == 0);
        if (!found) {
            this.log(ast, MSG_MISSING_TAG, JavadocTagInfo.PARAM.getText() + SPACE + recordComponentName);
        }
    }

    private void checkTypeParamTag(DetailAST ast, Collection<JavadocTag> tags, String typeParamName) {
        String typeParamNameWithBrackets = OPEN_ANGLE_BRACKET + typeParamName + CLOSE_ANGLE_BRACKET;
        boolean found = tags.stream().filter(JavadocTag::isParamTag).anyMatch(tag -> tag.getFirstArg().indexOf(typeParamNameWithBrackets) == 0);
        if (!found) {
            this.log(ast, MSG_MISSING_TAG, JavadocTagInfo.PARAM.getText() + SPACE + typeParamNameWithBrackets);
        }
    }

    private void checkUnusedParamTags(List<JavadocTag> tags, List<String> typeParamNames, List<String> recordComponentNames) {
        for (JavadocTag tag : tags) {
            String paramName;
            boolean found;
            if (!tag.isParamTag() || (found = typeParamNames.contains(paramName = JavadocTypeCheck.extractParamNameFromTag(tag)) || recordComponentNames.contains(paramName))) continue;
            String displayName = TYPE_NAME_IN_JAVADOC_TAG_SPLITTER.split(tag.getFirstArg(), -1)[0];
            if (displayName.isEmpty()) {
                this.log(tag.getLineNo(), tag.getColumnNo(), MSG_UNUSED_TAG_GENERAL, new Object[0]);
                continue;
            }
            this.log(tag.getLineNo(), tag.getColumnNo(), MSG_UNUSED_TAG, JavadocTagInfo.PARAM.getText(), displayName);
        }
    }

    private static String extractParamNameFromTag(JavadocTag tag) {
        String firstArg = tag.getFirstArg();
        Matcher matchInAngleBrackets = TYPE_NAME_IN_JAVADOC_TAG.matcher(firstArg);
        String paramName = matchInAngleBrackets.find() ? matchInAngleBrackets.group(1).trim() : TYPE_NAME_IN_JAVADOC_TAG_SPLITTER.split(firstArg, -1)[0];
        return paramName;
    }

    private static List<String> getRecordComponentNames(DetailAST node) {
        DetailAST components = node.findFirstToken(201);
        ArrayList<String> componentList = new ArrayList<String>();
        if (components != null) {
            TokenUtil.forEachChild(components, 202, component -> {
                DetailAST ident = component.findFirstToken(58);
                componentList.add(ident.getText());
            });
        }
        return componentList;
    }
}

