/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.xpath.iterators;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Queue;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.tree.iter.AxisIterator;

public class ReverseDescendantIterator
implements AxisIterator {
    private final Queue<NodeInfo> queue = new ArrayDeque<NodeInfo>();
    private final Deque<NodeInfo> stack = new ArrayDeque<NodeInfo>();

    public ReverseDescendantIterator(NodeInfo start) {
        this.pushToStack(start.iterateAxis(3));
    }

    private void pushToStack(AxisIterator iterateAxis) {
        NodeInfo nodeInfo = iterateAxis.next();
        while (nodeInfo != null) {
            this.stack.addLast(nodeInfo);
            nodeInfo = iterateAxis.next();
        }
    }

    public NodeInfo next() {
        NodeInfo result = null;
        do {
            if (this.stack.isEmpty()) {
                if (this.queue.isEmpty()) break;
                this.pushToStack(this.queue.poll().iterateAxis(3));
                continue;
            }
            result = this.stack.removeLast();
        } while (result == null);
        if (result != null) {
            this.queue.add(result);
        }
        return result;
    }
}

