/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.design;

import com.puppycrawl.tools.checkstyle.StatelessCheck;
import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.utils.AnnotationUtil;
import java.util.Collections;
import java.util.Set;

@StatelessCheck
public class HideUtilityClassConstructorCheck
extends AbstractCheck {
    public static final String MSG_KEY = "hide.utility.class";
    private Set<String> ignoreAnnotatedBy = Collections.emptySet();

    public void setIgnoreAnnotatedBy(String ... annotationNames) {
        this.ignoreAnnotatedBy = Set.of(annotationNames);
    }

    @Override
    public int[] getDefaultTokens() {
        return this.getRequiredTokens();
    }

    @Override
    public int[] getAcceptableTokens() {
        return this.getRequiredTokens();
    }

    @Override
    public int[] getRequiredTokens() {
        return new int[]{14};
    }

    @Override
    public void visitToken(DetailAST ast) {
        if (!HideUtilityClassConstructorCheck.isAbstract(ast) && !this.shouldIgnoreClass(ast)) {
            boolean isUtilClass;
            boolean hasStaticModifier = HideUtilityClassConstructorCheck.isStatic(ast);
            Details details = new Details(ast);
            details.invoke();
            boolean hasDefaultCtor = details.isHasDefaultCtor();
            boolean hasPublicCtor = details.isHasPublicCtor();
            boolean hasNonStaticMethodOrField = details.isHasNonStaticMethodOrField();
            boolean hasNonPrivateStaticMethodOrField = details.isHasNonPrivateStaticMethodOrField();
            boolean hasAccessibleCtor = hasDefaultCtor || hasPublicCtor;
            boolean extendsJlo = ast.findFirstToken(18) == null;
            boolean bl = isUtilClass = extendsJlo && !hasNonStaticMethodOrField && hasNonPrivateStaticMethodOrField;
            if (isUtilClass && hasAccessibleCtor && !hasStaticModifier) {
                this.log(ast, MSG_KEY, new Object[0]);
            }
        }
    }

    private static boolean isAbstract(DetailAST ast) {
        return ast.findFirstToken(5).findFirstToken(40) != null;
    }

    private static boolean isStatic(DetailAST ast) {
        return ast.findFirstToken(5).findFirstToken(64) != null;
    }

    private boolean shouldIgnoreClass(DetailAST ast) {
        return AnnotationUtil.containsAnnotation(ast, this.ignoreAnnotatedBy);
    }

    private static final class Details {
        private final DetailAST ast;
        private boolean hasNonStaticMethodOrField;
        private boolean hasNonPrivateStaticMethodOrField;
        private boolean hasDefaultCtor;
        private boolean hasPublicCtor;

        private Details(DetailAST ast) {
            this.ast = ast;
        }

        boolean isHasNonStaticMethodOrField() {
            return this.hasNonStaticMethodOrField;
        }

        boolean isHasNonPrivateStaticMethodOrField() {
            return this.hasNonPrivateStaticMethodOrField;
        }

        boolean isHasDefaultCtor() {
            return this.hasDefaultCtor;
        }

        boolean isHasPublicCtor() {
            return this.hasPublicCtor;
        }

        void invoke() {
            DetailAST objBlock = this.ast.findFirstToken(6);
            this.hasDefaultCtor = true;
            for (DetailAST child = objBlock.getFirstChild(); child != null; child = child.getNextSibling()) {
                DetailAST modifiers;
                int type = child.getType();
                if (type == 9 || type == 10) {
                    boolean isStatic;
                    modifiers = child.findFirstToken(5);
                    boolean bl = isStatic = modifiers.findFirstToken(64) != null;
                    if (isStatic) {
                        boolean isPrivate;
                        boolean bl2 = isPrivate = modifiers.findFirstToken(61) != null;
                        if (!isPrivate) {
                            this.hasNonPrivateStaticMethodOrField = true;
                        }
                    } else {
                        this.hasNonStaticMethodOrField = true;
                    }
                }
                if (type != 8) continue;
                this.hasDefaultCtor = false;
                modifiers = child.findFirstToken(5);
                if (modifiers.findFirstToken(61) != null || modifiers.findFirstToken(63) != null) continue;
                this.hasPublicCtor = true;
            }
        }
    }
}

