/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.javadoc;

import com.puppycrawl.tools.checkstyle.FileStatefulCheck;
import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FileContents;
import com.puppycrawl.tools.checkstyle.api.Scope;
import com.puppycrawl.tools.checkstyle.api.TextBlock;
import com.puppycrawl.tools.checkstyle.utils.AnnotationUtil;
import com.puppycrawl.tools.checkstyle.utils.CommonUtil;
import com.puppycrawl.tools.checkstyle.utils.ScopeUtil;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@FileStatefulCheck
public class MissingJavadocMethodCheck
extends AbstractCheck {
    public static final String MSG_JAVADOC_MISSING = "javadoc.missing";
    private static final int SETTER_GETTER_MAX_CHILDREN = 7;
    private static final Pattern GETTER_PATTERN = Pattern.compile("^(is|get)[A-Z].*");
    private static final Pattern SETTER_PATTERN = Pattern.compile("^set[A-Z].*");
    private static final int SETTER_BODY_SIZE = 3;
    private static final int DEFAULT_MIN_LINE_COUNT = -1;
    private Scope scope = Scope.PUBLIC;
    private Scope excludeScope;
    private int minLineCount = -1;
    private boolean allowMissingPropertyJavadoc;
    private Pattern ignoreMethodNamesRegex;
    private Set<String> allowedAnnotations = Set.of("Override");

    public void setAllowedAnnotations(String ... userAnnotations) {
        this.allowedAnnotations = Set.of(userAnnotations);
    }

    public void setIgnoreMethodNamesRegex(Pattern pattern) {
        this.ignoreMethodNamesRegex = pattern;
    }

    public void setMinLineCount(int value) {
        this.minLineCount = value;
    }

    public void setAllowMissingPropertyJavadoc(boolean flag) {
        this.allowMissingPropertyJavadoc = flag;
    }

    public void setScope(Scope scope) {
        this.scope = scope;
    }

    public void setExcludeScope(Scope excludeScope) {
        this.excludeScope = excludeScope;
    }

    @Override
    public final int[] getRequiredTokens() {
        return CommonUtil.EMPTY_INT_ARRAY;
    }

    @Override
    public int[] getDefaultTokens() {
        return this.getAcceptableTokens();
    }

    @Override
    public int[] getAcceptableTokens() {
        return new int[]{9, 8, 161, 203};
    }

    @Override
    public final void visitToken(DetailAST ast) {
        FileContents contents;
        TextBlock textBlock;
        Scope theScope = ScopeUtil.getScope(ast);
        if (this.shouldCheck(ast, theScope) && (textBlock = (contents = this.getFileContents()).getJavadocBefore(ast.getLineNo())) == null && !this.isMissingJavadocAllowed(ast)) {
            this.log(ast, MSG_JAVADOC_MISSING, new Object[0]);
        }
    }

    private static int getMethodsNumberOfLine(DetailAST methodDef) {
        DetailAST lcurly = methodDef.getLastChild();
        DetailAST rcurly = lcurly.getLastChild();
        int numberOfLines = lcurly.getFirstChild() == rcurly ? 1 : rcurly.getLineNo() - lcurly.getLineNo() - 1;
        return numberOfLines;
    }

    private boolean isMissingJavadocAllowed(DetailAST ast) {
        return this.allowMissingPropertyJavadoc && (MissingJavadocMethodCheck.isSetterMethod(ast) || MissingJavadocMethodCheck.isGetterMethod(ast)) || this.matchesSkipRegex(ast) || this.isContentsAllowMissingJavadoc(ast);
    }

    private boolean isContentsAllowMissingJavadoc(DetailAST ast) {
        return ast.getType() != 161 && (MissingJavadocMethodCheck.getMethodsNumberOfLine(ast) <= this.minLineCount || AnnotationUtil.containsAnnotation(ast, this.allowedAnnotations));
    }

    private boolean matchesSkipRegex(DetailAST methodDef) {
        DetailAST ident;
        String methodName;
        Matcher matcher;
        boolean result = false;
        if (this.ignoreMethodNamesRegex != null && (matcher = this.ignoreMethodNamesRegex.matcher(methodName = (ident = methodDef.findFirstToken(58)).getText())).matches()) {
            result = true;
        }
        return result;
    }

    private boolean shouldCheck(DetailAST ast, Scope nodeScope) {
        return ScopeUtil.getSurroundingScope(ast).map(surroundingScope -> nodeScope != this.excludeScope && surroundingScope != this.excludeScope && nodeScope.isIn(this.scope) && surroundingScope.isIn(this.scope)).orElse(Boolean.FALSE);
    }

    public static boolean isGetterMethod(DetailAST ast) {
        boolean getterMethod = false;
        if (ast.getType() == 9 && ast.getChildCount() == 7) {
            DetailAST slist;
            boolean noParams;
            DetailAST type = ast.findFirstToken(13);
            String name = type.getNextSibling().getText();
            boolean matchesGetterFormat = GETTER_PATTERN.matcher(name).matches();
            DetailAST params = ast.findFirstToken(20);
            boolean bl = noParams = params.getChildCount(21) == 0;
            if (matchesGetterFormat && noParams && (slist = ast.findFirstToken(7)) != null) {
                DetailAST expr = slist.getFirstChild();
                getterMethod = expr.getType() == 88;
            }
        }
        return getterMethod;
    }

    public static boolean isSetterMethod(DetailAST ast) {
        boolean setterMethod = false;
        if (ast.getType() == 9 && ast.getChildCount() == 7) {
            DetailAST slist;
            boolean singleParam;
            DetailAST type = ast.findFirstToken(13);
            String name = type.getNextSibling().getText();
            boolean matchesSetterFormat = SETTER_PATTERN.matcher(name).matches();
            DetailAST params = ast.findFirstToken(20);
            boolean bl = singleParam = params.getChildCount(21) == 1;
            if (matchesSetterFormat && singleParam && (slist = ast.findFirstToken(7)) != null && slist.getChildCount() == 3) {
                DetailAST expr = slist.getFirstChild();
                setterMethod = expr.getFirstChild().getType() == 80;
            }
        }
        return setterMethod;
    }
}

