/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.regexp;

import com.puppycrawl.tools.checkstyle.api.FileText;
import com.puppycrawl.tools.checkstyle.checks.regexp.DetectorOptions;
import java.util.regex.Matcher;

public class SinglelineDetector {
    public static final String MSG_REGEXP_EXCEEDED = "regexp.exceeded";
    public static final String MSG_REGEXP_MINIMUM = "regexp.minimum";
    private final DetectorOptions options;
    private int currentMatches;

    SinglelineDetector(DetectorOptions options) {
        this.options = options;
    }

    public void processLines(FileText fileText) {
        this.currentMatches = 0;
        int lineNo = 0;
        for (int index = 0; index < fileText.size(); ++index) {
            String line = fileText.get(index);
            this.checkLine(++lineNo, this.options.getPattern().matcher(line));
        }
        this.finish();
    }

    private void finish() {
        if (this.currentMatches < this.options.getMinimum()) {
            if (this.options.getMessage().isEmpty()) {
                this.options.getReporter().log(1, MSG_REGEXP_MINIMUM, this.options.getMinimum(), this.options.getFormat());
            } else {
                this.options.getReporter().log(1, this.options.getMessage(), new Object[0]);
            }
        }
    }

    private void checkLine(int lineNo, Matcher matcher) {
        int startPosition = 0;
        while (matcher.find(startPosition)) {
            int startCol = matcher.start(0);
            int endCol = matcher.end(0);
            if (this.options.getSuppressor().shouldSuppress(lineNo, startCol, lineNo, endCol - 1)) {
                startPosition = endCol;
                continue;
            }
            ++this.currentMatches;
            if (this.currentMatches <= this.options.getMaximum()) break;
            if (this.options.getMessage().isEmpty()) {
                this.options.getReporter().log(lineNo, MSG_REGEXP_EXCEEDED, matcher.pattern().toString());
                break;
            }
            this.options.getReporter().log(lineNo, this.options.getMessage(), new Object[0]);
            break;
        }
    }
}

