/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.filters;

import com.puppycrawl.tools.checkstyle.filters.IntFilterElement;
import com.puppycrawl.tools.checkstyle.filters.IntMatchFilterElement;
import com.puppycrawl.tools.checkstyle.filters.IntRangeFilterElement;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.StringTokenizer;

final class CsvFilterElement
implements IntFilterElement {
    private final Set<IntFilterElement> filters = new HashSet<IntFilterElement>();

    CsvFilterElement(String pattern) {
        StringTokenizer tokenizer = new StringTokenizer(pattern, ",");
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken().trim();
            int index = token.indexOf(45);
            if (index == -1) {
                int matchValue = Integer.parseInt(token);
                this.addFilter(new IntMatchFilterElement(matchValue));
                continue;
            }
            int lowerBound = Integer.parseInt(token.substring(0, index));
            int upperBound = Integer.parseInt(token.substring(index + 1));
            this.addFilter(new IntRangeFilterElement(lowerBound, upperBound));
        }
    }

    private void addFilter(IntFilterElement filter) {
        this.filters.add(filter);
    }

    private Set<IntFilterElement> getFilters() {
        return Collections.unmodifiableSet(this.filters);
    }

    @Override
    public boolean accept(int intValue) {
        boolean result = false;
        for (IntFilterElement filter : this.getFilters()) {
            if (!filter.accept(intValue)) continue;
            result = true;
            break;
        }
        return result;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        CsvFilterElement csvFilter = (CsvFilterElement)object;
        return Objects.equals(this.filters, csvFilter.filters);
    }

    public int hashCode() {
        return Objects.hash(this.filters);
    }
}

