/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.imports;

import com.google.common.collect.ImmutableMap;
import java.io.Serializable;

final class AccessResult
implements Serializable {
    private static final int CODE_ALLOWED = 10;
    private static final int CODE_DISALLOWED = 20;
    private static final int CODE_UNKNOWN = 30;
    private static final String LABEL_ALLOWED = "ALLOWED";
    private static final String LABEL_DISALLOWED = "DISALLOWED";
    private static final String LABEL_UNKNOWN = "UNKNOWN";
    public static final AccessResult ALLOWED = new AccessResult(10, "ALLOWED");
    public static final AccessResult DISALLOWED = new AccessResult(20, "DISALLOWED");
    public static final AccessResult UNKNOWN = new AccessResult(30, "UNKNOWN");
    private static final ImmutableMap<String, AccessResult> NAME_TO_LEVEL;
    private final int mCode;
    private final String mLabel;

    private AccessResult(int aCode, String aLabel) {
        this.mCode = aCode;
        this.mLabel = aLabel.trim();
    }

    String getLabel() {
        return this.mLabel;
    }

    public String toString() {
        return this.getLabel();
    }

    public boolean equals(Object aObj) {
        boolean result = false;
        if (aObj instanceof AccessResult && ((AccessResult)aObj).mCode == this.mCode) {
            result = true;
        }
        return result;
    }

    public int hashCode() {
        return this.mCode;
    }

    public static AccessResult getInstance(String aName) {
        String arName = aName.trim();
        AccessResult retVal = (AccessResult)NAME_TO_LEVEL.get((Object)arName);
        if (retVal == null) {
            throw new IllegalArgumentException(arName);
        }
        return retVal;
    }

    private Object readResolve() {
        return AccessResult.getInstance(this.mLabel);
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)LABEL_ALLOWED, (Object)ALLOWED);
        builder.put((Object)LABEL_DISALLOWED, (Object)DISALLOWED);
        builder.put((Object)LABEL_UNKNOWN, (Object)UNKNOWN);
        NAME_TO_LEVEL = builder.build();
    }
}

